/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.dialogue.DialogueScreen;
import com.cmdpro.databank.networking.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ChangeDialogueEntryS2CPacket(String entry) implements Message
{
    public static final CustomPacketPayload.Type<ChangeDialogueEntryS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("change_dialogue_entry"));

    public static ChangeDialogueEntryS2CPacket read(FriendlyByteBuf buf) {
        String entry = buf.readUtf();
        return new ChangeDialogueEntryS2CPacket(entry);
    }

    public static void write(FriendlyByteBuf buf, ChangeDialogueEntryS2CPacket obj) {
        buf.writeUtf(obj.entry);
    }

    public CustomPacketPayload.Type<ChangeDialogueEntryS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        ClientHandler.changeEntry(this.entry);
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void changeEntry(String entry) {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof DialogueScreen) {
                DialogueScreen dialogueScreen = (DialogueScreen)screen;
                dialogueScreen.changeEntry(dialogueScreen.instance.entry.id, entry);
                dialogueScreen.instance.setEntry(entry);
            }
        }
    }
}

