/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.dialogue.DialogueChoice;
import com.cmdpro.databank.dialogue.DialogueChoiceAction;
import com.cmdpro.databank.dialogue.DialogueInstance;
import com.cmdpro.databank.networking.Message;
import com.cmdpro.databank.registry.AttachmentTypeRegistry;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClickChoiceC2SPacket(int choice) implements Message
{
    public static final CustomPacketPayload.Type<ClickChoiceC2SPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("click_choice"));

    public static ClickChoiceC2SPacket read(FriendlyByteBuf buf) {
        int choice = buf.readInt();
        return new ClickChoiceC2SPacket(choice);
    }

    public static void write(FriendlyByteBuf buf, ClickChoiceC2SPacket obj) {
        buf.writeInt(obj.choice);
    }

    public CustomPacketPayload.Type<ClickChoiceC2SPacket> type() {
        return TYPE;
    }

    @Override
    public void handleServer(MinecraftServer server, ServerPlayer player, IPayloadContext context) {
        Optional dialogue = (Optional)player.getData(AttachmentTypeRegistry.CURRENT_DIALOGUE);
        if (dialogue.isPresent() && this.choice >= 0 && this.choice < ((DialogueInstance)dialogue.get()).entry.choices.size()) {
            DialogueChoice choice = ((DialogueInstance)dialogue.get()).entry.choices.get(this.choice);
            for (DialogueChoiceAction i : choice.actions) {
                i.onClick((Player)player, (DialogueInstance)dialogue.get(), choice);
            }
        }
    }
}

