/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.rendering;

import com.cmdpro.databank.ClientDatabankUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public record NineSliceSprite(ResourceLocation texture, int u, int v, int width, int height, int top, int bottom, int left, int right, int defaultInset) {
    public static final Codec<NineSliceSprite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(data -> data.texture), (App)Codec.INT.fieldOf("u").forGetter(data -> data.u), (App)Codec.INT.fieldOf("v").forGetter(data -> data.v), (App)Codec.INT.fieldOf("width").forGetter(data -> data.width), (App)Codec.INT.fieldOf("height").forGetter(data -> data.height), (App)Codec.INT.fieldOf("top").forGetter(data -> data.top), (App)Codec.INT.fieldOf("bottom").forGetter(data -> data.bottom), (App)Codec.INT.fieldOf("left").forGetter(data -> data.left), (App)Codec.INT.fieldOf("right").forGetter(data -> data.right), (App)Codec.INT.optionalFieldOf("defaultInset", (Object)0).forGetter(data -> data.defaultInset)).apply((Applicative)instance, NineSliceSprite::new));

    public int getHorizontal() {
        return this.left + this.right;
    }

    public int getVertical() {
        return this.top + this.bottom;
    }

    public int getHorizontalInset(int inset) {
        return this.left + this.right - inset * 2;
    }

    public int getVerticalInset(int inset) {
        return this.top + this.bottom - inset * 2;
    }

    public int getHorizontalInset() {
        return this.getHorizontalInset(this.defaultInset);
    }

    public int getVerticalInset() {
        return this.getVerticalInset(this.defaultInset);
    }

    public void blit(GuiGraphics graphics, int x, int y, int width, int height) {
        this.blit(graphics, x, y, width, height, this.defaultInset);
    }

    public void blit(GuiGraphics graphics, int x, int y, int width, int height, int inset) {
        NineSliceSprite.blit(graphics, this.texture, x, y, this.u, this.v, width, height, this.width, this.height, this.top, this.bottom, this.left, this.right, inset);
    }

    public static void blit(GuiGraphics graphics, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, int inset) {
        graphics.blit(texture, x - leftBorder + inset, y - topBorder + inset, u, v, leftBorder, topBorder);
        graphics.blit(texture, x + width - inset, y - topBorder + inset, u + textureWidth - rightBorder, v, rightBorder, topBorder);
        graphics.blit(texture, x - leftBorder + inset, y + height - inset, u, v + textureHeight - bottomBorder, leftBorder, bottomBorder);
        graphics.blit(texture, x + width - inset, y + height - inset, u + textureWidth - rightBorder, v + textureHeight - bottomBorder, rightBorder, bottomBorder);
        ClientDatabankUtils.blitStretched(graphics, texture, x + inset, y - topBorder + inset, u + leftBorder, v, textureWidth - (leftBorder + rightBorder), topBorder, width - inset * 2, topBorder);
        ClientDatabankUtils.blitStretched(graphics, texture, x + inset, y + height - inset, u + leftBorder, v + (textureHeight - bottomBorder), textureWidth - (leftBorder + rightBorder), bottomBorder, width - inset * 2, bottomBorder);
        ClientDatabankUtils.blitStretched(graphics, texture, x - leftBorder + inset, y + inset, u, v + topBorder, leftBorder, textureHeight - (topBorder + bottomBorder), leftBorder, height - inset * 2);
        ClientDatabankUtils.blitStretched(graphics, texture, x + width - inset, y + inset, u + (textureWidth - rightBorder), v + topBorder, rightBorder, textureHeight - (topBorder + bottomBorder), rightBorder, height - inset * 2);
        ClientDatabankUtils.blitStretched(graphics, texture, x + inset, y + inset, u + leftBorder, v + topBorder, textureWidth - (leftBorder + rightBorder), textureHeight - (topBorder + bottomBorder), width - inset * 2, height - inset * 2);
    }
}

