/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.rendering;

import com.cmdpro.databank.ClientDatabankUtils;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTargetPool;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import com.cmdpro.databank.rendering.ShaderHelper;
import com.cmdpro.databank.rendering.ShaderTypeHandler;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank")
public class RenderProjectionUtil {
    private static final RenderTargetPool pool = new RenderTargetPool();
    private static final List<ProjectionRender> queued = new ArrayList<ProjectionRender>();
    static MultiBufferSource.BufferSource projectionBufferSource = null;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (ShaderHelper.shouldUseAlternateRendering()) {
            if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
                RenderSystem.getModelViewStack().pushMatrix().set((Matrix4fc)RenderHandler.matrix4f);
                RenderSystem.applyModelViewMatrix();
                RenderSystem.setShaderFogStart((float)RenderHandler.fogStart);
                RenderProjectionUtil.doEffectRendering(event);
                FogRenderer.setupNoFog();
                RenderSystem.getModelViewStack().popMatrix();
                RenderSystem.applyModelViewMatrix();
            }
        } else if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
            RenderProjectionUtil.doEffectRendering(event);
        }
    }

    private static void doEffectRendering(RenderLevelStageEvent event) {
        event.getPoseStack().pushPose();
        event.getPoseStack().translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
        for (ProjectionRender i : queued) {
            i.apply(event.getPoseStack());
        }
        queued.clear();
        event.getPoseStack().popPose();
    }

    public static void project(Consumer<GuiGraphics> graphics, MultiBufferSource.BufferSource source, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height) {
        RenderProjectionUtil.project(graphics, stack -> {}, stack -> {}, source, null, topLeft, topRight, bottomRight, bottomLeft, width, height, 1.0f, true);
    }

    public static void project(Consumer<GuiGraphics> graphics, MultiBufferSource.BufferSource source, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height, float viewScale) {
        RenderProjectionUtil.project(graphics, stack -> {}, stack -> {}, source, null, topLeft, topRight, bottomRight, bottomLeft, width, height, viewScale, true);
    }

    public static void project(Consumer<GuiGraphics> graphics, Consumer<PoseStack> applyPoseStackTransformations, Consumer<PoseStack> undoPoseStackTransformations, MultiBufferSource.BufferSource source, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height) {
        RenderProjectionUtil.project(graphics, applyPoseStackTransformations, undoPoseStackTransformations, source, null, topLeft, topRight, bottomRight, bottomLeft, width, height, 1.0f, true);
    }

    public static void project(Consumer<GuiGraphics> graphics, Consumer<PoseStack> applyPoseStackTransformations, Consumer<PoseStack> undoPoseStackTransformations, MultiBufferSource.BufferSource source, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height, float viewScale) {
        RenderProjectionUtil.project(graphics, applyPoseStackTransformations, undoPoseStackTransformations, source, null, topLeft, topRight, bottomRight, bottomLeft, width, height, viewScale, true);
    }

    public static void project(Consumer<GuiGraphics> graphics, Consumer<PoseStack> applyPoseStackTransformations, Consumer<PoseStack> undoPoseStackTransformations, MultiBufferSource.BufferSource source, PoseStack poseStack, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height) {
        RenderProjectionUtil.project(graphics, applyPoseStackTransformations, undoPoseStackTransformations, source, poseStack, topLeft, topRight, bottomRight, bottomLeft, width, height, 1.0f, true);
    }

    public static void project(Consumer<GuiGraphics> graphics, Consumer<PoseStack> applyPoseStackTransformations, Consumer<PoseStack> undoPoseStackTransformations, MultiBufferSource.BufferSource source, PoseStack poseStack, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height, float viewScale) {
        RenderProjectionUtil.project(graphics, applyPoseStackTransformations, undoPoseStackTransformations, source, poseStack, topLeft, topRight, bottomRight, bottomLeft, width, height, viewScale, true);
    }

    public static void project(Consumer<GuiGraphics> graphics, Consumer<PoseStack> applyPoseStackTransformations, Consumer<PoseStack> undoPoseStackTransformations, MultiBufferSource.BufferSource source, PoseStack poseStack, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height, float viewScale, boolean queue) {
        ProjectionRender render = new ProjectionRender(graphics, applyPoseStackTransformations, undoPoseStackTransformations, source, topLeft, topRight, bottomRight, bottomLeft, width, height, viewScale);
        if (queue) {
            queued.add(render);
        } else if (poseStack != null) {
            render.apply(poseStack);
        }
    }

    public static void renderTarget(RenderTarget target, MultiBufferSource.BufferSource source, PoseStack poseStack, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft) {
        ShaderTypeHandler.SCREEN_PROJECTION.setSampler("ProjectedTarget", (Object)target.getColorTextureId());
        float tlX = (float)topLeft.x;
        float tlY = (float)topLeft.y;
        float tlZ = (float)topLeft.z;
        float trX = (float)topRight.x;
        float trY = (float)topRight.y;
        float trZ = (float)topRight.z;
        float brX = (float)bottomRight.x;
        float brY = (float)bottomRight.y;
        float brZ = (float)bottomRight.z;
        float blX = (float)bottomLeft.x;
        float blY = (float)bottomLeft.y;
        float blZ = (float)bottomLeft.z;
        VertexConsumer consumer = source.getBuffer(RenderTypeHandler.SCREEN_PROJECTION);
        poseStack.pushPose();
        PoseStack.Pose pose = poseStack.last();
        consumer.addVertex(pose, tlX, tlY, tlZ).setUv(0.0f, 0.0f);
        consumer.addVertex(pose, trX, trY, trZ).setUv(1.0f, 0.0f);
        consumer.addVertex(pose, brX, brY, brZ).setUv(1.0f, 1.0f);
        consumer.addVertex(pose, blX, blY, blZ).setUv(0.0f, 1.0f);
        poseStack.popPose();
        source.endBatch(RenderTypeHandler.SCREEN_PROJECTION);
    }

    private static MultiBufferSource.BufferSource createProjectionBufferSource() {
        if (projectionBufferSource == null) {
            projectionBufferSource = ClientDatabankUtils.createMainBufferSourceCopy();
        }
        return projectionBufferSource;
    }

    private static class ProjectionRender {
        Consumer<GuiGraphics> graphics;
        Consumer<PoseStack> applyPoseStackTransformations;
        Consumer<PoseStack> undoPoseStackTransformations;
        MultiBufferSource.BufferSource source;
        Vec3 topLeft;
        Vec3 topRight;
        Vec3 bottomRight;
        Vec3 bottomLeft;
        int width;
        int height;
        float viewScale;

        public ProjectionRender(Consumer<GuiGraphics> graphics, Consumer<PoseStack> applyPoseStackTransformations, Consumer<PoseStack> undoPoseStackTransformations, MultiBufferSource.BufferSource source, Vec3 topLeft, Vec3 topRight, Vec3 bottomRight, Vec3 bottomLeft, int width, int height, float viewScale) {
            this.graphics = graphics;
            this.applyPoseStackTransformations = applyPoseStackTransformations;
            this.undoPoseStackTransformations = undoPoseStackTransformations;
            this.source = source;
            this.topLeft = topLeft;
            this.topRight = topRight;
            this.bottomRight = bottomRight;
            this.bottomLeft = bottomLeft;
            this.width = width;
            this.height = height;
            this.viewScale = viewScale;
        }

        public void apply(PoseStack poseStack) {
            ShaderInstance shader = RenderSystem.getShader();
            float[] color = RenderSystem.getShaderColor();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int viewWidth = (int)((float)this.width * this.viewScale);
            int viewHeight = (int)((float)this.height * this.viewScale);
            Supplier<RenderTarget> targetCreationSupplier = () -> {
                MainTarget target = new MainTarget(viewWidth, viewHeight);
                target.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                return target;
            };
            RenderTarget target = pool.getTarget(renderTarget -> renderTarget.width == viewWidth && renderTarget.height == viewHeight, targetCreationSupplier);
            ResourceLocation use = pool.generateRandomUseId("databank");
            target.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            pool.markUse(target, use);
            MultiBufferSource.BufferSource projectionSource = RenderProjectionUtil.createProjectionBufferSource();
            Matrix4f projMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
            VertexSorting sorting = RenderSystem.getVertexSorting();
            float fogStart = RenderSystem.getShaderFogStart();
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)viewWidth, (float)viewHeight, 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            Matrix4f mat = new Matrix4f((Matrix4fc)matrix4fstack);
            matrix4fstack.popMatrix();
            matrix4fstack.pushMatrix();
            matrix4fstack.translation(0.0f, 0.0f, 10000.0f - ClientHooks.getGuiFarPlane());
            RenderSystem.applyModelViewMatrix();
            Lighting.setupFor3DItems();
            FogRenderer.setupNoFog();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            target.clear(Minecraft.ON_OSX);
            target.bindWrite(true);
            GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), projectionSource);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(this.viewScale, this.viewScale, this.viewScale);
            this.graphics.accept(guiGraphics);
            guiGraphics.pose().popPose();
            guiGraphics.flush();
            Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderFogStart((float)fogStart);
            RenderSystem.setShader(() -> shader);
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
            Lighting.setupLevel();
            RenderSystem.setProjectionMatrix((Matrix4f)projMatrix, (VertexSorting)sorting);
            matrix4fstack.popMatrix();
            matrix4fstack.pushMatrix();
            matrix4fstack.set((Matrix4fc)mat);
            RenderSystem.applyModelViewMatrix();
            poseStack.pushPose();
            ArrayList<Vec3> vectors = new ArrayList<Vec3>();
            vectors.add(this.topLeft);
            vectors.add(this.topRight);
            vectors.add(this.bottomRight);
            vectors.add(this.bottomLeft);
            Vec3 combinedVec = new Vec3(0.0, 0.0, 0.0);
            for (Vec3 i : vectors) {
                combinedVec = combinedVec.add(i);
            }
            Vec3 middle = combinedVec.scale((double)(1.0f / (float)vectors.size()));
            Vec3 topLeft = middle.subtract(this.topLeft);
            Vec3 topRight = middle.subtract(this.topRight);
            Vec3 bottomRight = middle.subtract(this.bottomRight);
            Vec3 bottomLeft = middle.subtract(this.bottomLeft);
            poseStack.translate(middle.x, middle.y, middle.z);
            poseStack.pushPose();
            this.applyPoseStackTransformations.accept(poseStack);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderProjectionUtil.renderTarget(target, this.source, poseStack, topLeft, topRight, bottomRight, bottomLeft);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
            this.undoPoseStackTransformations.accept(poseStack);
            poseStack.popPose();
            poseStack.popPose();
            pool.unmarkUse(target, use);
        }
    }
}

