/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.deepdarkdimdungeons.portal;

import com.breakinblocks.deepdarkdimdungeons.portal.PortalDestinationManager;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeepDarkPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public DeepDarkPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.canUsePortal(false) && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PortalDestinationManager manager = PortalDestinationManager.get(serverLevel);
                BlockPos destination = manager.getPortalDestination(pos);
                if (destination != null) {
                    ServerLevel dungeonLevel = DungeonUtils.getDungeonWorld((MinecraftServer)level.getServer());
                    if (dungeonLevel != null) {
                        serverPlayer.teleportTo(dungeonLevel, (double)destination.getX() + 0.5, (double)destination.getY() + 0.1, (double)destination.getZ() + 0.5, serverPlayer.getYRot(), serverPlayer.getXRot());
                        serverPlayer.sendSystemMessage((Component)Component.literal((String)("Teleported to dungeon at " + destination.getX() + ", " + destination.getZ())));
                    } else {
                        serverPlayer.sendSystemMessage((Component)Component.literal((String)"DimDungeons dimension not available!"));
                    }
                } else {
                    serverPlayer.sendSystemMessage((Component)Component.literal((String)"Portal destination not found! Portal may be corrupted."));
                }
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(100) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            double vx = (random.nextDouble() - 0.5) * 0.5;
            double vy = (random.nextDouble() - 0.5) * 0.5;
            double vz = (random.nextDouble() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (state.getValue(AXIS) == Direction.Axis.X) {
                x = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                vx = random.nextFloat() * 2.0f * (float)j;
            } else {
                z = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                vz = random.nextFloat() * 2.0f * (float)j;
            }
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, vx, vy, vz);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        boolean shouldDestroy;
        Direction.Axis axis = direction.getAxis();
        Direction.Axis stateAxis = (Direction.Axis)state.getValue(AXIS);
        boolean flag = stateAxis != axis && axis.isHorizontal();
        boolean bl = shouldDestroy = !flag && !neighborState.is((Block)this) && neighborState.is(Blocks.AIR);
        if (shouldDestroy && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PortalDestinationManager manager = PortalDestinationManager.get(serverLevel);
            manager.removePortalDestination(pos);
        }
        return shouldDestroy ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }
}

