/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.deepdarkdimdungeons.portal;

import com.breakinblocks.deepdarkdimdungeons.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SimplePortalDetector {
    @Nullable
    public static PortalFrame detectPortalFrame(Level level, BlockPos clickedPos) {
        PortalFrame frame = SimplePortalDetector.tryDetectFrame(level, clickedPos, Direction.Axis.X);
        if (frame != null) {
            return frame;
        }
        return SimplePortalDetector.tryDetectFrame(level, clickedPos, Direction.Axis.Z);
    }

    @Nullable
    private static PortalFrame tryDetectFrame(Level level, BlockPos start, Direction.Axis axis) {
        BlockPos corner = SimplePortalDetector.findBottomLeftCorner(level, start, axis);
        if (corner == null) {
            return null;
        }
        int width = SimplePortalDetector.measureWidth(level, corner, axis);
        int height = SimplePortalDetector.measureHeight(level, corner, axis);
        if (width < 2 || height < 3 || width > 21 || height > 21) {
            return null;
        }
        if (SimplePortalDetector.validateFrame(level, corner, width, height, axis)) {
            return new PortalFrame(corner, width, height, axis);
        }
        return null;
    }

    @Nullable
    private static BlockPos findBottomLeftCorner(Level level, BlockPos start, Direction.Axis axis) {
        BlockPos bottom = start;
        while (level.getBlockState(bottom.below()).is(Blocks.REINFORCED_DEEPSLATE)) {
            bottom = bottom.below();
        }
        Direction leftDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        BlockPos left = bottom;
        while (level.getBlockState(left.relative(leftDir)).is(Blocks.REINFORCED_DEEPSLATE)) {
            left = left.relative(leftDir);
        }
        if (!level.getBlockState(left).is(Blocks.REINFORCED_DEEPSLATE)) {
            return null;
        }
        return left;
    }

    private static int measureWidth(Level level, BlockPos corner, Direction.Axis axis) {
        Direction rightDir = axis == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
        int width = 0;
        BlockPos pos = corner;
        while (level.getBlockState(pos).is(Blocks.REINFORCED_DEEPSLATE) && width < 23) {
            ++width;
            pos = pos.relative(rightDir);
        }
        return width - 2;
    }

    private static int measureHeight(Level level, BlockPos corner, Direction.Axis axis) {
        int height = 0;
        BlockPos pos = corner;
        while (level.getBlockState(pos).is(Blocks.REINFORCED_DEEPSLATE) && height < 23) {
            ++height;
            pos = pos.above();
        }
        return height - 2;
    }

    private static boolean validateFrame(Level level, BlockPos corner, int interiorWidth, int interiorHeight, Direction.Axis axis) {
        int y;
        BlockPos pos;
        int x;
        Direction rightDir = axis == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
        int frameWidth = interiorWidth + 2;
        int frameHeight = interiorHeight + 2;
        for (x = 0; x < frameWidth; ++x) {
            pos = corner.relative(rightDir, x);
            if (level.getBlockState(pos).is(Blocks.REINFORCED_DEEPSLATE)) continue;
            return false;
        }
        for (x = 0; x < frameWidth; ++x) {
            pos = corner.relative(rightDir, x).above(frameHeight - 1);
            if (level.getBlockState(pos).is(Blocks.REINFORCED_DEEPSLATE)) continue;
            return false;
        }
        for (y = 0; y < frameHeight; ++y) {
            pos = corner.above(y);
            if (level.getBlockState(pos).is(Blocks.REINFORCED_DEEPSLATE)) continue;
            return false;
        }
        for (y = 0; y < frameHeight; ++y) {
            pos = corner.relative(rightDir, frameWidth - 1).above(y);
            if (level.getBlockState(pos).is(Blocks.REINFORCED_DEEPSLATE)) continue;
            return false;
        }
        for (x = 1; x < frameWidth - 1; ++x) {
            for (int y2 = 1; y2 < frameHeight - 1; ++y2) {
                BlockPos pos2 = corner.relative(rightDir, x).above(y2);
                BlockState state = level.getBlockState(pos2);
                if (state.isAir() || state.canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    public static class PortalFrame {
        public final BlockPos bottomLeft;
        public final int width;
        public final int height;
        public final Direction.Axis axis;

        public PortalFrame(BlockPos bottomLeft, int width, int height, Direction.Axis axis) {
            this.bottomLeft = bottomLeft;
            this.width = width;
            this.height = height;
            this.axis = axis;
        }

        public void createPortal(Level level) {
            BlockState portalState = (BlockState)((Block)ModBlocks.DEEP_DARK_PORTAL.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)this.axis);
            Direction rightDir = this.axis == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    BlockPos pos = this.bottomLeft.relative(rightDir, x + 1).above(y + 1);
                    level.setBlock(pos, portalState, 3);
                }
            }
        }
    }
}

