/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.utils.CommandDimDungeons;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PlayerDungeonEvents {
    public static final TagKey<Item> TAG_BUCKETS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"buckets"));

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDimDungeons.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onWorldTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        if (DungeonUtils.isDimensionDungeon(event.getLevel())) {
            DungeonData.get(event.getLevel()).tick(event.getLevel());
        }
    }

    @SubscribeEvent
    public void livingUpdate(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (event.getEntity().isSpectator()) {
            return;
        }
        if (DungeonUtils.isDimensionPersonalBuild(event.getEntity().level())) {
            if (!DungeonUtils.isPersonalBuildChunk(event.getEntity().blockPosition())) {
                ChunkPos chunk = new ChunkPos(event.getEntity().blockPosition());
                int nx = (chunk.x - 4) % 32;
                int nz = (chunk.z - 4) % 32;
                if (nx < -1 || nx > 8 && nx < 31 || nz < -1 || nz > 8 && nz < 31) {
                    DungeonUtils.sendEntityHomeInBuildWorld((Entity)event.getEntity());
                    return;
                }
            }
            if (event.getEntity().position().y < 1.0) {
                DungeonUtils.sendEntityHomeInBuildWorld((Entity)event.getEntity());
                return;
            }
        }
    }

    @SubscribeEvent
    public void explosionStart(ExplosionEvent.Start event) {
    }

    @SubscribeEvent
    public void explosionModify(ExplosionEvent.Detonate event) {
        if (!DungeonUtils.isDimensionDungeon(event.getLevel())) {
            return;
        }
        ArrayList crackedBricks = Lists.newArrayList();
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            if (event.getLevel().getBlockState((BlockPos)event.getAffectedBlocks().get(i)).getBlock().builtInRegistryHolder().key().location().getPath().equals("cracked_stone_bricks")) {
                crackedBricks.add((BlockPos)event.getAffectedBlocks().get(i));
            }
            if (event.getLevel().getBlockState((BlockPos)event.getAffectedBlocks().get(i)).getBlock().builtInRegistryHolder().key().location().getPath().equals("trapped_chest")) {
                crackedBricks.add((BlockPos)event.getAffectedBlocks().get(i));
            }
            if (!event.getLevel().getBlockState((BlockPos)event.getAffectedBlocks().get(i)).getBlock().builtInRegistryHolder().key().location().getPath().equals("tnt")) continue;
            crackedBricks.add((BlockPos)event.getAffectedBlocks().get(i));
        }
        event.getExplosion().clearToBlow();
        event.getAffectedBlocks().addAll(crackedBricks);
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((Level)event.getLevel())) {
            return;
        }
        BlockState targetBlock = event.getLevel().getBlockState(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.getBlock())) {
            return;
        }
        if (event.getPlayer().isCreative()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockPlace(BlockEvent.EntityPlaceEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((Level)event.getLevel())) {
            return;
        }
        String whatBlock = event.getPlacedBlock().getBlock().builtInRegistryHolder().key().location().getPath();
        if ("water".equals(whatBlock)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((Level)event.getLevel())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void anythingDestroyBlock(LivingDestroyBlockEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild(event.getEntity().level()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getEntity().level())) {
            return;
        }
        BlockState targetBlock = event.getEntity().level().getBlockState(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.getBlock())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (DungeonUtils.isDimensionPersonalBuild(event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getEntity().level())) {
            return;
        }
        BlockState targetBlock = event.getEntity().level().getBlockState(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.getBlock())) {
            return;
        }
        if (event.getEntity().isCreative()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickItem event) {
        if (DungeonUtils.isDimensionPersonalBuild(event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getEntity().level())) {
            return;
        }
        if (event.getItemStack().is(TAG_BUCKETS) && event.getItemStack().getItem() != Items.MILK_BUCKET) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState targetBlock = event.getLevel().getBlockState(event.getPos());
        if (DungeonUtils.isDimensionPersonalBuild(event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            if (event.getSide() == LogicalSide.CLIENT || event.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            if (targetBlock.getBlock() == BlockRegistrar.BLOCK_GOLD_PORTAL.get()) {
                ItemStack itemInHand = event.getItemStack();
                if (itemInHand.isEmpty()) {
                    DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.help_1");
                } else {
                    Player player = event.getEntity();
                    if (itemInHand.getItem() == Items.PAPER) {
                        if (itemInHand.has(DataComponents.CUSTOM_NAME)) {
                            String playerName = itemInHand.getDisplayName().getString();
                            playerName = playerName.replace("[", "");
                            playerName = playerName.replace("]", "");
                            playerName = playerName.replace(" ", "");
                            if (PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).getBlacklistMode(player)) {
                                boolean wasAdded = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).toggleNameOnGuestList(player, playerName);
                                if (wasAdded) {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_added_blacklist", playerName);
                                } else {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_removed_blacklist", playerName);
                                }
                            } else {
                                boolean wasAdded = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).toggleNameOnGuestList(player, playerName);
                                if (wasAdded) {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_added_whitelist", playerName);
                                } else {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_removed_whitelist", playerName);
                                }
                            }
                        } else {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_paper");
                        }
                    }
                    if (itemInHand.getItem() == Items.BOOK) {
                        ArrayList<String> guests = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).getGuestListForPlayer(player);
                        DungeonUtils.displayGuestList(player, guests);
                        if (PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).getBlacklistMode(player)) {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_blacklist");
                        } else {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_whitelist");
                        }
                    }
                    if (itemInHand.getItem() == Items.GRINDSTONE) {
                        DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_grindstone");
                        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).clearGuestListForPlayer(player);
                        if (PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).getBlacklistMode(player)) {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_blacklist");
                        } else {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_whitelist");
                        }
                    }
                    if (itemInHand.getItem() == Items.WHITE_DYE) {
                        DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_white");
                        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).changeBlacklistMode(player, false);
                    }
                    if (itemInHand.getItem() == Items.BLACK_DYE) {
                        DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_black");
                        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().getServer())).changeBlacklistMode(player, true);
                    }
                }
            }
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getLevel())) {
            return;
        }
        if (DungeonConfig.blockInteractBlacklist.contains(targetBlock.getBlock())) {
            event.setCanceled(true);
            return;
        }
        ItemStack itemInHand = event.getItemStack();
        if (itemInHand != null && !itemInHand.isEmpty()) {
            if (itemInHand.getItem() instanceof BlockItem) {
                event.setCanceled(true);
            }
            return;
        }
    }

    @SubscribeEvent
    public void teleportStart(EntityTeleportEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer) || DungeonUtils.isDimensionDungeon(event.getEntity().getCommandSenderWorld())) {
            // empty if block
        }
        if ((event.getEntity() instanceof EnderMan || event.getEntity() instanceof Shulker) && DungeonUtils.isDimensionDungeon(event.getEntity().getCommandSenderWorld())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChorusTeleport(EntityTeleportEvent.ChorusFruit event) {
        if (DungeonUtils.isDimensionDungeon(event.getEntity().getCommandSenderWorld())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Start event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (event.getItem().is(TAG_BUCKETS) && event.getItem().getItem() != Items.MILK_BUCKET) {
            event.setCanceled(true);
        }
    }
}

