/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityLocalTeleporter
extends BlockEntity {
    public static final String REG_NAME = "tileentity_local_teleporter";
    private double destX;
    private double destY;
    private double destZ;
    private double destYaw;
    private double destPitch;

    public TileEntityLocalTeleporter(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistrar.BE_LOCAL_TELEPORTER.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        if (compound.contains("destX") && compound.contains("destY") && compound.contains("destZ") && compound.contains("destPitch") && compound.contains("destYaw")) {
            this.destX = compound.getDouble("destX");
            this.destY = compound.getDouble("destY");
            this.destZ = compound.getDouble("destZ");
            this.destPitch = compound.getDouble("destPitch");
            this.destYaw = compound.getDouble("destYaw");
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putDouble("destX", this.destX);
        compound.putDouble("destY", this.destY);
        compound.putDouble("destZ", this.destZ);
        compound.putDouble("destPitch", this.destPitch);
        compound.putDouble("destYaw", this.destYaw);
    }

    public void setDestination(double posX, double posY, double posZ, double pitch, double yaw) {
        this.destX = posX;
        this.destY = posY;
        this.destZ = posZ;
        this.destPitch = pitch;
        this.destYaw = yaw;
    }

    public BlockPos getDestination() {
        return new BlockPos((int)this.destX, (int)this.destY, (int)this.destZ);
    }

    public double getPitch() {
        return this.destPitch;
    }

    public double getYaw() {
        return this.destYaw;
    }
}

