/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class DungeonChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<FlatLevelSource> CODEC = RecordCodecBuilder.mapCodec(p_255577_ -> p_255577_.group((App)FlatLevelGeneratorSettings.CODEC.fieldOf("settings").forGetter(FlatLevelSource::settings)).apply((Applicative)p_255577_, p_255577_.stable(FlatLevelSource::new)));
    private final FlatLevelGeneratorSettings settings;

    public DungeonChunkGenerator(Registry<StructureSet> p_209099_, FlatLevelGeneratorSettings p_209100_) {
        super((BiomeSource)new FixedBiomeSource(p_209100_.getBiome()));
        this.settings = p_209100_;
    }

    public MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ChunkGenerator withSeed(long p_230349_1_) {
        return this;
    }

    public FlatLevelGeneratorSettings settings() {
        return this.settings;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmapType) {
        List ablockstate = this.settings.getLayers();
        for (int i = ablockstate.size() - 1; i >= 0; --i) {
            BlockState blockstate = (BlockState)ablockstate.get(i);
            if (blockstate == null || !heightmapType.isOpaque().test(blockstate)) continue;
            return i + 1;
        }
        return 0;
    }

    public NoiseColumn getBaseColumn(int p_158270_, int p_158271_, LevelHeightAccessor p_158272_) {
        return new NoiseColumn(p_158272_.getMinBuildHeight(), (BlockState[])this.settings.getLayers().stream().limit(p_158272_.getHeight()).map(p_64189_ -> p_64189_ == null ? Blocks.AIR.defaultBlockState() : p_64189_).toArray(BlockState[]::new));
    }

    public void makeBase(ChunkAccess chunkIn) {
        block9: {
            int z;
            int x;
            block8: {
                x = chunkIn.getPos().x;
                z = chunkIn.getPos().z;
                if (!DungeonPlacement.isDungeonChunk(x, z)) break block8;
                for (int px = 0; px < 16; ++px) {
                    for (int py = 1; py < 255; ++py) {
                        for (int pz = 0; pz < 16; ++pz) {
                            if (py < 2) {
                                chunkIn.setBlockState(new BlockPos(px, py, pz), Blocks.BEDROCK.defaultBlockState(), false);
                                continue;
                            }
                            if (py >= 50) continue;
                            if (DungeonPlacement.isEntranceChunk(x, z)) {
                                chunkIn.setBlockState(new BlockPos(px, py, pz), Blocks.BLACKSTONE.defaultBlockState(), false);
                                continue;
                            }
                            chunkIn.setBlockState(new BlockPos(px, py, pz), Blocks.SANDSTONE.defaultBlockState(), false);
                        }
                    }
                }
                break block9;
            }
            if (x % 16 != 0 && z % 16 != 0) break block9;
            for (int px = 0; px < 16; ++px) {
                for (int py = 1; py < 255; ++py) {
                    for (int pz = 0; pz < 16; ++pz) {
                        chunkIn.setBlockState(new BlockPos(px, py, pz), Blocks.BARRIER.defaultBlockState(), false);
                    }
                }
            }
        }
    }

    public void createStructures(RegistryAccess p_255835_, ChunkGeneratorStructureState p_256505_, StructureManager p_255934_, ChunkAccess p_255767_, StructureTemplateManager p_255832_) {
    }

    public void spawnOriginalMobs(WorldGenRegion p_62167_) {
    }

    public int getMinY() {
        return -63;
    }

    public int getGenDepth() {
        return 384;
    }

    public int getSeaLevel() {
        return -64;
    }

    public void applyCarvers(WorldGenRegion p_223043_, long p_223044_, RandomState p_223045_, BiomeManager p_223046_, StructureManager p_223047_, ChunkAccess p_223048_, GenerationStep.Carving p_223049_) {
    }

    public void buildSurface(WorldGenRegion p_223050_, StructureManager p_223051_, RandomState p_223052_, ChunkAccess p_223053_) {
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        this.makeBase(chunk);
        return CompletableFuture.completedFuture(chunk);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types p_223034_, LevelHeightAccessor p_223035_, RandomState p_223036_) {
        return this.getBaseHeight(x, z, p_223034_);
    }

    public NoiseColumn getBaseColumn(int p_223028_, int p_223029_, LevelHeightAccessor p_223030_, RandomState p_223031_) {
        return new NoiseColumn(p_223030_.getMinBuildHeight(), (BlockState[])this.settings.getLayers().stream().limit(p_223030_.getHeight()).map(p_204549_ -> p_204549_ == null ? Blocks.AIR.defaultBlockState() : p_204549_).toArray(BlockState[]::new));
    }

    public void addDebugScreenInfo(List<String> p_223175_, RandomState p_223176_, BlockPos p_223177_) {
    }
}

