/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockKeyCharger;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BaseItemKey
extends Item {
    public static final String NBT_KEY_ACTIVATED = "key_activated";
    public static final String NBT_BUILT = "built";
    public static final String NBT_KEY_DESTINATION_X = "dest_x";
    public static final String NBT_KEY_DESTINATION_Z = "dest_z";
    public static final String NBT_NAME_TYPE = "name_type";
    public static final String NBT_NAME_PART_1 = "name_part_1";
    public static final String NBT_NAME_PART_2 = "name_part_2";
    public static final String NBT_THEME = "theme";
    public static final String NBT_DUNGEON_TYPE = "dungeon_type";
    public static final int BLOCKS_APART_PER_DUNGEON = 256;
    public static final float ENTRANCE_OFFSET_X = 136.0f;
    public static final float ENTRANCE_OFFSET_Z = 188.5f;
    public static final TagKey<Block> tag_alternate_activation_blocks = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"key_activation_blocks"));

    public BaseItemKey(Item.Properties properties) {
        super(properties.stacksTo(1).component(DimDungeons.DUNGEON_KEY_DATA.get(), (Object)new DungeonKeyDataComponentRecord(false, false, -1L, -1L, 0, 0, 0, 0, String.valueOf((Object)DungeonDesigner.DungeonType.valueOf(String.valueOf((Object)DungeonDesigner.DungeonType.BASIC))))));
    }

    public int getKeyLevel(ItemStack stack) {
        if (!this.isActivated(stack)) {
            return 0;
        }
        if (this.getWarpZ(stack) < 0.0f || this.getDungeonType(stack) == DungeonDesigner.DungeonType.ADVANCED) {
            return 2;
        }
        return 1;
    }

    public void activateKeyLevel1(MinecraftServer server, ItemStack stack, int theme) {
        boolean activated = true;
        boolean built = false;
        long destX = 0L;
        long destZ = 0L;
        int nameType = 0;
        int namePart1 = 0;
        int namePart2 = 0;
        String dungeonType = DungeonDesigner.DungeonType.BASIC.toString();
        long generation_limit = DungeonUtils.getLimitOfWorldBorder(server);
        long dungeonsPerLimit = generation_limit / 256L;
        int nextDungeonNumber = DungeonData.get((Level)server.getLevel(DimDungeons.DUNGEON_DIMENSION)).getNumKeysRegistered() + 1;
        destZ = (long)nextDungeonNumber / dungeonsPerLimit;
        destX = (long)nextDungeonNumber % dungeonsPerLimit;
        RandomSource random = server.overworld().getRandom();
        nameType = random.nextInt(3);
        if (theme > 0) {
            nameType = 2;
        }
        if (nameType == 0 || nameType == 1) {
            namePart1 = random.nextInt(32);
            namePart2 = random.nextInt(32);
        } else {
            namePart1 = random.nextInt(20);
            namePart2 = random.nextInt(32);
        }
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)new DungeonKeyDataComponentRecord(activated, built, destX, destZ, nameType, namePart1, namePart2, theme, dungeonType));
        DungeonData.get((Level)DungeonUtils.getDungeonWorld(server)).notifyOfNewKeyActivation();
    }

    public void activateKeyLevel2(MinecraftServer server, ItemStack stack) {
        boolean activated = true;
        boolean built = false;
        long destX = 0L;
        long destZ = 0L;
        int nameType = 3;
        int namePart1 = 0;
        int namePart2 = 0;
        int theme = 0;
        String dungeonType = DungeonDesigner.DungeonType.ADVANCED.toString();
        long generation_limit = DungeonUtils.getLimitOfWorldBorder(server);
        long dungeonsPerLimit = generation_limit / 256L;
        long nextDungeonNumber = DungeonData.get((Level)server.getLevel(DimDungeons.DUNGEON_DIMENSION)).getNumKeysRegistered() + 1;
        destZ = nextDungeonNumber / dungeonsPerLimit;
        destX = nextDungeonNumber % dungeonsPerLimit;
        RandomSource random = server.overworld().getRandom();
        namePart1 = random.nextInt(20);
        namePart2 = random.nextInt(12);
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)new DungeonKeyDataComponentRecord(activated, built, destX, destZ, nameType, namePart1, namePart2, theme, dungeonType));
        DungeonData.get((Level)DungeonUtils.getDungeonWorld(server)).notifyOfNewKeyActivation();
    }

    public void activateKeyForNewTeleporterHub(MinecraftServer server, ItemStack stack) {
        boolean activated = true;
        boolean built = false;
        long destX = 0L;
        long destZ = 0L;
        int nameType = 4;
        int namePart1 = 0;
        int namePart2 = 0;
        int theme = 0;
        String dungeonType = DungeonDesigner.DungeonType.TELEPORTER_HUB.toString();
        long generation_limit = DungeonUtils.getLimitOfWorldBorder(server);
        long dungeonsPerLimit = generation_limit / 256L;
        int nextDungeonNumber = DungeonData.get((Level)server.getLevel(DimDungeons.DUNGEON_DIMENSION)).getNumKeysRegistered() + 1;
        destZ = (long)nextDungeonNumber / dungeonsPerLimit;
        destX = (long)nextDungeonNumber % dungeonsPerLimit;
        RandomSource random = server.overworld().getRandom();
        namePart1 = random.nextInt(32);
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)new DungeonKeyDataComponentRecord(activated, built, destX, destZ, nameType, namePart1, namePart2, theme, dungeonType));
        DungeonData.get((Level)DungeonUtils.getDungeonWorld(server)).notifyOfNewKeyActivation();
    }

    public static void activateKeyForExistingTeleporterHub(MinecraftServer server, ItemStack stack, int destX, int destZ, int doorIndex) {
        boolean activated = true;
        boolean built = true;
        int nameType = 5;
        int namePart1 = doorIndex;
        int namePart2 = 0;
        int theme = doorIndex;
        String dungeonType = DungeonDesigner.DungeonType.TELEPORTER_HUB.toString();
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)new DungeonKeyDataComponentRecord(activated, built, destX, destZ, nameType, namePart1, namePart2, theme, dungeonType));
    }

    public static void setTheme(ItemStack stack, int theme) {
        if (!stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return;
        }
        DungeonKeyDataComponentRecord data = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(false, false, data.dest_x(), data.dest_z(), data.name_type(), data.name_part_1(), data.name_part_2(), theme, data.dungeon_type());
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
    }

    public boolean isActivated(ItemStack stack) {
        if (stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return ((DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)).key_activated();
        }
        return false;
    }

    public static boolean hasLegacyData(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_DATA);
    }

    public static void convertLegacyData(ItemStack stack) {
        if (!stack.has(DataComponents.CUSTOM_DATA)) {
            return;
        }
        CustomData cd = (CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(cd.contains(NBT_KEY_ACTIVATED) ? cd.getUnsafe().getBoolean(NBT_KEY_ACTIVATED) : false, cd.contains(NBT_BUILT) ? cd.getUnsafe().getBoolean(NBT_BUILT) : false, cd.contains(NBT_KEY_DESTINATION_X) ? cd.getUnsafe().getLong(NBT_KEY_DESTINATION_X) : 0L, cd.contains(NBT_KEY_DESTINATION_Z) ? cd.getUnsafe().getLong(NBT_KEY_DESTINATION_Z) : 0L, cd.contains(NBT_NAME_TYPE) ? cd.getUnsafe().getInt(NBT_NAME_TYPE) : 0, cd.contains(NBT_NAME_PART_1) ? cd.getUnsafe().getInt(NBT_NAME_PART_1) : 0, cd.contains(NBT_NAME_PART_2) ? cd.getUnsafe().getInt(NBT_NAME_PART_2) : 0, cd.contains(NBT_THEME) ? cd.getUnsafe().getInt(NBT_THEME) : 0, cd.contains(NBT_DUNGEON_TYPE) ? cd.getUnsafe().getString(NBT_DUNGEON_TYPE) : "BASIC");
        stack.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
        stack.remove(DataComponents.CUSTOM_DATA);
    }

    public float getWarpX(ItemStack stack) {
        DungeonKeyDataComponentRecord itemData;
        if (stack != null && !stack.isEmpty() && (itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)) != null) {
            if (itemData.dungeon_type().isEmpty()) {
                DimDungeons.logMessageError("DIMDUNGEONS: Key item is missing dungeon type. Key is corrupt and will be removed.");
                stack.shrink(1);
                return -1.0f;
            }
            DungeonDesigner.DungeonType dtype = DungeonDesigner.DungeonType.valueOf(itemData.dungeon_type());
            if (dtype == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                float tempx = (float)(itemData.dest_x() * 256L) + 136.0f;
                int doornum = itemData.theme();
                int[] x_offset = new int[]{0, -16, -21, -21, -16, 0, 5, 5};
                return tempx + (float)x_offset[doornum];
            }
            return (float)(itemData.dest_x() * 256L) + 136.0f;
        }
        return -1.0f;
    }

    public float getWarpZ(ItemStack stack) {
        DungeonKeyDataComponentRecord itemData;
        if (stack != null && !stack.isEmpty() && (itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)) != null) {
            if (itemData.dungeon_type().isEmpty()) {
                DimDungeons.logMessageError("DIMDUNGEONS: Key item is missing dungeon type. Key is corrupt and will be removed.");
                stack.shrink(1);
                return -1.0f;
            }
            DungeonDesigner.DungeonType dtype = DungeonDesigner.DungeonType.valueOf(itemData.dungeon_type());
            if (dtype == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                float tempz = (float)(itemData.dest_z() * 256L) + 188.5f;
                int doornum = itemData.theme();
                int[] z_offset = new int[]{0, 0, -5, -21, -26, -26, -21, -5};
                return tempz + (float)z_offset[doornum];
            }
            return (float)(itemData.dest_z() * 256L) + 188.5f;
        }
        return -1.0f;
    }

    public long getDungeonTopLeftX(ItemStack stack) {
        DungeonKeyDataComponentRecord itemData;
        if (stack != null && !stack.isEmpty() && (itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)) != null) {
            return itemData.dest_x() * 256L;
        }
        return -1L;
    }

    public long getDungeonTopLeftZ(ItemStack stack) {
        DungeonKeyDataComponentRecord itemData;
        if (stack != null && !stack.isEmpty() && (itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)) != null) {
            return itemData.dest_z() * 256L;
        }
        return -1L;
    }

    public int getDungeonTheme(ItemStack stack) {
        DungeonKeyDataComponentRecord itemData;
        if (stack != null && !stack.isEmpty() && (itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA)) != null) {
            return itemData.theme();
        }
        return -1;
    }

    public DungeonDesigner.DungeonType getDungeonType(ItemStack stack) {
        if (stack != null && !stack.isEmpty()) {
            DungeonKeyDataComponentRecord itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA);
            if (itemData != null && !itemData.dungeon_type().isEmpty()) {
                return DungeonDesigner.DungeonType.valueOf(itemData.dungeon_type());
            }
            if (this.getWarpZ(stack) < 0.0f) {
                return DungeonDesigner.DungeonType.ADVANCED;
            }
        }
        return DungeonDesigner.DungeonType.BASIC;
    }

    public boolean isBlockKeyCharger(BlockState state) {
        return state.getBlock() == BlockRegistrar.BLOCK_CHARGER_FULL.get() || state.getBlock() == BlockRegistrar.BLOCK_CHARGER_USED.get() || state.getBlock() == BlockRegistrar.BLOCK_CHARGER_DAMAGED.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResult useOn(UseOnContext parameters) {
        BlockState iblockstate;
        RandomSource random;
        BlockPos pos;
        Level worldIn;
        block19: {
            worldIn = parameters.getLevel();
            pos = parameters.getClickedPos();
            Direction facing = parameters.getClickedFace();
            double hitX = parameters.getClickLocation().x();
            double hitZ = parameters.getClickLocation().z();
            Player player = parameters.getPlayer();
            random = worldIn.getRandom();
            iblockstate = worldIn.getBlockState(pos);
            ItemStack itemstack = parameters.getItemInHand();
            hitX = Math.abs((double)((int)hitX) - hitX);
            hitZ = Math.abs((double)((int)hitZ) - hitZ);
            if (worldIn.getBlockState(pos) == null) return InteractionResult.PASS;
            if (worldIn.getBlockState(pos).getBlock() == Blocks.END_PORTAL_FRAME) {
                boolean isFilled = (Boolean)worldIn.getBlockState(pos).getValue((Property)EndPortalFrameBlock.HAS_EYE);
                if (hitX > (double)0.3f && hitX < (double)0.7f && hitZ > (double)0.3f && hitZ < (double)0.8f) {
                    if (!isFilled) {
                        if (facing != Direction.UP) return InteractionResult.PASS;
                        if (this.isActivated(itemstack)) {
                            worldIn.playSound((Player)null, pos, SoundEvents.TRIDENT_HIT_GROUND, SoundSource.BLOCKS, 1.0f, 1.0f);
                            return InteractionResult.PASS;
                        }
                        this.performActivationRitual(player, itemstack, worldIn, pos);
                        return InteractionResult.SUCCESS;
                    }
                    break block19;
                } else {
                    worldIn.playSound((Player)null, pos, SoundEvents.GLASS_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
            }
            if (worldIn.getBlockState(pos).getBlock().builtInRegistryHolder().key().location().getNamespace().equals("endrem")) {
                String blockid = worldIn.getBlockState(pos).getBlock().builtInRegistryHolder().key().location().getPath();
                if (this.isActivated(itemstack)) {
                    worldIn.playSound((Player)null, pos, SoundEvents.METAL_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
                if (!blockid.equals("end_creator") && !blockid.equals("end_creator_activated")) {
                    if (!blockid.equals("ancient_portal_frame")) return InteractionResult.PASS;
                }
                this.performActivationRitual(player, itemstack, worldIn, pos);
                return InteractionResult.SUCCESS;
            }
            if (BaseItemKey.isAlternateKeyActivationBlock(worldIn.getBlockState(pos).getBlock())) {
                if (!this.isActivated(itemstack)) {
                    this.performActivationRitual(player, itemstack, worldIn, pos);
                    return InteractionResult.SUCCESS;
                }
                worldIn.playSound((Player)null, pos, SoundEvents.GLASS_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.PASS;
            }
            if (!this.isBlockKeyCharger(worldIn.getBlockState(pos))) {
                worldIn.playSound((Player)null, pos, SoundEvents.GLASS_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.PASS;
            }
            if (hitX > (double)0.3f && hitX < (double)0.7f && hitZ > (double)0.3f && hitZ < (double)0.8f) {
                if (this.isActivated(itemstack)) {
                    worldIn.playSound((Player)null, pos, SoundEvents.METAL_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.PASS;
                }
                this.performActivationRitual(player, itemstack, worldIn, pos);
                if (worldIn.isClientSide) return InteractionResult.PASS;
                String blockid = worldIn.getBlockState(pos).getBlock().builtInRegistryHolder().key().location().getPath();
                int roll = worldIn.getRandom().nextInt(100);
                if (blockid.equals(BlockRegistrar.REG_NAME_CHARGER_FULL)) {
                    if (roll < DungeonConfig.keyEnscriberDowngradeChanceFull) {
                        worldIn.playSound((Player)null, pos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                        worldIn.setBlockAndUpdate(pos, ((BlockKeyCharger)((Object)BlockRegistrar.BLOCK_CHARGER_USED.get())).defaultBlockState());
                        return InteractionResult.SUCCESS;
                    }
                    worldIn.playSound((Player)null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (blockid.equals(BlockRegistrar.REG_NAME_CHARGER_USED)) {
                    if (roll < DungeonConfig.keyEnscriberDowngradeChanceUsed) {
                        worldIn.playSound((Player)null, pos, SoundEvents.ANVIL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                        worldIn.setBlockAndUpdate(pos, ((BlockKeyCharger)((Object)BlockRegistrar.BLOCK_CHARGER_DAMAGED.get())).defaultBlockState());
                        return InteractionResult.SUCCESS;
                    }
                    worldIn.playSound((Player)null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (!blockid.equals(BlockRegistrar.REG_NAME_CHARGER_DAMAGED)) return InteractionResult.SUCCESS;
                if (roll < DungeonConfig.keyEnscriberDowngradeChanceDamaged) {
                    worldIn.playSound((Player)null, pos, SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    worldIn.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    return InteractionResult.SUCCESS;
                }
                worldIn.playSound((Player)null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            worldIn.playSound((Player)null, pos, SoundEvents.GLASS_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.PASS;
        }
        worldIn.setBlock(pos, (BlockState)iblockstate.setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.updateNeighbourForOutputSignal(pos, Blocks.END_PORTAL_FRAME);
        worldIn.playSound((Player)null, pos, SoundEvents.ENDER_EYE_DEATH, SoundSource.BLOCKS, 1.5f, 1.0f);
        worldIn.playSound((Player)null, pos, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.4f, 1.5f);
        int i = 0;
        while (i < 32) {
            double d0 = (float)pos.getX() + 0.5f;
            double d1 = (float)pos.getY() + 0.8f;
            double d2 = (float)pos.getZ() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.08 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.4;
            double zspeed = (double)random.nextFloat() * 0.08 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.addParticle((ParticleOptions)ParticleTypes.END_ROD, d0, d1, d2, xspeed, yspeed, zspeed);
            ++i;
        }
        return InteractionResult.PASS;
    }

    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.playSound((Player)null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.isClientSide) {
            this.activateKeyLevel1(worldIn.getServer(), itemstack, 0);
            ServerPlayer sp = worldIn.getServer().getPlayerList().getPlayer(player.getUUID());
            sp.getAdvancements().award(worldIn.getServer().getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"dimdungeons", (String)"dungeons/activate_basic_key")), "getkey");
        }
        this.createActivationParticleEffects(worldIn, pos);
    }

    public void createActivationParticleEffects(Level worldIn, BlockPos pos) {
        RandomSource random = worldIn.getRandom();
        for (int i = 0; i < 32; ++i) {
            double d0 = (float)pos.getX() + 0.5f;
            double d1 = (float)pos.getY() + 0.8f;
            double d2 = (float)pos.getZ() + 0.5f;
            double xspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            double yspeed = (double)random.nextFloat() * 0.125;
            double zspeed = (double)random.nextFloat() * 0.04 * (double)(random.nextBoolean() ? 1 : -1);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FIREWORK, d0, d1, d2, xspeed, yspeed, zspeed);
        }
    }

    public static boolean isAlternateKeyActivationBlock(Block b) {
        return b.builtInRegistryHolder().is(tag_alternate_activation_blocks);
    }

    public record DCR_BUILT(int value1, boolean value2) {
    }

    public record DCR_KEY_ACTIVATED(int value1, boolean value2, boolean value3, String value4) {
    }
}

