/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemBlankThemeKey
extends BaseItemKey {
    public static final String REG_NAME = "item_blank_theme_key";

    public ItemBlankThemeKey() {
        super(new Item.Properties().rarity(Rarity.COMMON));
    }

    public static int getTheme(ItemStack stack) {
        if (!stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return 0;
        }
        DungeonKeyDataComponentRecord itemData = (DungeonKeyDataComponentRecord)stack.get(DimDungeons.DUNGEON_KEY_DATA);
        if (itemData != null) {
            return itemData.theme();
        }
        return 0;
    }

    public static float getKeyThemeAsFloat(ItemStack stack) {
        int theme = ItemBlankThemeKey.getTheme(stack);
        return (float)theme / 100.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component getName(ItemStack stack) {
        int theme = 0;
        if (ItemBlankThemeKey.hasLegacyData(stack)) {
            return Component.translatable((String)"item.dimdungeons.item_legacy_key_name");
        }
        if (!stack.has(DimDungeons.DUNGEON_KEY_DATA)) {
            return Component.translatable((String)this.getDescriptionId(stack), (Object[])new Object[0]);
        }
        theme = ItemBlankThemeKey.getTheme(stack);
        String start = I18n.get((String)"item.dimdungeons.item_blank_theme_key", (Object[])new Object[0]);
        String place = I18n.get((String)("npart.dimdungeons.theme_" + theme), (Object[])new Object[0]);
        return Component.translatable((String)(start + " (" + place + ")"));
    }

    @Override
    public void performActivationRitual(Player player, ItemStack itemstack, Level worldIn, BlockPos pos) {
        worldIn.playSound((Player)null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player == null) {
            DimDungeons.logMessageError("Somehow activated a blank theme key without a player present. Do not do this.");
            return;
        }
        if (!worldIn.isClientSide) {
            int slot = player.getInventory().findSlotMatchingItem(itemstack);
            int theme = ItemBlankThemeKey.getTheme(itemstack);
            if (theme < 1) {
                theme = worldIn.getRandom().nextInt(DungeonConfig.themeSettings.size()) + 1;
            }
            itemstack.shrink(1);
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
            this.activateKeyLevel1(worldIn.getServer(), newkey, theme);
            if (!player.getInventory().add(slot, newkey) && !player.addItem(newkey)) {
                player.drop(newkey, false);
            }
        }
        this.createActivationParticleEffects(worldIn, pos);
    }
}

