/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemBlankBuildKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CommandDimDungeons {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)Commands.literal((String)"dimdungeons").requires(cmd -> cmd.hasPermission(2));
        String[] keytypes = new String[]{"blank", "basic", "advanced", "theme"};
        for (int i = 0; i < keytypes.length; ++i) {
            String type = keytypes[i];
            argumentBuilder.then(Commands.literal((String)"givekey").then(((LiteralArgumentBuilder)Commands.literal((String)type).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSourceStack>)cmd, Collections.singleton(((CommandSourceStack)cmd.getSource()).getPlayerOrException()), type, 0))).then(((RequiredArgumentBuilder)Commands.argument((String)"recipient", (ArgumentType)EntityArgument.players()).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSourceStack>)cmd, EntityArgument.getPlayers((CommandContext)cmd, (String)"recipient"), type, 0))).then(Commands.argument((String)"theme", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSourceStack>)cmd, EntityArgument.getPlayers((CommandContext)cmd, (String)"recipient"), type, IntegerArgumentType.getInteger((CommandContext)cmd, (String)"theme")))))));
        }
        argumentBuilder.then(Commands.literal((String)"givepersonal").then(Commands.argument((String)"recipient", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).executes(cmd -> CommandDimDungeons.givePersonalKey((CommandContext<CommandSourceStack>)cmd, EntityArgument.getPlayers((CommandContext)cmd, (String)"recipient"), EntityArgument.getPlayer((CommandContext)cmd, (String)"target_player"))))));
        argumentBuilder.then(Commands.literal((String)"getroom").then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).executes(cmd -> CommandDimDungeons.printRoomName((CommandContext<CommandSourceStack>)cmd, (Entity)EntityArgument.getPlayer((CommandContext)cmd, (String)"target_player")))));
        dispatcher.register(argumentBuilder);
    }

    private static int giveKey(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> recipients, String type, int theme) throws CommandSyntaxException {
        MutableComponent keyName = Component.translatable((String)"item.dimdungeons.item_portal_key");
        for (ServerPlayer serverplayerentity : recipients) {
            ItemEntity itementity;
            ItemStack stack = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
            if ("blank".equals(type)) {
                keyName = Component.translatable((String)"item.dimdungeons.item_portal_key");
            } else if ("basic".equals(type)) {
                ((ItemPortalKey)((Object)ItemRegistrar.ITEM_PORTAL_KEY.get())).activateKeyLevel1(((CommandSourceStack)cmd.getSource()).getServer(), stack, theme);
                keyName = Component.translatable((String)"item.dimdungeons.item_portal_key_basic");
            } else if ("advanced".equals(type)) {
                ((ItemPortalKey)((Object)ItemRegistrar.ITEM_PORTAL_KEY.get())).activateKeyLevel2(((CommandSourceStack)cmd.getSource()).getServer(), stack);
                keyName = Component.translatable((String)"item.dimdungeons.item_portal_key_advanced");
            } else if ("theme".equals(type)) {
                stack = new ItemStack((ItemLike)ItemRegistrar.ITEM_BLANK_THEME_KEY.get());
                BaseItemKey.setTheme(stack, theme);
                keyName = Component.translatable((String)"item.dimdungeons.item_portal_key");
            }
            boolean flag = serverplayerentity.getInventory().add(stack);
            if (flag && stack.isEmpty()) {
                stack.setCount(1);
                itementity = serverplayerentity.drop(stack, false);
                if (itementity != null) {
                    itementity.makeFakeItem();
                }
                serverplayerentity.level().playSound((Player)null, serverplayerentity.getX(), serverplayerentity.getY(), serverplayerentity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverplayerentity.getRandom().nextFloat() - serverplayerentity.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayerentity.inventoryMenu.broadcastChanges();
                continue;
            }
            itementity = serverplayerentity.drop(stack, false);
            if (itementity == null) continue;
            itementity.setNoPickUpDelay();
        }
        MutableComponent finalKeyName = Component.literal((String)keyName.getString());
        if (recipients.size() == 1) {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, finalKeyName, ((ServerPlayer)recipients.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, finalKeyName, recipients.size()}), true);
        }
        return recipients.size();
    }

    private static int givePersonalKey(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> recipients, ServerPlayer targetPlayer) throws CommandSyntaxException {
        MutableComponent keyName = Component.translatable((String)"item.dimdungeons.item_build_key");
        for (ServerPlayer serverplayerentity : recipients) {
            ItemEntity itementity;
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
            ((ItemBlankBuildKey)((Object)ItemRegistrar.ITEM_BLANK_BUILD_KEY.get())).activateBuildKey(((CommandSourceStack)cmd.getSource()).getServer(), newkey, (LivingEntity)targetPlayer);
            boolean flag = serverplayerentity.getInventory().add(newkey);
            if (flag && newkey.isEmpty()) {
                newkey.setCount(1);
                itementity = serverplayerentity.drop(newkey, false);
                if (itementity != null) {
                    itementity.makeFakeItem();
                }
                serverplayerentity.level().playSound((Player)null, serverplayerentity.getX(), serverplayerentity.getY(), serverplayerentity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverplayerentity.getRandom().nextFloat() - serverplayerentity.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayerentity.inventoryMenu.broadcastChanges();
                continue;
            }
            itementity = serverplayerentity.drop(newkey, false);
            if (itementity == null) continue;
            itementity.setNoPickUpDelay();
        }
        if (recipients.size() == 1) {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, keyName, ((ServerPlayer)recipients.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, keyName, recipients.size()}), true);
        }
        return recipients.size();
    }

    private static int givePersonalKeyForAnyEntity(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> recipients, Entity targetPlayer) throws CommandSyntaxException {
        Object keyName = "Personal Dimension Key";
        if (!(targetPlayer instanceof LivingEntity)) {
            ((CommandSourceStack)cmd.getSource()).sendFailure((Component)Component.literal((String)"Target entity is not a LivingEntity."));
            return 0;
        }
        for (ServerPlayer serverplayerentity : recipients) {
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
            ((ItemBlankBuildKey)((Object)ItemRegistrar.ITEM_BLANK_BUILD_KEY.get())).activateBuildKey(((CommandSourceStack)cmd.getSource()).getServer(), newkey, (LivingEntity)targetPlayer);
            long dest_x = ((DungeonKeyDataComponentRecord)newkey.get(DimDungeons.DUNGEON_KEY_DATA)).dest_x();
            long dest_z = ((DungeonKeyDataComponentRecord)newkey.get(DimDungeons.DUNGEON_KEY_DATA)).dest_z();
            keyName = "Personal Key: (" + dest_x + ", " + dest_z + ")";
            newkey.update(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)keyName), component -> component);
            serverplayerentity.getInventory().add(newkey);
        }
        MutableComponent finalKeyName = Component.literal((String)keyName);
        if (recipients.size() == 1) {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, finalKeyName, ((ServerPlayer)recipients.iterator().next()).getDisplayName()}), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, finalKeyName, recipients.size()}), true);
        }
        return recipients.size();
    }

    private static int printRoomName(CommandContext<CommandSourceStack> cmd, Entity targetPlayer) throws CommandSyntaxException {
        if (!(targetPlayer instanceof LivingEntity)) {
            ((CommandSourceStack)cmd.getSource()).sendFailure((Component)Component.literal((String)"Target entity is not a LivingEntity."));
            return 0;
        }
        Level dungeonWorld = targetPlayer.level();
        if (!DungeonUtils.isDimensionDungeon(dungeonWorld)) {
            ((CommandSourceStack)cmd.getSource()).sendFailure((Component)Component.literal((String)"This command only works in the dungeon dimension."));
            return 0;
        }
        DungeonRoom room = DungeonData.get(dungeonWorld).getRoomAtPos(targetPlayer.chunkPosition());
        if (room == null) {
            ((CommandSourceStack)cmd.getSource()).sendFailure((Component)Component.literal((String)"No room found at current position."));
            return 0;
        }
        MutableComponent text = Component.literal((String)("room: " + room.structure + " rot: " + String.valueOf(room.rotation)));
        text.withStyle(text.getStyle().withItalic(Boolean.valueOf(true)));
        text.withStyle(text.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
        ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> text, true);
        return 1;
    }

    private static int erasePersonalMap(CommandContext<CommandSourceStack> cmd) throws CommandSyntaxException {
        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(((CommandSourceStack)cmd.getSource()).getServer())).debugClearKnownOwners();
        ((CommandSourceStack)cmd.getSource()).sendSuccess(() -> Component.literal((String)"Deleted all known personal key associations."), true);
        return 0;
    }
}

