/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockGildedPortal;
import com.catastrophe573.dimdungeons.block.BlockGoldPortal;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.BaseItemKey;
import com.catastrophe573.dimdungeons.item.DungeonKeyDataComponentRecord;
import com.catastrophe573.dimdungeons.item.ItemBuildKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonPlacement;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class DungeonUtils {
    public static boolean isDimensionOverworld(Level worldIn) {
        return worldIn.dimension() == Level.OVERWORLD;
    }

    public static boolean isDimensionDungeon(Level worldIn) {
        if (worldIn == null) {
            return false;
        }
        return worldIn.dimension().location().getPath() == "dungeon_dimension";
    }

    public static boolean isDimensionPersonalBuild(Level worldIn) {
        if (worldIn == null) {
            return false;
        }
        return worldIn.dimension().location().getPath() == "build_dimension";
    }

    public static ServerLevel getDungeonWorld(MinecraftServer server) {
        return server.getLevel(DimDungeons.DUNGEON_DIMENSION);
    }

    public static ServerLevel getPersonalBuildWorld(MinecraftServer server) {
        return server.getLevel(DimDungeons.BUILD_DIMENSION);
    }

    public static int doesKeyMatchDebugCheat(DungeonGenData genData) {
        if (!(genData.keyItem.getItem() instanceof ItemPortalKey)) {
            DimDungeons.logMessageError("FATAL ERROR: Using a non-key item to build a dungeon? What happened?");
            return 0;
        }
        if (genData.keyItem.has(DataComponents.CUSTOM_NAME) && DungeonConfig.enableDebugCheats) {
            String name = genData.keyItem.getHoverName().getString();
            if (name.contentEquals("DebugOne")) {
                return 1;
            }
            if (name.contentEquals("DebugTwo")) {
                return 2;
            }
            if (name.contentEquals("DebugThree")) {
                return 3;
            }
            if (name.contentEquals("DebugFour")) {
                return 4;
            }
            if (name.contentEquals("bas-4")) {
                return 5;
            }
            if (name.contentEquals("bas-3")) {
                return 6;
            }
            if (name.contentEquals("bas-h")) {
                return 7;
            }
            if (name.contentEquals("bas-c")) {
                return 8;
            }
            if (name.contentEquals("bas-1")) {
                return 9;
            }
            if (name.contentEquals("adv-4")) {
                return 10;
            }
            if (name.contentEquals("adv-3")) {
                return 11;
            }
            if (name.contentEquals("adv-h")) {
                return 12;
            }
            if (name.contentEquals("adv-c")) {
                return 13;
            }
            if (name.contentEquals("adv-1")) {
                return 14;
            }
            if (name.contains("theme-")) {
                return 15;
            }
        }
        return 0;
    }

    public static boolean dungeonAlreadyExistsHere(Level worldIn, long entranceX, long entranceZ) {
        ChunkPos cpos = new ChunkPos((int)entranceX / 16, (int)entranceZ / 16);
        return DungeonPlacement.wasRoomBuiltAtChunk(worldIn, cpos);
    }

    public static boolean personalPortalAlreadyExistsHere(Level worldIn, long entranceX, long entranceZ) {
        ChunkPos cpos;
        BlockPos bpos;
        ServerLevel buildDim = DungeonUtils.getPersonalBuildWorld(worldIn.getServer());
        BlockState block = buildDim.getBlockState(bpos = new BlockPos((int)((float)(cpos = new ChunkPos((int)entranceX / 16 + 4, (int)entranceZ / 16 + 4)).getMinBlockX() + 64.0f), 50, (int)((float)cpos.getMinBlockZ() + 128.0f)));
        return block.getBlock() == Blocks.BEDROCK;
    }

    public static void openPortalAfterBuild(Level worldIn, BlockPos pos, DungeonGenData genData, TileEntityPortalKeyhole myEntity) {
        if (!worldIn.isClientSide) {
            Player player;
            BlockState state = worldIn.getBlockState(pos);
            BaseItemKey key = (BaseItemKey)genData.keyItem.getItem();
            Direction keyholeFacing = (Direction)state.getValue((Property)BlockPortalKeyhole.FACING);
            float entranceX = key.getWarpX(genData.keyItem);
            float entranceZ = key.getWarpZ(genData.keyItem);
            boolean dungeonExistsHere = false;
            dungeonExistsHere = key instanceof ItemBuildKey ? DungeonUtils.reprogramPersonalPortal(worldIn, (long)entranceX, (long)entranceZ, genData, keyholeFacing) : (genData.dungeonType == DungeonDesigner.DungeonType.TELEPORTER_HUB ? DungeonUtils.reprogramTeleporterHubDoorway(worldIn, (long)entranceX, (long)entranceZ, genData, keyholeFacing, false) : DungeonUtils.reprogramExistingExitDoorway(worldIn, (long)entranceX, (long)entranceZ, genData, keyholeFacing));
            if (BlockPortalKeyhole.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity) && dungeonExistsHere) {
                Direction.Axis axis = keyholeFacing == Direction.NORTH || keyholeFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                BlockPortalKeyhole.addGoldenPortalBlock(worldIn, pos.below(), genData.keyItem, axis);
                BlockPortalKeyhole.addGoldenPortalBlock(worldIn, pos.below(2), genData.keyItem, axis);
            }
            if ((player = worldIn.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), -1.0, false)) != null) {
                BlockPortalKeyhole.checkForProblemsAndLiterallySpeakToPlayer(worldIn, pos, state, myEntity, player, dungeonExistsHere);
            }
        }
    }

    public static boolean reprogramExistingExitDoorway(Level worldIn, long entranceX, long entranceZ, DungeonGenData genData, Direction keyholeFacing) {
        ServerLevel dim = DungeonUtils.getDungeonWorld(worldIn.getServer());
        BlockPos portalStart = new BlockPos((int)entranceX, 55, (int)(entranceZ + 2L));
        return DungeonUtils.actuallyReprogramGoldPortalBlocks(portalStart, (Level)dim, genData, keyholeFacing);
    }

    public static boolean reprogramPersonalPortal(Level worldIn, long entranceX, long entranceZ, DungeonGenData genData, Direction keyholeFacing) {
        ServerLevel dim = DungeonUtils.getPersonalBuildWorld(worldIn.getServer());
        BlockPos portalStart = new BlockPos((int)(entranceX + 1L), 51, (int)(entranceZ + 1L));
        if (genData.returnDimension.equals(DimDungeons.BUILD_DIMENSION.location().toString())) {
            return false;
        }
        return DungeonUtils.actuallyReprogramGoldPortalBlocks(portalStart, (Level)dim, genData, keyholeFacing);
    }

    public static boolean reprogramTeleporterHubDoorway(Level worldIn, long entranceX, long entranceZ, DungeonGenData genData, Direction keyholeFacing, boolean erasePortal) {
        ServerLevel dim = DungeonUtils.getDungeonWorld(worldIn.getServer());
        BlockPos portalStart = new BlockPos((int)entranceX, 55, (int)entranceZ);
        int[] undo_x_offset = new int[]{0, -16, -21, -21, -16, 0, 5, 5};
        int[] undo_z_offset = new int[]{0, 0, -5, -21, -26, -26, -21, -5};
        int[] x_offset = new int[]{0, -16, -23, -23, -16, 0, 6, 6};
        int[] z_offset = new int[]{-2, -2, -6, -22, -25, -25, -22, -6};
        int doornum = genData.dungeonTheme;
        portalStart = portalStart.west(undo_x_offset[doornum]).east(x_offset[doornum]);
        portalStart = portalStart.south(undo_z_offset[doornum]).north(z_offset[doornum]);
        for (int xz = 0; xz < 2; ++xz) {
            for (int y = 0; y < 3; ++y) {
                BlockPos nextBlock = portalStart;
                Direction.Axis face = Direction.Axis.X;
                if (doornum == 0 || doornum == 1 || doornum == 4 || doornum == 5) {
                    nextBlock = nextBlock.west(xz).above(y);
                } else {
                    nextBlock = nextBlock.north(xz).above(y);
                    face = Direction.Axis.Z;
                }
                if (erasePortal) {
                    dim.setBlock(nextBlock, Blocks.AIR.defaultBlockState(), 2);
                    continue;
                }
                dim.setBlock(nextBlock, (BlockState)((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState().setValue(BlockGoldPortal.AXIS, (Comparable)face), 2);
                TileEntityGoldPortal te = (TileEntityGoldPortal)dim.getBlockEntity(nextBlock);
                if (te != null) {
                    te.setDestination(genData.returnPoint.getX(), genData.returnPoint.getY(), genData.returnPoint.getZ(), genData.returnDimension, keyholeFacing);
                    DimDungeons.logMessageInfo("DIMDUNGEONS INFO: Reprogrammed exit door at (" + nextBlock.getX() + ", " + nextBlock.getY() + ", " + nextBlock.getZ() + ") in dim " + dim.dimension().location().getPath());
                    continue;
                }
                DimDungeons.logMessageWarn("DIMDUNGEONS WARNING: why is there no exit portal here? (" + nextBlock.getX() + ", " + nextBlock.getY() + ", " + nextBlock.getZ() + ")");
            }
        }
        return true;
    }

    protected static boolean actuallyReprogramGoldPortalBlocks(BlockPos bottomLeft, Level dim, DungeonGenData genData, Direction keyholeFacing) {
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 3; ++y) {
                BlockPos pos = bottomLeft.west(z).above(y);
                TileEntityGoldPortal te = (TileEntityGoldPortal)dim.getBlockEntity(pos);
                if (te == null) {
                    DimDungeons.logMessageWarn("DIMDUNGEONS WARNING: why is there no exit portal here? (" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ")");
                    return false;
                }
                te.setDestination(genData.returnPoint.getX(), genData.returnPoint.getY(), genData.returnPoint.getZ(), genData.returnDimension, keyholeFacing);
                DimDungeons.logMessageInfo("DIMDUNGEONS INFO: Reprogrammed exit door at (" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + ") in dim " + dim.dimension().location().getPath());
            }
        }
        return true;
    }

    public static void buildSuperflatPersonalSpace(long buildX, long buildZ, MinecraftServer server) {
        BlockState[] layers = new BlockState[]{Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.DEEPSLATE.defaultBlockState(), Blocks.DEEPSLATE.defaultBlockState()};
        ServerLevel dim = DungeonUtils.getPersonalBuildWorld(server);
        ChunkPos cpos = new ChunkPos((int)buildX / 16 + 4, (int)buildZ / 16 + 4);
        BlockPos bpos = new BlockPos(cpos.getMinBlockX(), 50, cpos.getMinBlockZ());
        for (int y = 0; y < 8; ++y) {
            BoundingBox pArea = new BoundingBox(bpos.getX(), 50 - y, bpos.getZ(), bpos.getX() + 128 - 1, 50 - y, bpos.getZ() + 128 - 1);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)pArea.minX(), (int)pArea.minY(), (int)pArea.minZ(), (int)pArea.maxX(), (int)pArea.maxY(), (int)pArea.maxZ())) {
                dim.setBlock(blockpos, layers[y], 2);
            }
        }
        BlockPos portalStart = new BlockPos((int)((float)cpos.getMinBlockX() + 64.0f), 50, (int)((float)cpos.getMinBlockZ() + 128.0f));
        dim.setBlock(portalStart, Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.east(), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.west(), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.east(2), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west(), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south(), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(2), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west().above(), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(2).above(), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west().above(2), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(2).above(2), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west().above(3), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(2).above(3), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west().above(4), ((BlockGildedPortal)((Object)BlockRegistrar.BLOCK_GILDED_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(2).above(4), ((BlockGildedPortal)((Object)BlockRegistrar.BLOCK_GILDED_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().above(4), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east().above(4), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west(3), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(4), Blocks.BEDROCK.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west(3).above(), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(4).above(), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west(3).above(2), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(4).above(2), Blocks.STONE_BRICKS.defaultBlockState(), 2);
        dim.setBlock(portalStart.south().west(3).above(3), ((BlockGildedPortal)((Object)BlockRegistrar.BLOCK_GILDED_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east(4).above(3), ((BlockGildedPortal)((Object)BlockRegistrar.BLOCK_GILDED_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().above(), ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east().above(), ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().above(2), ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east().above(2), ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().above(3), ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
        dim.setBlock(portalStart.south().east().above(3), ((BlockGoldPortal)((Object)BlockRegistrar.BLOCK_GOLD_PORTAL.get())).defaultBlockState(), 2);
    }

    public static String serializeDimensionKey(ResourceKey<Level> dimension) {
        return dimension.location().getNamespace() + ":" + dimension.location().getPath();
    }

    public static long getLimitOfWorldBorder(MinecraftServer server) {
        ResourceKey configkey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)DungeonConfig.worldborderToRespect));
        ServerLevel world = server.getLevel(configkey);
        double size = world.getWorldBorder().getSize() / 2.0;
        return Math.round(size);
    }

    public static long getLimitOfPersonalBuildDimension(MinecraftServer server) {
        ServerLevel world = DungeonUtils.getPersonalBuildWorld(server);
        double size = world.getWorldBorder().getSize() / 2.0;
        return Math.round(size);
    }

    public static boolean isPersonalBuildChunk(BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        if (chunk.x < 4 || chunk.z < 4) {
            return false;
        }
        int nx = (chunk.x - 4) % 32;
        int nz = (chunk.z - 4) % 32;
        return nx < 8 && nz < 8;
    }

    public static void sendEntityHomeInBuildWorld(Entity entity) {
        double topLeftX = Math.floor(entity.position().x / 512.0);
        topLeftX = topLeftX * 512.0 + 136.0;
        double topLeftZ = Math.floor(entity.position().z / 512.0);
        topLeftZ = topLeftZ * 512.0 + 188.5;
        ServerLevel dim = DungeonUtils.getPersonalBuildWorld(entity.getServer());
        DimensionTransition dt = new DimensionTransition(dim, new Vec3(topLeftX - 7.0, 51.0, topLeftZ + 4.0), new Vec3(0.0, 0.0, 0.0), 180.0f, 0.0f, false, DimensionTransition.DO_NOTHING);
        entity.changeDimension(dt);
    }

    public static ItemStack getExampleKey() {
        ItemStack icon = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
        DungeonKeyDataComponentRecord data = (DungeonKeyDataComponentRecord)icon.get(DimDungeons.DUNGEON_KEY_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(true, true, data.dest_x(), data.dest_z(), 2, 0, 17, 0, data.dungeon_type());
        icon.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
        return icon;
    }

    public static ItemStack getExampleBuildKey() {
        ItemStack icon = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
        DungeonKeyDataComponentRecord data = (DungeonKeyDataComponentRecord)icon.get(DimDungeons.DUNGEON_KEY_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(true, true, data.dest_x(), data.dest_z(), data.name_type(), data.name_part_1(), data.name_part_2(), 0, data.dungeon_type());
        icon.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
        return icon;
    }

    public static ItemStack getExampleTeleporterHubKey() {
        ItemStack icon = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
        DungeonKeyDataComponentRecord data = (DungeonKeyDataComponentRecord)icon.get(DimDungeons.DUNGEON_KEY_DATA);
        DungeonKeyDataComponentRecord newData = new DungeonKeyDataComponentRecord(true, true, data.dest_x(), data.dest_z(), 4, 0, data.name_part_2(), 0, DungeonDesigner.DungeonType.TELEPORTER_HUB.toString());
        icon.set(DimDungeons.DUNGEON_KEY_DATA, (Object)newData);
        return icon;
    }

    public static void giveSecuritySystemPrompt(Player playerIn, String transkey) {
        MutableComponent text1 = Component.translatable((String)Component.translatable((String)transkey).getString());
        text1.withStyle(text1.getStyle().withItalic(Boolean.valueOf(true)));
        text1.withStyle(text1.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.displayClientMessage((Component)text1, false);
    }

    public static void displayGuestList(Player playerIn, ArrayList<String> guestList) {
        MutableComponent text1 = Component.translatable((String)Component.translatable((String)"security.dimdungeons.use_book").getString());
        for (int i = 0; i < guestList.size(); ++i) {
            if (i != 0) {
                text1.append(", ");
            }
            text1.append(guestList.get(i));
        }
        text1.withStyle(text1.getStyle().withItalic(Boolean.valueOf(true)));
        text1.withStyle(text1.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.displayClientMessage((Component)text1, false);
    }

    public static void notifyGuestListChange(Player playerIn, String transkey, String playerName) {
        MutableComponent text1 = Component.translatable((String)playerName);
        text1.append(Component.translatable((String)transkey).getString());
        text1.withStyle(text1.getStyle().withItalic(Boolean.valueOf(true)));
        text1.withStyle(text1.getStyle().withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)));
        playerIn.displayClientMessage((Component)text1, false);
    }
}

