/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.impl.gametest.network.SyncS2CPacket;
import org.slf4j.Logger;

public class TestUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ExecutorService WAITING_EXECUTOR = Executors.newCachedThreadPool();
    private static final Method getBoundsMethod;

    public static Vec3 getClientPosition() {
        return (Vec3)Minecraft.getInstance().submit(() -> {
            LocalPlayer clientPlayer = Minecraft.getInstance().player;
            return clientPlayer != null ? clientPlayer.position() : Vec3.ZERO;
        }).join();
    }

    public static boolean isChunkVisible(Vec3 position) {
        return (Boolean)Minecraft.getInstance().submit(() -> {
            BlockPos pos = BlockPos.containing((double)position.x, (double)position.y, (double)position.z);
            return Minecraft.getInstance().levelRenderer.isSectionCompiled(pos);
        }).join();
    }

    public static void sleepForMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForConditionMetOnClient(BooleanSupplier condition) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            while (!condition.getAsBoolean()) {
                TestUtils.sleepForMillis(100L);
            }
        }, WAITING_EXECUTOR);
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Client did not meet condition quickly enough", e);
        }
    }

    public static void waitTillClientIsCloseTo(Vec3 position) {
        CompletableFuture<Void> positionFuture = CompletableFuture.runAsync(() -> {
            Vec3 playerPos = TestUtils.getClientPosition();
            while (playerPos == Vec3.ZERO || playerPos.distanceToSqr(position) > 1.0) {
                TestUtils.sleepForMillis(100L);
                playerPos = TestUtils.getClientPosition();
            }
            Minecraft.getInstance().submit(() -> Minecraft.getInstance().levelRenderer.allChanged()).join();
            while (!TestUtils.isChunkVisible(position)) {
                TestUtils.sleepForMillis(100L);
            }
        }, WAITING_EXECUTOR);
        try {
            positionFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException("Client position did not update", e);
        }
    }

    public static void movePlayerToPosition(GameTestHelper helper, BlockPos pos) {
        BlockPos realPos = helper.absolutePos(pos);
        List playerList = Minecraft.getInstance().getSingleplayerServer().getPlayerList().getPlayers();
        if (playerList.size() != 1) {
            throw new IllegalStateException("Unexpected number of players: " + playerList.size());
        }
        ServerPlayer player = (ServerPlayer)playerList.get(0);
        Abilities abilities = player.getAbilities();
        if (!(abilities.mayfly && abilities.flying && abilities.invulnerable)) {
            abilities.mayfly = true;
            abilities.flying = true;
            abilities.invulnerable = true;
            player.onUpdateAbilities();
        }
        player.setXRot(90.0f);
        player.setYRot(0.0f);
        player.teleportTo((double)realPos.getX(), (double)realPos.getY(), (double)realPos.getZ());
        TestUtils.clientBarrier();
        TestUtils.waitTillClientIsCloseTo(new Vec3((double)realPos.getX(), (double)realPos.getY(), (double)realPos.getZ()));
        Minecraft.getInstance().submit(() -> {
            LocalPlayer cplayer = Minecraft.getInstance().player;
            cplayer.setXRot(90.0f);
            cplayer.setYRot(0.0f);
        }).join();
    }

    public static void obtainScreenshot(String name) {
        Minecraft mc = Minecraft.getInstance();
        mc.submit(() -> {
            mc.getMainRenderTarget().bindWrite(true);
            mc.gameRenderer.setRenderBlockOutline(false);
            mc.gameRenderer.render(DeltaTracker.ONE, true);
            mc.gameRenderer.setRenderBlockOutline(true);
            mc.getMainRenderTarget().unbindWrite();
            NativeImage nativeimage = Screenshot.takeScreenshot((RenderTarget)mc.getMainRenderTarget());
            File screenShotDir = new File(mc.gameDirectory, "screenshots");
            screenShotDir.mkdir();
            File screenShot = new File(screenShotDir, name + ".png");
            screenShot.delete();
            try {
                nativeimage.writeToFile(screenShot);
            }
            catch (Exception e) {
                LOGGER.warn("Screenshot failed", (Throwable)e);
            }
            finally {
                nativeimage.close();
            }
        }).join();
    }

    public static void clientBarrier() {
        Minecraft.getInstance().getSingleplayerServer().overworld().getChunkSource().tick(() -> false, true);
        SyncS2CPacket packet = new SyncS2CPacket();
        packet.applyBarrier();
    }

    public static boolean isAABBLoaded(AABB bounds) {
        int minX = SectionPos.posToSectionCoord((double)(bounds.minX - 0.5));
        int minY = SectionPos.posToSectionCoord((double)(bounds.minY - 0.5));
        int minZ = SectionPos.posToSectionCoord((double)(bounds.minZ - 0.5));
        int maxX = SectionPos.posToSectionCoord((double)(bounds.maxX + 0.5));
        int maxY = SectionPos.posToSectionCoord((double)(bounds.maxY + 0.5));
        int maxZ = SectionPos.posToSectionCoord((double)(bounds.maxZ + 0.5));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    pos.set(x << 4, y << 4, z << 4);
                    if (levelRenderer.isSectionCompiled((BlockPos)pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void waitForTestAreaToLoad(GameTestHelper helper) {
        AABB bounds;
        try {
            bounds = (AABB)getBoundsMethod.invoke((Object)helper, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        TestUtils.waitForConditionMetOnClient(() -> TestUtils.isAABBLoaded(bounds));
    }

    static {
        try {
            getBoundsMethod = GameTestHelper.class.getDeclaredMethod("getBounds", new Class[0]);
            getBoundsMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError();
        }
    }
}

