/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.items;

import appeng.api.config.FuzzyMode;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.items.contents.CellConfig;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import com.sts15.enderdrives.client.ClientConfigCache;
import com.sts15.enderdrives.db.ClientDiskCache;
import com.sts15.enderdrives.db.DiskTypeInfo;
import com.sts15.enderdrives.integration.FTBTeamsCompat;
import com.sts15.enderdrives.items.ItemInit;
import com.sts15.enderdrives.network.NetworkHandler;
import com.sts15.enderdrives.screen.EnderDiskFrequencyScreen;
import com.sts15.enderdrives.screen.FrequencyScope;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderDiskItem
extends Item
implements ICellWorkbenchItem,
IMenuItem {
    private static final String FREQ_KEY = "ender_freq";
    private static final String SCOPE_KEY = "ender_scope";
    private static final String OWNER_KEY = "ender_owner";
    private static final String TEAM_KEY = "ender_team";
    private static final String TEAM_NAME_KEY = "ender_team_name";
    private static final String TRANSFER_MODE_KEY = "ender_transfer_mode";
    private final Supplier<Integer> typeLimit;

    public EnderDiskItem(Item.Properties props, Supplier<Integer> typeLimit) {
        super(props.stacksTo(1));
        this.typeLimit = typeLimit;
    }

    public int getTypeLimit() {
        return this.typeLimit.get();
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag advancedTooltips) {
        if (Platform.isClient()) {
            if (this.isDisabled(stack)) {
                lines.add((Component)Component.literal((String)"\u00a7cThis item is disabled on the server."));
                return;
            }
            this.addCellInformationToTooltip(stack, lines);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addCellInformationToTooltip(ItemStack stack, List<Component> lines) {
        LocalPlayer player = Minecraft.getInstance().player;
        int freq = EnderDiskItem.getFrequency(stack);
        String scopePrefix = EnderDiskItem.getSafeScopePrefix(stack);
        String key = scopePrefix + "|" + freq;
        NetworkHandler.requestDiskTypeCount(scopePrefix, freq, this.getTypeLimit());
        DiskTypeInfo info = ClientDiskCache.get(key);
        int typeCount = info.typeCount();
        int typeLimit = info.typeLimit();
        int percentFull = typeLimit == 0 ? 0 : typeCount * 100 / typeLimit;
        int limitColor = 8809980;
        int usageColor = typeCount >= typeLimit ? 0xFF5555 : (percentFull >= 75 ? 0xFFAA00 : 0x55FF55);
        lines.add((Component)Component.translatable((String)"tooltip.enderdrives.types", (Object[])new Object[]{Component.literal((String)String.valueOf(typeCount)).withStyle(style -> style.withColor(usageColor)), Component.literal((String)String.valueOf(typeLimit)).withStyle(style -> style.withColor(limitColor))}));
        lines.add((Component)Component.translatable((String)"tooltip.enderdrives.frequency", (Object[])new Object[]{freq}).withStyle(style -> style.withColor(0xFFFF55)));
        int mode = EnderDiskItem.getTransferMode(stack);
        String modeKey = switch (mode) {
            case 1 -> "tooltip.enderdrives.mode.input";
            case 2 -> "tooltip.enderdrives.mode.output";
            default -> "tooltip.enderdrives.mode.bidirectional";
        };
        lines.add((Component)Component.translatable((String)modeKey));
        FrequencyScope scope = EnderDiskItem.getScope(stack);
        MutableComponent scopeLine = switch (scope) {
            case FrequencyScope.PERSONAL -> {
                UUID owner = EnderDiskItem.getOwnerUUID(stack);
                String name = player != null && owner != null && player.getUUID().equals(owner) ? player.getName().getString() : (owner != null ? owner.toString() : Component.translatable((String)"tooltip.enderdrives.unknown").getString());
                yield Component.translatable((String)"tooltip.enderdrives.scope.private", (Object[])new Object[]{name});
            }
            case FrequencyScope.TEAM -> {
                String teamName = EnderDiskItem.getStoredTeamName(stack);
                yield Component.translatable((String)"tooltip.enderdrives.scope.team", (Object[])new Object[]{teamName != null ? teamName : Component.translatable((String)"tooltip.enderdrives.unknown")});
            }
            default -> Component.translatable((String)"tooltip.enderdrives.scope.global");
        };
        lines.add((Component)scopeLine);
        ConfigInventory config = CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)stack);
        int partitionCount = config.keySet().size();
        if (partitionCount > 0) {
            String plural = partitionCount == 1 ? "" : "s";
            lines.add((Component)Component.translatable((String)"tooltip.enderdrives.partitioned", (Object[])new Object[]{partitionCount, plural}));
        }
    }

    public static void setTeamInfo(ItemStack stack, String teamId, String teamName) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putString(TEAM_KEY, teamId);
            tag.putString(TEAM_NAME_KEY, teamName);
            return CustomData.of((CompoundTag)tag);
        });
    }

    public static void updateTeamInfo(ItemStack stack, Player player) {
        if (!ModList.get().isLoaded("ftbteams")) {
            return;
        }
        try {
            FTBTeamsCompat.updateTeamInfo(stack, player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    public static String getStoredTeamName(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(TEAM_NAME_KEY) ? tag.getString(TEAM_NAME_KEY) : null;
    }

    public static String getSafeScopePrefix(ItemStack stack) {
        FrequencyScope scope = EnderDiskItem.getScope(stack);
        return switch (scope) {
            case FrequencyScope.PERSONAL -> {
                UUID owner = EnderDiskItem.getOwnerUUID(stack);
                if (owner != null) {
                    yield "player_" + String.valueOf(owner);
                }
                yield "player_unknown";
            }
            case FrequencyScope.TEAM -> {
                String teamId = EnderDiskItem.getStoredTeamId(stack);
                if (teamId != null && !teamId.isEmpty()) {
                    yield "team_" + teamId;
                }
                yield "global";
            }
            default -> "global";
        };
    }

    public int getTypeLimit(ItemStack stack) {
        return this.typeLimit.get();
    }

    public static int getFrequency(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return 0;
        }
        CompoundTag tag = data.copyTag();
        return tag.getInt(FREQ_KEY);
    }

    public static void setFrequency(ItemStack stack, int freq) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putInt(FREQ_KEY, freq);
            return CustomData.of((CompoundTag)tag);
        });
    }

    public static FrequencyScope getScope(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return FrequencyScope.getDefault();
        }
        CompoundTag tag = data.copyTag();
        return FrequencyScope.fromId(tag.getInt(SCOPE_KEY));
    }

    public static void setScope(ItemStack stack, FrequencyScope scope) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putInt(SCOPE_KEY, scope.id);
            return CustomData.of((CompoundTag)tag);
        });
    }

    public static void setOwnerUUID(ItemStack stack, UUID uuid) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putString(OWNER_KEY, uuid.toString());
            return CustomData.of((CompoundTag)tag);
        });
    }

    @Nullable
    public static UUID getOwnerUUID(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        if (!tag.contains(OWNER_KEY)) {
            return null;
        }
        try {
            return UUID.fromString(tag.getString(OWNER_KEY));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void setTeamId(ItemStack stack, String teamId) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putString(TEAM_KEY, teamId);
            return CustomData.of((CompoundTag)tag);
        });
    }

    @Nullable
    public static String getStoredTeamId(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(TEAM_KEY) ? tag.getString(TEAM_KEY) : null;
    }

    public ConfigInventory getConfigInventory(ItemStack stack) {
        return CellConfig.create(Set.of(AEKeyType.items()), (ItemStack)stack);
    }

    public FuzzyMode getFuzzyMode(ItemStack stack) {
        return FuzzyMode.IGNORE_ALL;
    }

    public void setFuzzyMode(ItemStack stack, FuzzyMode mode) {
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isDisabled(itemStack)) {
            if (level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cThis EnderDisk is disabled on the server."), true);
            }
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (level.isClientSide) {
            int freq = EnderDiskItem.getFrequency(itemStack);
            FrequencyScope scope = EnderDiskItem.getScope(itemStack);
            int transferMode = EnderDiskItem.getTransferMode(itemStack);
            EnderDiskFrequencyScreen.open(freq, scope, transferMode);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EnderDiskItem.resolveAndCacheTeamInfo(itemStack, serverPlayer);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public boolean isDisabled(ItemStack stack) {
        int index = EnderDiskItem.getDriveIndex(this);
        return index >= 0 && ClientConfigCache.isDriveDisabled(index);
    }

    public static int getDriveIndex(Item item) {
        if (item == ItemInit.ENDER_DISK_1K.get()) {
            return 0;
        }
        if (item == ItemInit.ENDER_DISK_4K.get()) {
            return 1;
        }
        if (item == ItemInit.ENDER_DISK_16K.get()) {
            return 2;
        }
        if (item == ItemInit.ENDER_DISK_64K.get()) {
            return 3;
        }
        if (item == ItemInit.ENDER_DISK_256K.get()) {
            return 4;
        }
        if (item == ItemInit.ENDER_DISK_creative.get()) {
            return 5;
        }
        if (item == ItemInit.TAPE_DISK.get()) {
            return 6;
        }
        return -1;
    }

    public static void resolveAndCacheTeamInfo(ItemStack stack, ServerPlayer player) {
        if (!ModList.get().isLoaded("ftbteams")) {
            return;
        }
        try {
            FTBTeamsCompat.updateTeamInfo(stack, player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    public ItemMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return null;
    }

    public static int getTransferMode(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return 0;
        }
        CompoundTag tag = data.copyTag();
        return tag.getInt(TRANSFER_MODE_KEY);
    }

    public static void setTransferMode(ItemStack stack, int mode) {
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, oldData -> {
            CompoundTag tag = oldData.copyTag();
            tag.putInt(TRANSFER_MODE_KEY, mode);
            return CustomData.of((CompoundTag)tag);
        });
    }
}

