/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.living.entityjs;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Function;
import net.liopyu.entityjs.builders.living.entityjs.PathfinderMobBuilder;
import net.liopyu.entityjs.entities.living.entityjs.WaterEntityJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;

public class WaterEntityJSBuilder
extends PathfinderMobBuilder<WaterEntityJS> {
    public transient Function<LivingEntity, Object> bucketItemStack;
    public transient boolean defaultGoals = true;
    public transient boolean canBeBucketed = false;

    public WaterEntityJSBuilder(ResourceLocation i) {
        super(i);
    }

    @Info(value="Whether or not the fish can be bucketed, if true it is recommended to set the\nbucketItemStack function in the builder otherwise it will give an empty itemstack\nand the bucket will be lost.\nDefaults to false\nExample usage:\n```javascript\nbuilder.setCanBeBucketed(true)\n```\n")
    public WaterEntityJSBuilder setCanBeBucketed(boolean canBeBucketed) {
        this.canBeBucketed = canBeBucketed;
        return this;
    }

    @Info(value="Whether or not the fish retains default swimming goals.\nDefaults to True\nExample usage:\n```javascript\nbuilder.setDefaultGoals(false)\n```\n")
    public WaterEntityJSBuilder setDefaultGoals(boolean defaultGoals) {
        this.defaultGoals = defaultGoals;
        return this;
    }

    @Info(value="@param bucketItemStack Function returning the itemstack to receive when bucketed\nDefaults to Empty Itemstack\nExample usage:\n```javascript\nbuilder.bucketItemStack(entity => {\n    // Use information about the entity to return an ItemStack.\n    return Item.of('minecraft:diamond')\n})\n```\n")
    public WaterEntityJSBuilder bucketItemStack(Function<LivingEntity, Object> function) {
        this.bucketItemStack = function;
        return this;
    }

    @Override
    public EntityType.EntityFactory<WaterEntityJS> factory() {
        return (type, level) -> new WaterEntityJS(this, (EntityType<? extends AbstractFish>)type, level);
    }

    @Override
    public AttributeSupplier.Builder getAttributeBuilder() {
        return WaterEntityJS.createAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.FOLLOW_RANGE).add(Attributes.ATTACK_DAMAGE).add(Attributes.ARMOR).add(Attributes.ARMOR_TOUGHNESS).add(Attributes.ATTACK_SPEED).add(Attributes.ATTACK_KNOCKBACK).add(Attributes.LUCK).add(Attributes.MOVEMENT_SPEED);
    }
}

