/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.living.vanilla;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Function;
import net.liopyu.entityjs.builders.living.entityjs.PathfinderMobBuilder;
import net.liopyu.entityjs.entities.living.vanilla.SkeletonEntityJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SkeletonJSBuilder
extends PathfinderMobBuilder<SkeletonEntityJS> {
    public transient Boolean defaultGoals = true;
    public transient SoundEvent shootSound = SoundEvents.SKELETON_SHOOT;
    public transient Function<LivingEntity, Object> isSunBurnTick;
    public transient boolean canConvert = true;
    public transient EntityType<? extends Mob> conversionType;
    public transient ItemStack setArrow = new ItemStack((ItemLike)Items.ARROW);

    public SkeletonJSBuilder(ResourceLocation i) {
        super(i);
    }

    @Info(value="@param setArrow Sets the arrow entity to be fired.\nDefaults to \"minecraft:arrow\".\n\nExample usage:\n```javascript\nbuilder.setArrow(\"minecraft:arrow\");\n```\n")
    public SkeletonJSBuilder setArrow(ItemStack setArrow) {
        this.setArrow = setArrow;
        return this;
    }

    @Info(value="@param setShootSound Sets the mobs shooting sound\n\nExample usage:\n```javascript\nbuilder.setShootSound(\"entity.skeleton.shoot\");\n```\n")
    public SkeletonJSBuilder setShootSound(SoundEvent shootSound) {
        this.shootSound = shootSound;
        return this;
    }

    @Info(value="@param setConversionType Sets what mob the entity should convert to after freezing. Must be a Mob.\nDefaults to \"minecraft:stray\".\n\nExample usage:\n```javascript\nbuilder.setConversionType(\"minecraft:stray\");\n```\n")
    public SkeletonJSBuilder setConversionType(EntityType<? extends Mob> conversionType) {
        this.conversionType = conversionType;
        return this;
    }

    @Info(value="@param canConvert Sets whether the mob should convert while freezing to another mob\nDefaults to true.\n\nExample usage:\n```javascript\nbuilder.canConvert(false);\n```\n")
    public SkeletonJSBuilder canConvert(boolean canConvert) {
        this.canConvert = canConvert;
        return this;
    }

    @Info(value="@param isSunBurnTick Sets whether the mob should burn in daylight\n\nExample usage:\n```javascript\nbuilder.isSunBurnTick(entity => {\n    return false\n});\n```\n")
    public SkeletonJSBuilder isSunBurnTick(Function<LivingEntity, Object> isSunBurnTick) {
        this.isSunBurnTick = isSunBurnTick;
        return this;
    }

    @Info(value="@param defaultGoals Sets whether the mob should inherit it's goals from it's superclass\nDefaults to true.\n\nExample usage:\n```javascript\nbuilder.defaultGoals(false);\n```\n")
    public SkeletonJSBuilder defaultGoals(boolean defaultGoals) {
        this.defaultGoals = defaultGoals;
        return this;
    }

    @Override
    public EntityType.EntityFactory<SkeletonEntityJS> factory() {
        return (type, level) -> new SkeletonEntityJS(this, (EntityType<? extends Skeleton>)type, level);
    }

    @Override
    public AttributeSupplier.Builder getAttributeBuilder() {
        return SkeletonEntityJS.createAttributes();
    }
}

