/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.client.living.model.CustomEntityModelJS;
import net.liopyu.entityjs.client.living.model.CustomGeoLayerJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.entities.living.entityjs.WrappedAnimatableEntity;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.implementation.ILivingEntityJS;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public class CustomKubeJSEntityRenderer<T extends LivingEntity>
extends GeoEntityRenderer<T> {
    private final CustomEntityJSBuilder builder;

    public CustomKubeJSEntityRenderer(EntityRendererProvider.Context renderManager, CustomEntityJSBuilder builder) {
        super(renderManager, new CustomEntityModelJS(builder));
        Object layerPart;
        this.builder = builder;
        this.scaleHeight = this.getScaleHeight();
        this.scaleWidth = this.getScaleWidth();
        for (CustomGeoLayerJSBuilder<? extends LivingEntity> geoBuilder : builder.layerList) {
            layerPart = geoBuilder.build(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
        for (CustomGeoLayerJSBuilder<? extends LivingEntity> geoBuilder : builder.glowingLayerList) {
            layerPart = geoBuilder.buildGlowing(this, builder);
            this.addRenderLayer((GeoRenderLayer)layerPart);
        }
    }

    public String entityName() {
        return ((LivingEntity)this.animatable).getType().toString();
    }

    public float getScaleHeight() {
        return this.builder.scaleHeight;
    }

    public float getScaleWidth() {
        return this.builder.scaleWidth;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T a, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        Object animatable = a;
        if (animatable instanceof WrappedAnimatableEntity) {
            WrappedAnimatableEntity wrappedAnimatableEntity = (WrappedAnimatableEntity)animatable;
            animatable = wrappedAnimatableEntity.getOriginalEntity();
        }
        if (this.builder.scaleModelForRender != null && this.animatable != null) {
            ContextUtils.ScaleModelRenderContext context = new ContextUtils.ScaleModelRenderContext(this, widthScale, heightScale, poseStack, (LivingEntity)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.builder.scaleModelForRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: scaleModelForRender.");
            super.scaleModelForRender(widthScale, heightScale, poseStack, this.ensureIAnimatableJS((LivingEntity)animatable), model, isReRender, partialTick, packedLight, packedOverlay);
        } else {
            super.scaleModelForRender(widthScale, heightScale, poseStack, this.ensureIAnimatableJS((LivingEntity)animatable), model, isReRender, partialTick, packedLight, packedOverlay);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return (ResourceLocation)this.builder.textureResource.apply((LivingEntity)entity);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        try {
            if (this.builder.renderTypeFunction != null) {
                return this.builder.renderTypeFunction.apply((LivingEntity)this.ensureIAnimatableJS((LivingEntity)animatable));
            }
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in " + this.entityName() + "builder for field: renderTypeFunction.", e);
        }
        return switch (((IAnimatableJSCustom)this.ensureIAnimatableJS(animatable)).getBuilder().renderType) {
            default -> throw new MatchException(null, null);
            case CustomEntityJSBuilder.RenderType.SOLID -> RenderType.entitySolid((ResourceLocation)texture);
            case CustomEntityJSBuilder.RenderType.CUTOUT -> RenderType.entityCutout((ResourceLocation)texture);
            case CustomEntityJSBuilder.RenderType.TRANSLUCENT -> RenderType.entityTranslucent((ResourceLocation)texture);
        };
    }

    public void render(T a, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Object animatable = a;
        if (animatable instanceof WrappedAnimatableEntity) {
            WrappedAnimatableEntity wrappedAnimatableEntity = (WrappedAnimatableEntity)animatable;
            animatable = wrappedAnimatableEntity.getOriginalEntity();
        }
        if (this.builder.render != null && this.animatable != null) {
            ContextUtils.RenderContextCustom<T> context = new ContextUtils.RenderContextCustom<T>(this.ensureIAnimatableJS((LivingEntity)animatable), entityYaw, partialTick, poseStack, bufferSource, packedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render.");
            super.render(this.ensureIAnimatableJS((LivingEntity)animatable), entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            super.render(this.ensureIAnimatableJS((LivingEntity)animatable), entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    protected void applyRotations(T a, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        Object animatable = a;
        if (animatable instanceof WrappedAnimatableEntity) {
            WrappedAnimatableEntity wrappedAnimatableEntity = (WrappedAnimatableEntity)animatable;
            animatable = wrappedAnimatableEntity.getOriginalEntity();
        }
        if (this.isShaking((Entity)this.ensureIAnimatableJS((LivingEntity)animatable))) {
            rotationYaw += (float)(Math.cos((double)((LivingEntity)animatable).tickCount * 3.25) * Math.PI * 0.4);
        }
        if (!animatable.hasPose(Pose.SLEEPING)) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        }
        if (animatable instanceof LivingEntity) {
            Object livingEntity = animatable;
            if (((LivingEntity)livingEntity).deathTime > 0 && this.builder.defaultDeathPose.booleanValue()) {
                float deathRotation = ((float)((LivingEntity)livingEntity).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)deathRotation), 1.0f) * this.getDeathMaxRotation((Entity)this.ensureIAnimatableJS((LivingEntity)animatable))));
            } else if (livingEntity.isAutoSpinAttack()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - livingEntity.getXRot()));
                poseStack.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)livingEntity).tickCount + partialTick) * -75.0f));
            } else if (animatable.hasPose(Pose.SLEEPING)) {
                Direction bedOrientation = livingEntity.getBedOrientation();
                poseStack.mulPose(Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtil.getDirectionAngle((Direction)bedOrientation) : rotationYaw));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation((Entity)this.ensureIAnimatableJS((LivingEntity)animatable))));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            } else if (LivingEntityRenderer.isEntityUpsideDown(livingEntity)) {
                poseStack.translate(0.0f, (animatable.getBbHeight() + 0.1f) / nativeScale, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    private T ensureIAnimatableJS(LivingEntity entity) {
        if (entity instanceof IAnimatableJSCustom) {
            IAnimatableJSCustom animatableJS = (IAnimatableJSCustom)entity;
            return (T)((LivingEntity)animatableJS);
        }
        if (entity instanceof ILivingEntityJS) {
            ILivingEntityJS iLivingEntityJS = (ILivingEntityJS)entity;
            return (T)iLivingEntityJS.entityJs$getAnimatableEntity();
        }
        return (T)new WrappedAnimatableEntity(entity, this.builder);
    }
}

