/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living.model;

import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJSCustom;
import net.liopyu.entityjs.entities.living.entityjs.WrappedAnimatableEntity;
import net.liopyu.entityjs.util.implementation.ILivingEntityJS;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib.model.GeoModel;

public class CustomEntityModelJS<T extends LivingEntity>
extends GeoModel<T> {
    private final CustomEntityJSBuilder builder;

    public CustomEntityModelJS(CustomEntityJSBuilder builder) {
        this.builder = builder;
    }

    public ResourceLocation getModelResource(T animatable) {
        T a = this.ensureIAnimatableJS((LivingEntity)animatable);
        return (ResourceLocation)this.builder.modelResource.apply((WrappedAnimatableEntity)a);
    }

    public ResourceLocation getTextureResource(T animatable) {
        T a = this.ensureIAnimatableJS((LivingEntity)animatable);
        return (ResourceLocation)this.builder.textureResource.apply((WrappedAnimatableEntity)a);
    }

    public ResourceLocation getAnimationResource(T animatable) {
        T a = this.ensureIAnimatableJS((LivingEntity)animatable);
        return (ResourceLocation)this.builder.animationResource.apply((WrappedAnimatableEntity)a);
    }

    private T ensureIAnimatableJS(LivingEntity entity) {
        if (entity instanceof IAnimatableJSCustom) {
            IAnimatableJSCustom animatableJS = (IAnimatableJSCustom)entity;
            return (T)((LivingEntity)animatableJS);
        }
        if (entity instanceof ILivingEntityJS) {
            ILivingEntityJS iLivingEntityJS = (ILivingEntityJS)entity;
            return (T)iLivingEntityJS.entityJs$getAnimatableEntity();
        }
        return (T)new WrappedAnimatableEntity(entity, this.builder);
    }
}

