/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.nonliving;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.BoatEntityBuilder;
import net.liopyu.entityjs.client.nonliving.model.BoatEntityModel;
import net.liopyu.entityjs.entities.nonliving.entityjs.IAnimatableJSNL;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class KubeJSBoatRenderer<T extends Boat>
extends GeoEntityRenderer<T> {
    private final BoatEntityBuilder<T> builder;

    public KubeJSBoatRenderer(EntityRendererProvider.Context pContext, BoatEntityBuilder<?> builder) {
        super(pContext, new BoatEntityModel(builder));
        this.builder = builder;
        this.shadowRadius = this.getShadowRadius();
    }

    private float getShadowRadius() {
        return this.builder.setShadowRadius;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return (ResourceLocation)this.builder.textureResource.apply(entity);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        if (this.builder.renderTypeFunction != null) {
            try {
                return (RenderType)this.builder.renderTypeFunction.apply(animatable);
            }
            catch (RuntimeException e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in renderTypeFunction.", e);
            }
        }
        return switch (((IAnimatableJSNL)animatable).getBuilder().renderType) {
            default -> throw new MatchException(null, null);
            case BaseEntityBuilder.RenderType.SOLID -> RenderType.entitySolid((ResourceLocation)texture);
            case BaseEntityBuilder.RenderType.CUTOUT -> RenderType.entityCutout((ResourceLocation)texture);
            case BaseEntityBuilder.RenderType.TRANSLUCENT -> RenderType.entityTranslucent((ResourceLocation)texture);
        };
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        if (this.builder.render != null) {
            ContextUtils.NLRenderContext<T> context = new ContextUtils.NLRenderContext<T>(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + String.valueOf(pEntity.getType()) + "builder for field: render.");
        }
        pPoseStack.pushPose();
        pPoseStack.translate(0.0f, 0.375f, 0.0f);
        float entityYaw = Mth.lerp((float)pPartialTicks, (float)((Boat)pEntity).yRotO, (float)pEntity.getYRot());
        pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pPoseStack.mulPose(new Quaternionf().setAngleAxis(pEntity.getBubbleAngle(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        pPoseStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }
}

