/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class SavedDataJS
extends SavedData {
    public static final String ID = "entityjs_synced";
    private final Map<UUID, Map<String, Tag>> values = new HashMap<UUID, Map<String, Tag>>();
    private final Map<UUID, Map<String, Integer>> types = new HashMap<UUID, Map<String, Integer>>();

    public static SavedDataJS get(ServerLevel level) {
        return (SavedDataJS)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SavedDataJS::new, SavedDataJS::load, DataFixTypes.LEVEL), ID);
    }

    public static SavedDataJS load(CompoundTag tag, HolderLookup.Provider regs) {
        SavedDataJS d = new SavedDataJS();
        ListTag ents = tag.getList("entries", 10);
        for (Tag t : ents) {
            CompoundTag c = (CompoundTag)t;
            UUID id = c.getUUID("id");
            HashMap<String, Tag> vmap = new HashMap<String, Tag>();
            HashMap<String, Integer> tmap = new HashMap<String, Integer>();
            ListTag vals = c.getList("values", 10);
            for (Tag vt : vals) {
                int type;
                CompoundTag vc = (CompoundTag)vt;
                String name = vc.getString("name");
                Tag v = vc.get("v");
                int n = type = vc.contains("t", 3) ? vc.getInt("t") : -1;
                if (v != null) {
                    vmap.put(name, v.copy());
                }
                if (type < 0) continue;
                tmap.put(name, type);
            }
            d.values.put(id, vmap);
            d.types.put(id, tmap);
        }
        return d;
    }

    public CompoundTag save(CompoundTag out, HolderLookup.Provider regs) {
        ListTag ents = new ListTag();
        for (Map.Entry<UUID, Map<String, Tag>> e : this.values.entrySet()) {
            CompoundTag c = new CompoundTag();
            c.putUUID("id", e.getKey());
            ListTag vals = new ListTag();
            Map tmap = this.types.getOrDefault(e.getKey(), Map.of());
            for (Map.Entry<String, Tag> n : e.getValue().entrySet()) {
                CompoundTag vc = new CompoundTag();
                vc.putString("name", n.getKey());
                vc.put("v", n.getValue().copy());
                if (tmap.containsKey(n.getKey())) {
                    vc.putInt("t", ((Integer)tmap.get(n.getKey())).intValue());
                }
                vals.add((Object)vc);
            }
            c.put("values", (Tag)vals);
            ents.add((Object)c);
        }
        out.put("entries", (Tag)ents);
        return out;
    }

    public Map<String, Tag> getAll(UUID id) {
        Map<String, Tag> m = this.values.get(id);
        if (m == null) {
            return Map.of();
        }
        HashMap<String, Tag> copy = new HashMap<String, Tag>();
        m.forEach((k, v) -> copy.put((String)k, v.copy()));
        return copy;
    }

    public Map<String, Integer> getTypes(UUID id) {
        Map<String, Integer> m = this.types.get(id);
        if (m == null) {
            return Map.of();
        }
        return new HashMap<String, Integer>(m);
    }

    public Tag get(UUID id, String name) {
        Map<String, Tag> m = this.values.get(id);
        if (m == null) {
            return null;
        }
        Tag t = m.get(name);
        return t == null ? null : t.copy();
    }

    public boolean has(UUID id, String name) {
        Map<String, Tag> m = this.values.get(id);
        return m != null && m.containsKey(name);
    }

    public void put(UUID id, String name, Tag v) {
        this.values.computeIfAbsent(id, k -> new HashMap()).put(name, v.copy());
        this.setDirty();
    }

    public void putWithType(UUID id, String name, Tag v, EntitySerializerType type) {
        this.values.computeIfAbsent(id, k -> new HashMap()).put(name, v.copy());
        this.types.computeIfAbsent(id, k -> new HashMap()).put(name, type.ordinal());
        this.setDirty();
    }

    public Optional<EntitySerializerType> getType(UUID id, String name) {
        Integer i = (Integer)this.types.getOrDefault(id, Map.of()).get(name);
        return i == null ? Optional.empty() : Optional.of(EntitySerializerType.values()[i]);
    }

    public void remove(UUID id, String name) {
        Map<String, Integer> tm;
        Map<String, Tag> m = this.values.get(id);
        if (m != null) {
            m.remove(name);
        }
        if ((tm = this.types.get(id)) != null) {
            tm.remove(name);
        }
        this.setDirty();
    }
}

