/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.experiencelib.impl.capability;

import es.degrassi.experiencelib.api.capability.IContentsListener;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.experiencelib.api.capability.IExperienceTank;
import es.degrassi.experiencelib.impl.capability.BasicExperienceTank;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasicExperienceHandler
implements IExperienceHandler {
    private static final String TANKS_NBT = "tanks";
    private static final String TANKS_SIZE_NBT = "tank_size";
    private static final String DEFAULT_CAPACITY_NBT = "default_capacity";
    private final List<IExperienceTank> tanks;
    private long defaultCapacity;

    public BasicExperienceHandler(int tanksNumber, long capacity, @Nullable IContentsListener listener) {
        this.tanks = BasicExperienceHandler.createTanks(tanksNumber, capacity, listener);
        this.defaultCapacity = capacity;
    }

    private static List<IExperienceTank> createTanks(int tanksNumber, long capacity, @Nullable IContentsListener listener) {
        ArrayList<IExperienceTank> tanks = new ArrayList<IExperienceTank>();
        if (tanksNumber < 1) {
            throw new IllegalArgumentException("Experience Tanks can not be less than 1");
        }
        for (int i = 0; i < tanksNumber; ++i) {
            BasicExperienceTank tank = new BasicExperienceTank(capacity, listener);
            tanks.add(tank);
        }
        return tanks;
    }

    private void checkTankIndex(int tank) {
        if (tank < 0 || tank >= this.getTanks()) {
            throw new IllegalArgumentException("Tank index can not be less than 0 or greater than " + this.getTanks());
        }
    }

    @Override
    public int getTanks() {
        return this.tanks.size();
    }

    @Override
    public boolean canAcceptExperience(int tank, long amount) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).canAcceptExperience(amount);
    }

    @Override
    public boolean canProvideExperience(int tank, long amount) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).canProvideExperience(amount);
    }

    @Override
    public long getMaxExtract(int tank) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).getMaxExtract();
    }

    @Override
    public long getMaxReceive(int tank) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).getMaxReceive();
    }

    @Override
    public void setExperience(int tank, long amount) {
        this.checkTankIndex(tank);
        this.tanks.get(tank).setExperience(amount);
    }

    @Override
    public void setCapacity(int tank, long amount) {
        this.checkTankIndex(tank);
        this.tanks.get(tank).setCapacity(amount);
    }

    @Override
    public long receiveExperience(int tank, long amount, boolean simulate) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).receiveExperience(amount, simulate);
    }

    @Override
    public long extractExperience(int tank, long amount, boolean simulate) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).extractExperience(amount, simulate);
    }

    @Override
    public long receiveExperienceRecipe(int tank, long amount, boolean simulate) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).receiveExperienceRecipe(amount, simulate);
    }

    @Override
    public long extractExperienceRecipe(int tank, long amount, boolean simulate) {
        this.checkTankIndex(tank);
        return this.tanks.get(tank).extractExperienceRecipe(amount, simulate);
    }

    @Override
    public long getExperience() {
        return this.tanks.stream().mapToLong(IExperienceTank::getExperience).sum();
    }

    @Override
    public long getExperienceCapacity() {
        return this.tanks.stream().mapToLong(IExperienceTank::getExperienceCapacity).sum();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag tanksTag = new ListTag();
        this.tanks.forEach(tank -> tanksTag.add((Object)tank.serializeNBT(provider)));
        nbt.putInt(TANKS_SIZE_NBT, this.getTanks());
        nbt.put(TANKS_NBT, (Tag)tanksTag);
        nbt.putLong(DEFAULT_CAPACITY_NBT, this.defaultCapacity);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        int tankSize = nbt.getInt(TANKS_SIZE_NBT);
        ListTag tanksTag = nbt.getList(TANKS_NBT, 10);
        for (int i = 0; i < tankSize; ++i) {
            CompoundTag tankNbt = tanksTag.getCompound(i);
            this.tanks.get(i).deserializeNBT(provider, (Tag)tankNbt);
        }
        this.defaultCapacity = nbt.getLong(DEFAULT_CAPACITY_NBT);
    }
}

