/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TransparentButton
extends Button {
    public TransparentButton(int x, int y, int width, int height, Component label, Button.OnPress onPress) {
        super(x, y, width, height, label, onPress, DEFAULT_NARRATION);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            float state = 2.0f;
            if (!this.active) {
                state = 5.0f;
            } else if (this.isHovered) {
                state = 4.0f;
            }
            float f = state / 2.0f * 0.9f + 0.1f;
            int color = (int)(255.0f * f);
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), color / 2 << 24);
            this.drawBorder(guiGraphics, this.getX(), this.getY(), this.getWidth(), this.getHeight(), state);
            guiGraphics.drawCenteredString(mc.font, this.getMessage(), this.getX() + this.getWidth() / 2, this.getY() + (this.getHeight() - 8) / 2, 0xFFFFFF);
        }
    }

    private void drawBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, float state) {
        state = state == 2.0f ? 5.0f : 2.0f;
        guiGraphics.fill(x, y, x + width, y + 1, (int)(8.589935E8f * state));
        guiGraphics.fill(x, y + height - 1, x + width, y + height, (int)(8.589935E8f * state));
        guiGraphics.fill(x, y, x + 1, y + height, (int)(8.589935E8f * state));
        guiGraphics.fill(x + width - 1, y, x + width, y + height, (int)(8.589935E8f * state));
    }
}

