/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WriteFileAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String VALUE_SEPARATOR = "|||";

    public WriteFileAction() {
        super("write_file_in_game_dir");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            LOGGER.error("[FANCYMENU] WriteFileAction: No value provided!");
            return;
        }
        WriteFileConfig config = WriteFileConfig.parse(value);
        if (config == null) {
            LOGGER.error("[FANCYMENU] WriteFileAction: Failed to parse configuration!");
            return;
        }
        try {
            File targetFile;
            value = value.replace("\n", "\\n").replace("\r", "\\n");
            String filePath = DotMinecraftUtils.resolveMinecraftPath(config.targetPath);
            if (!DotMinecraftUtils.isInsideMinecraftDirectory(filePath)) {
                filePath = GameDirectoryUtils.getAbsoluteGameDirectoryPath(filePath);
            }
            if (!(targetFile = new File(filePath)).getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            String contentToWrite = config.content.replace("\\n", "\n");
            if (config.appendMode) {
                if (!targetFile.exists()) {
                    targetFile.createNewFile();
                }
                Files.write(targetFile.toPath(), contentToWrite.getBytes(), StandardOpenOption.APPEND);
            } else {
                try (FileWriter writer = new FileWriter(targetFile, false);){
                    writer.write(contentToWrite);
                }
            }
            LOGGER.info("[FANCYMENU] Successfully wrote to file: " + filePath);
        }
        catch (IOException ex) {
            LOGGER.error("[FANCYMENU] Failed to write file via WriteFileAction: " + config.targetPath, (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Unexpected error in WriteFileAction: " + value, (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public Component getActionDisplayName() {
        return Component.translatable((String)"fancymenu.actions.write_file");
    }

    @Override
    @NotNull
    public Component[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.write_file.desc", new String[0]);
    }

    @Override
    public Component getValueDisplayName() {
        return Component.empty();
    }

    @Override
    public String getValueExample() {
        return "/config/mymod/output.txt|||Hello World!\\nThis is a new line.|||false";
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull ActionInstance instance) {
        WriteFileActionValueScreen s = new WriteFileActionValueScreen(Objects.requireNonNullElse(instance.value, this.getValueExample()), value -> {
            if (value != null) {
                instance.value = value;
            }
            Minecraft.getInstance().setScreen(parentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    public static class WriteFileConfig {
        public String targetPath = "";
        public String content = "";
        public boolean appendMode = false;

        public String serialize() {
            return this.targetPath + WriteFileAction.VALUE_SEPARATOR + this.content + WriteFileAction.VALUE_SEPARATOR + this.appendMode;
        }

        @Nullable
        public static WriteFileConfig parse(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            WriteFileConfig config = new WriteFileConfig();
            String[] parts = value.split("\\|\\|\\|", -1);
            try {
                if (parts.length >= 1) {
                    config.targetPath = parts[0];
                }
                if (parts.length >= 2) {
                    config.content = parts[1];
                }
                if (parts.length >= 3) {
                    config.appendMode = Boolean.parseBoolean(parts[2]);
                }
                return config;
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to parse write file configuration!", (Throwable)ex);
                return null;
            }
        }
    }

    public static class WriteFileActionValueScreen
    extends CellScreen {
        protected WriteFileConfig config;
        protected Consumer<String> callback;

        protected WriteFileActionValueScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.translatable((String)"fancymenu.actions.write_file.edit_value"));
            this.callback = callback;
            this.config = WriteFileConfig.parse(value);
            if (this.config == null) {
                this.config = new WriteFileConfig();
            }
        }

        @Override
        protected void initCells() {
            this.addStartEndSpacerCell();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.actions.write_file.edit.target_path"));
            CellScreen.TextInputCell pathCell = this.addTextInputCell(null, true, true).setEditListener(s -> {
                this.config.targetPath = s;
            }).setText(this.config.targetPath);
            pathCell.editBox.setTooltip(Tooltip.create((Component)Component.translatable((String)"fancymenu.actions.write_file.edit.target_path.desc")));
            this.addCellGroupEndSpacerCell();
            this.addLabelCell((Component)Component.translatable((String)"fancymenu.actions.write_file.edit.content"));
            CellScreen.TextInputCell contentCell = this.addTextInputCell(null, true, true).setEditorMultiLineMode(true).setEditListener(s -> {
                this.config.content = s.replace("\n", "\\n");
            }).setText(this.config.content);
            contentCell.editBox.setTooltip(Tooltip.create((Component)Component.translatable((String)"fancymenu.actions.write_file.edit.content.desc")));
            this.addCellGroupEndSpacerCell();
            CycleButton<CommonCycles.CycleEnabledDisabled> appendModeButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, 20, 20, CommonCycles.cycleEnabledDisabled("fancymenu.actions.write_file.edit.mode", this.config.appendMode), (value, button) -> {
                this.config.appendMode = value.getAsBoolean();
            });
            appendModeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"fancymenu.actions.write_file.edit.mode.desc")));
            this.addWidgetCell((AbstractWidget)appendModeButton, true);
            this.addStartEndSpacerCell();
        }

        @Override
        public boolean allowDone() {
            return !this.config.targetPath.isEmpty();
        }

        @Override
        protected void onCancel() {
            this.callback.accept(null);
        }

        @Override
        protected void onDone() {
            this.callback.accept(this.config.serialize());
        }
    }
}

