/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.networking;

import de.keksuccino.fancymenu.networking.ClientPacketUtils;
import de.keksuccino.fancymenu.networking.Packet;
import de.keksuccino.fancymenu.networking.PacketCodec;
import de.keksuccino.fancymenu.networking.PacketRegistry;
import de.keksuccino.fancymenu.networking.packets.handshake.HandshakePacket;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    static final List<String> FANCYMENU_SERVERS = new ArrayList<String>();
    private static final List<String> FANCYMENU_CLIENTS = new ArrayList<String>();
    private static Consumer<String> sendToServerDataConsumer = null;
    private static BiConsumer<ServerPlayer, String> sendToClientPlayerAndDataConsumer = null;

    public static void addFancyMenuServer(@NotNull String serverIp) {
        Objects.requireNonNull(serverIp);
        if (FANCYMENU_SERVERS.contains(serverIp)) {
            return;
        }
        FANCYMENU_SERVERS.add(serverIp);
    }

    public static void addFancyMenuClient(@NotNull String playerUUID) {
        Objects.requireNonNull(playerUUID);
        if (FANCYMENU_CLIENTS.contains(playerUUID)) {
            return;
        }
        FANCYMENU_CLIENTS.add(playerUUID);
    }

    public static boolean isFancyMenuClient(@NotNull ServerPlayer player) {
        Objects.requireNonNull(player);
        return FANCYMENU_CLIENTS.contains(player.getUUID().toString());
    }

    public static void sendHandshakeToClient(@NotNull ServerPlayer player) {
        PacketHandler.sendToClient(player, new HandshakePacket());
    }

    public static void sendHandshakeToServer() {
        PacketHandler.sendToServer(new HandshakePacket());
    }

    public static <T extends Packet> void sendToServer(@NotNull T packet) {
        if (!ClientPacketUtils.shouldSendToServer(packet)) {
            return;
        }
        Objects.requireNonNull(sendToServerDataConsumer, "Tried to send packet to server too early! No logic set yet!");
        PacketCodec<T> codec = PacketRegistry.getCodecFor(Objects.requireNonNull(packet));
        if (codec != null) {
            try {
                sendToServerDataConsumer.accept(Objects.requireNonNull(codec.serialize(packet)));
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to send packet to server!", (Throwable)ex);
            }
        } else {
            LOGGER.error("[FANCYMENU] No codec found for packet: " + String.valueOf(packet.getClass()), (Throwable)new NullPointerException("Codec returned for packet was NULL!"));
        }
    }

    public static <T extends Packet> void sendToClient(@NotNull ServerPlayer toPlayer, @NotNull T packet) {
        if (!(packet instanceof HandshakePacket) && !FANCYMENU_CLIENTS.contains(toPlayer.getUUID().toString())) {
            return;
        }
        Objects.requireNonNull(sendToClientPlayerAndDataConsumer, "Tried to send packet to client too early! No logic set yet!");
        PacketCodec<T> codec = PacketRegistry.getCodecFor(Objects.requireNonNull(packet));
        if (codec != null) {
            try {
                sendToClientPlayerAndDataConsumer.accept(Objects.requireNonNull(toPlayer), Objects.requireNonNull(codec.serialize(packet)));
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to send packet to client!", (Throwable)ex);
            }
        } else {
            LOGGER.error("[FANCYMENU] No codec found for packet: " + String.valueOf(packet.getClass()), (Throwable)new NullPointerException("Codec returned for packet was NULL!"));
        }
    }

    public static <T extends Packet> void sendToAllFancyMenuClients(@NotNull MinecraftServer server, @NotNull T packet) {
        Objects.requireNonNull(server, "Server was NULL when broadcasting packet!");
        Objects.requireNonNull(packet, "Packet was NULL when broadcasting!");
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!PacketHandler.isFancyMenuClient(player)) continue;
            PacketHandler.sendToClient(player, packet);
        }
    }

    public static void setSendToServerLogic(Consumer<String> dataConsumer) {
        sendToServerDataConsumer = dataConsumer;
    }

    public static void setSendToClientLogic(BiConsumer<ServerPlayer, String> playerAndDataConsumer) {
        sendToClientPlayerAndDataConsumer = playerAndDataConsumer;
    }

    public static void onPacketReceived(@Nullable ServerPlayer sender, @NotNull PacketDirection direction, @NotNull String dataWithIdentifier) {
        if (!dataWithIdentifier.contains(":")) {
            return;
        }
        String[] dataSplit = dataWithIdentifier.split(":", 2);
        PacketCodec<?> codec = PacketRegistry.getCodec(dataSplit[0]);
        if (codec == null) {
            LOGGER.error("[FANCYMENU] No codec for packet data found with identifier: " + dataSplit[0], (Throwable)new NullPointerException("Codec returned for identifier was NULL!"));
            return;
        }
        if (direction == PacketDirection.TO_CLIENT) {
            Packet packet = PacketHandler.deserializePacket(() -> (Packet)Objects.requireNonNull(codec.deserialize(dataSplit[1])));
            if (packet != null) {
                MainThreadTaskExecutor.executeInMainThread(() -> {
                    try {
                        packet.processPacket(sender);
                    }
                    catch (Exception ex) {
                        LOGGER.error("[FANCYMENU] Failed to process packet on client!", (Throwable)ex);
                    }
                }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }
        } else if (direction == PacketDirection.TO_SERVER) {
            if (sender != null) {
                MinecraftServer server = sender.getServer();
                if (server != null) {
                    Packet packet = PacketHandler.deserializePacket(() -> (Packet)Objects.requireNonNull(codec.deserialize(dataSplit[1])));
                    if (packet != null) {
                        sender.getServer().execute(() -> {
                            try {
                                packet.processPacket(sender);
                            }
                            catch (Exception ex) {
                                LOGGER.error("[FANCYMENU] Failed to process packet on server!", (Throwable)ex);
                            }
                        });
                    }
                } else {
                    LOGGER.error("[FANCYMENU] Failed to process packet on server!", (Throwable)new NullPointerException("Server instance of sender was NULL!"));
                }
            } else {
                LOGGER.error("[FANCYMENU] Failed to process packet on server!", (Throwable)new NullPointerException("Sender was NULL!"));
            }
        }
    }

    @Nullable
    protected static Packet deserializePacket(@NotNull Supplier<Packet> packetSupplier) {
        try {
            return packetSupplier.get();
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize packet!", (Throwable)ex);
            return null;
        }
    }

    public static enum PacketDirection {
        TO_SERVER,
        TO_CLIENT;

    }
}

