/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.menu.MarketBasketSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketListingSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentSlot;
import net.blay09.mods.farmingforblockheads.menu.ModMenus;
import net.blay09.mods.farmingforblockheads.network.MarketPutInBasketMessage;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.recipe.ModRecipes;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketPresetRegistry;
import net.blay09.mods.farmingforblockheads.registry.PaymentImpl;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MarketMenu
extends AbstractContainerMenu {
    public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        buf.writeBlockPos(data.pos());
        buf.writeInt(data.presetFilters().size());
        for (ResourceLocation location : data.presetFilters()) {
            buf.writeResourceLocation(location);
        }
        buf.writeInt(data.categoryFilters().size());
        for (ResourceLocation location : data.categoryFilters()) {
            buf.writeResourceLocation(location);
        }
    }, buf -> {
        BlockPos pos = buf.readBlockPos();
        int presetFilterSize = buf.readInt();
        HashSet<ResourceLocation> presetFilters = new HashSet<ResourceLocation>();
        for (int i = 0; i < presetFilterSize; ++i) {
            presetFilters.add(buf.readResourceLocation());
        }
        int categoryFilterSize = buf.readInt();
        HashSet<ResourceLocation> categoryFilters = new HashSet<ResourceLocation>();
        for (int i = 0; i < categoryFilterSize; ++i) {
            categoryFilters.add(buf.readResourceLocation());
        }
        return new Data(pos, presetFilters, categoryFilters);
    });
    private final Player player;
    private final BlockPos pos;
    private final DefaultContainer marketInputBuffer = new DefaultContainer(1);
    private final DefaultContainer marketOutputBuffer = new DefaultContainer(1);
    private final List<MarketListingSlot> marketSlots = new ArrayList<MarketListingSlot>();
    private final MarketPaymentSlot paymentSlot;
    private final List<SimpleHolder<MarketCategory>> categories;
    private final List<RecipeHolder<MarketRecipe>> recipes;
    private String currentSearch;
    private SimpleHolder<MarketCategory> currentCategory;
    private final Comparator<RecipeHolder<MarketRecipe>> currentSorting = Comparator.comparingInt(recipe -> MarketCategoryRegistry.INSTANCE.get(((MarketRecipe)recipe.value()).getCategory()).map(MarketCategory::sortIndex).orElse(0)).thenComparing(recipe -> ((MarketRecipe)recipe.value()).getIcon().getDisplayName().getString());
    private boolean scrollOffsetDirty;
    private int scrollOffset;
    private final List<RecipeHolder<MarketRecipe>> filteredRecipes = new ArrayList<RecipeHolder<MarketRecipe>>();
    private RecipeHolder<MarketRecipe> selectedRecipe;

    public MarketMenu(int windowId, Inventory playerInventory, BlockPos pos, Set<ResourceLocation> alwaysIncludedPresets, Set<ResourceLocation> includeOnlyCategories) {
        super((MenuType)ModMenus.market.get(), windowId);
        int j;
        int i;
        this.player = playerInventory.player;
        this.pos = pos;
        this.recipes = this.player.level().getRecipeManager().getAllRecipesFor(ModRecipes.marketRecipeType).stream().filter(recipe -> MarketPresetRegistry.isRecipeEnabled((MarketRecipe)recipe.value(), alwaysIncludedPresets)).toList();
        this.categories = MarketCategoryRegistry.INSTANCE.getAll().entrySet().stream().filter(entry -> includeOnlyCategories.isEmpty() || includeOnlyCategories.contains(entry.getKey())).filter(entry -> this.recipes.stream().anyMatch(it -> ((MarketRecipe)it.value()).getCategory().equals(entry.getKey()))).sorted(Comparator.comparingInt(entry -> ((MarketCategory)entry.getValue()).sortIndex())).map(it -> new SimpleHolder<MarketCategory>((ResourceLocation)it.getKey(), (MarketCategory)it.getValue())).toList();
        this.paymentSlot = new MarketPaymentSlot((Container)this.marketInputBuffer, 0, 23, 39);
        this.addSlot(this.paymentSlot);
        this.addSlot(new MarketBasketSlot(this, (Container)this.marketOutputBuffer, 0, 61, 39));
        DefaultContainer fakeInventory = new DefaultContainer(12);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                MarketListingSlot slot = new MarketListingSlot((Container)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.marketSlots.add(slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 150));
        }
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (index == 1) {
                if (!this.isReadyToBuy()) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 14, 50, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (index == 0 ? !this.moveItemStackTo(slotStack, 14, 50, true) : (this.getExpectedPayment(this.selectedRecipe).ingredient().test(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, true) : (index >= 41 && index < 50 ? !this.moveItemStackTo(slotStack, 14, 41, true) : index >= 14 && index < 41 && !this.moveItemStackTo(slotStack, 41, 50, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public void removed(Player player) {
        ItemStack itemStack;
        super.removed(player);
        if (!(player.level().isClientSide || (itemStack = this.marketInputBuffer.removeItemNoUpdate(0)).isEmpty() || player.addItem(itemStack))) {
            player.drop(itemStack, false);
        }
    }

    public boolean stillValid(Player player) {
        return player.level().getBlockState(this.pos).getBlock() == ModBlocks.market && player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    public void slotsChanged(Container container) {
        if (this.selectedRecipe != null) {
            this.marketOutputBuffer.setItem(0, ((MarketRecipe)this.selectedRecipe.value()).assemble((RecipeInput)new TransientCraftingContainer((AbstractContainerMenu)this, 0, 0).asCraftInput(), (HolderLookup.Provider)RegistryAccess.EMPTY));
        } else {
            this.marketOutputBuffer.setItem(0, ItemStack.EMPTY);
        }
    }

    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.container != this.marketOutputBuffer && super.canTakeItemForPickAll(itemStack, slot);
    }

    private Payment getExpectedPayment(@Nullable RecipeHolder<MarketRecipe> recipe) {
        if (recipe == null) {
            return new PaymentImpl(Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}), 1, Optional.empty());
        }
        return ((MarketRecipe)recipe.value()).getPaymentOrDefault();
    }

    public void selectMarketEntry(ResourceLocation recipeId, boolean stack) {
        this.selectedRecipe = this.recipes.stream().filter(it -> it.id().equals((Object)recipeId)).findFirst().orElse(null);
        if (this.selectedRecipe != null) {
            Payment payment = ((MarketRecipe)this.selectedRecipe.value()).getPaymentOrDefault();
            ItemStack currentInput = this.marketInputBuffer.getItem(0);
            if (!payment.ingredient().test(currentInput)) {
                this.quickMoveStack(this.player, 0);
                this.quickMoveCost(payment, stack ? 64 : 1);
            } else if (stack && currentInput.getCount() < 64) {
                this.quickMoveCost(payment, 64);
            } else if (!stack && currentInput.getCount() > 1) {
                this.quickMoveStack(this.player, 0);
                this.quickMoveCost(payment, 1);
            }
        }
        this.slotsChanged((Container)this.marketInputBuffer);
    }

    private void quickMoveCost(Payment payment, int desiredCount) {
        this.paymentSlot.setMaxStackSizeOverride(desiredCount);
        for (int i = 14; i < this.slots.size(); ++i) {
            ItemStack slotStack = ((Slot)this.slots.get(i)).getItem();
            if (payment.ingredient().test(slotStack)) {
                this.quickMoveStack(this.player, i);
            }
            if (this.paymentSlot.getItem().getCount() >= desiredCount) break;
        }
        this.paymentSlot.resetMaxStackSizeOverride();
    }

    @Nullable
    public RecipeHolder<MarketRecipe> getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public boolean isReadyToBuy() {
        if (this.selectedRecipe == null) {
            return false;
        }
        Payment expectedPayment = this.getExpectedPayment(this.selectedRecipe);
        ItemStack currentInput = this.marketInputBuffer.getItem(0);
        return !currentInput.isEmpty() && expectedPayment.ingredient().test(currentInput) && currentInput.getCount() >= expectedPayment.count();
    }

    public void onItemBought() {
        if (this.selectedRecipe != null) {
            this.marketInputBuffer.removeItem(0, ((MarketRecipe)this.selectedRecipe.value()).getPaymentOrDefault().count());
            this.slotsChanged((Container)this.marketInputBuffer);
        }
    }

    public void clicked(int slotNumber, int dragType, ClickType clickType, Player player) {
        if (slotNumber >= 0 && slotNumber < this.slots.size()) {
            MarketListingSlot marketSlot;
            RecipeHolder<MarketRecipe> recipe;
            Slot slot = (Slot)this.slots.get(slotNumber);
            if (player.level().isClientSide && slot instanceof MarketListingSlot && (recipe = (marketSlot = (MarketListingSlot)slot).getRecipe()) != null) {
                this.selectedRecipe = recipe;
                Balm.getNetworking().sendToServer((CustomPacketPayload)new MarketPutInBasketMessage(recipe.id(), clickType == ClickType.QUICK_MOVE));
            }
        }
        super.clicked(slotNumber, dragType, clickType, player);
    }

    public void setSearch(@Nullable String term) {
        this.currentSearch = term;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    public void setCategory(@Nullable SimpleHolder<MarketCategory> category) {
        this.currentCategory = category;
        this.updateFilteredRecipes();
        this.setScrollOffset(0);
    }

    private void updateFilteredRecipes() {
        this.filteredRecipes.clear();
        for (RecipeHolder<MarketRecipe> recipe : this.recipes) {
            if (!this.searchMatches(recipe) || !this.categoryMatches(recipe)) continue;
            this.filteredRecipes.add(recipe);
        }
        this.filteredRecipes.sort(this.currentSorting);
    }

    private boolean searchMatches(RecipeHolder<MarketRecipe> recipeHolder) {
        if (this.currentSearch == null || this.currentSearch.trim().isEmpty()) {
            return true;
        }
        MarketRecipe recipe = (MarketRecipe)recipeHolder.value();
        ItemStack itemStack = recipe.getIcon();
        String lowerCaseSearch = this.currentSearch.toLowerCase();
        if (itemStack.getDisplayName().getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) {
            return true;
        }
        List tooltips = itemStack.getTooltipLines(Item.TooltipContext.EMPTY, this.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
        for (Component tooltip : tooltips) {
            if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(lowerCaseSearch)) continue;
            return true;
        }
        return false;
    }

    private boolean categoryMatches(RecipeHolder<MarketRecipe> recipeHolder) {
        if (this.currentCategory == null) {
            return true;
        }
        MarketRecipe recipe = (MarketRecipe)recipeHolder.value();
        return recipe.getCategory().equals((Object)this.currentCategory.id());
    }

    public int getFilteredListCount() {
        return this.filteredRecipes.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateListingSlots();
    }

    public void updateListingSlots() {
        int i = this.scrollOffset * 3;
        for (MarketListingSlot slot : this.marketSlots) {
            if (i < this.filteredRecipes.size()) {
                slot.setRecipe(this.filteredRecipes.get(i));
                ++i;
                continue;
            }
            slot.setRecipe(null);
        }
    }

    public boolean isScrollOffsetDirty() {
        return this.scrollOffsetDirty;
    }

    public void setScrollOffsetDirty(boolean scrollOffsetDirty) {
        this.scrollOffsetDirty = scrollOffsetDirty;
    }

    public Optional<SimpleHolder<MarketCategory>> getCurrentCategory() {
        return Optional.ofNullable(this.currentCategory);
    }

    public List<SimpleHolder<MarketCategory>> getCategories() {
        return this.categories;
    }

    public record Data(BlockPos pos, Set<ResourceLocation> presetFilters, Set<ResourceLocation> categoryFilters) {
    }
}

