/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.chesed_attack_ray;

import com.finderfeed.fdbosses.client.particles.arc_lightning.ArcLightningParticle;
import com.finderfeed.fdbosses.client.particles.chesed_attack_ray.ChesedRayOptions;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ChesedAttackRayParticle
extends Particle {
    public Vec3 rayEnd;
    private ChesedRayOptions options;
    private ComplexEasingFunction easingFunction;

    public ChesedAttackRayParticle(ChesedRayOptions rayOptions, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.options = rayOptions;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.rayEnd = rayOptions.rayEnd;
        this.setBoundingBox(new AABB(x, y, z, this.rayEnd.x, this.rayEnd.y, this.rayEnd.z));
        this.lifetime = this.options.rayOptions.inTime + this.options.rayOptions.stayTime + this.options.rayOptions.outTime;
        this.easingFunction = ComplexEasingFunction.builder().addArea((float)this.options.rayOptions.inTime, FDEasings::easeIn).addArea((float)this.options.rayOptions.stayTime, FDEasings::one).addArea((float)this.options.rayOptions.outTime, FDEasings::reversedEaseOut).build();
        this.options.particleProcessor.init((Particle)this);
    }

    public void tick() {
        this.options.particleProcessor.processParticle((Particle)this);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.x += this.xd;
            this.y += this.yd;
            this.z += this.zd;
        }
        this.setBoundingBox(new AABB(this.x, this.y, this.z, this.rayEnd.x, this.rayEnd.y, this.rayEnd.z));
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 pos = new Vec3(Mth.lerp((double)pticks, (double)this.xo, (double)this.x), Mth.lerp((double)pticks, (double)this.yo, (double)this.y), Mth.lerp((double)pticks, (double)this.zo, (double)this.z));
        Vec3 b = this.rayEnd.subtract(pos.x, pos.y, pos.z);
        pos = pos.subtract(camera.getPosition());
        double len = b.length();
        Matrix4f mat = new Matrix4f();
        mat.translate((float)pos.x, (float)pos.y, (float)pos.z);
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mat, (Vec3)b);
        Vec3 n = FDMathUtil.getNormalVectorFromLineToPoint((Vec3)pos, (Vec3)b.add(pos), (Vec3)Vec3.ZERO);
        Matrix4f mt2 = new Matrix4f();
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mt2, (Vec3)b);
        Vector4f up = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
        mt2.transform(up);
        Vector4f left = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
        mt2.transform(left);
        Vec3 vup = new Vec3((double)(up.x / up.w), (double)(up.y / up.w), (double)(up.z / up.w));
        Vec3 vleft = new Vec3((double)left.x, (double)left.y, (double)left.z);
        float angle = (float)FDMathUtil.angleBetweenVectors((Vec3)n, (Vec3)vup);
        if (vleft.dot(n) > 0.0) {
            mat.rotateY(angle);
        } else {
            mat.rotateY(-angle);
        }
        float p = this.easingFunction.apply((float)this.age);
        float alpha = p * this.options.color.a;
        float w = this.options.rayWidth * p;
        vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
        vertex.addVertex(mat, w, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
        vertex.addVertex(mat, w, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
        vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
        vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
        vertex.addVertex(mat, -w, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
        vertex.addVertex(mat, -w, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
        vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
        mat.translate(0.0f, 0.0f, 0.01f);
        vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        vertex.addVertex(mat, w * 0.15f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, w * 0.15f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        vertex.addVertex(mat, -w * 0.15f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, -w * 0.15f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        List<Vec3> positions = List.of(Vec3.ZERO, new Vec3(0.0, len, 0.0));
        List<Vec3> path = ArcLightningParticle.buildPath(this.level.getGameTime(), w * 2.0f, 342332, Math.max((int)Math.round(len / (double)(2.0f * w * 2.0f)), 2), positions);
        mat.translate(0.0f, 0.0f, 0.02f);
        ArcLightningParticle.drawLightning(mat, vertex, path, positions, w * 0.5f, this.options.lightningColor.r, this.options.lightningColor.g, this.options.lightningColor.b, alpha);
        mat.translate(0.0f, 0.0f, 0.02f);
        ArcLightningParticle.drawLightning(mat, vertex, path, positions, w * 0.5f * 0.15f, 1.0f, 1.0f, 1.0f, alpha);
        mat.translate(0.0f, 0.0f, -0.06f);
        ArcLightningParticle.drawLightning(mat, vertex, path, positions, w * 0.5f * 0.15f, 1.0f, 1.0f, 1.0f, alpha);
    }

    public ParticleRenderType getRenderType() {
        return ArcLightningParticle.RENDER_TYPE;
    }

    public static class Factory
    implements ParticleProvider<ChesedRayOptions> {
        @Nullable
        public Particle createParticle(ChesedRayOptions type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ChesedAttackRayParticle(type, level, x, y, z, xd, yd, zd);
        }
    }
}

