/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.colored_jumping_particles;

import com.finderfeed.fdbosses.client.particles.colored_jumping_particles.ColoredJumpingParticleOptions;
import com.finderfeed.fdlib.systems.particle.FDParticleRenderType;
import com.finderfeed.fdlib.systems.trails.FDTrailDataGenerator;
import com.finderfeed.fdlib.systems.trails.FDTrailRenderer;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public class ColoredJumpingParticle
extends Particle {
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);
    private boolean stoppedByCollision;
    public ColoredJumpingParticleOptions options;
    private FDTrailDataGenerator<ColoredJumpingParticle> trail;
    public int ignoreCollisionTicks = 0;
    public boolean disappearWhenSpeedIsLow = false;
    private int currentJumpAmount = 0;
    public static final ParticleRenderType RENDER_TYPE = new FDParticleRenderType(){

        public void end() {
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.disableBlend();
        }

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        }
    };

    public ColoredJumpingParticle(ColoredJumpingParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.options = options;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.rCol = options.colorStart.r;
        this.gCol = options.colorStart.g;
        this.bCol = options.colorStart.b;
        this.alpha = options.colorStart.a;
        this.gravity = options.gravity;
        this.disappearWhenSpeedIsLow = options.lifetime == -1;
        this.lifetime = options.lifetime;
        if (this.lifetime == -1) {
            this.lifetime = Integer.MAX_VALUE;
        }
        this.trail = new FDTrailDataGenerator((coloredJumpingParticle, aFloat) -> FDMathUtil.interpolateVectors((Vec3)new Vec3(coloredJumpingParticle.xo, coloredJumpingParticle.yo, coloredJumpingParticle.zo), (Vec3)new Vec3(coloredJumpingParticle.x, coloredJumpingParticle.y, coloredJumpingParticle.z), (float)aFloat.floatValue()), options.maxPointsInTrail, 0.1f);
        this.friction = 1.0f;
        this.setSize(0.05f, 0.05f);
    }

    public void tick() {
        if (this.disappearWhenSpeedIsLow && this.onGround && this.currentJumpAmount >= this.options.maxJumpAmount && this.trail.getPoints().size() <= 1) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.speedUpWhenYMotionIsBlocked && this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
        this.ignoreCollisionTicks = Mth.clamp((int)(this.ignoreCollisionTicks - 1), (int)0, (int)Integer.MAX_VALUE);
        this.trail.tick((Object)this);
    }

    public void move(double xd, double yd, double zd) {
        if (!this.stoppedByCollision) {
            double d1 = yd;
            if (this.hasPhysics && (xd != 0.0 || yd != 0.0 || zd != 0.0) && xd * xd + yd * yd + zd * zd < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
                Vec3 vec3 = this.handleCollision(xd, yd, zd);
                xd = vec3.x;
                yd = vec3.y;
                zd = vec3.z;
            }
            if (xd != 0.0 || yd != 0.0 || zd != 0.0) {
                this.setBoundingBox(this.getBoundingBox().move(xd, yd, zd));
                this.setLocationFromBoundingbox();
            }
            if (Math.abs(d1) >= (double)1.0E-5f && Math.abs(yd) < (double)1.0E-5f) {
                this.stoppedByCollision = true;
            }
            this.onGround = d1 != yd && d1 < 0.0;
        }
    }

    private Vec3 handleCollision(double xd, double yd, double zd) {
        if (this.ignoreCollisionTicks > 0) {
            return new Vec3(xd, yd, zd);
        }
        Vec3 oldShift = new Vec3(xd, yd, zd);
        Vec3 newShift = Entity.collideBoundingBox(null, (Vec3)oldShift, (AABB)this.getBoundingBox(), (Level)this.level, List.of());
        if (!oldShift.equals((Object)newShift) && this.currentJumpAmount < this.options.maxJumpAmount) {
            float zMod;
            Vec3 thisPos = this.getPos();
            Vec3 endPos = thisPos.add(xd * 2.0, yd * 2.0, zd * 2.0);
            ClipContext clipContext = new ClipContext(thisPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
            BlockHitResult result = this.level.clip(clipContext);
            Direction direction = result.getDirection();
            Vector3d shift = new Vector3d(xd, yd, zd).reflect((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ());
            float xMod = direction.getStepX() == 0 ? 1.0f : this.options.reflectionStrength;
            float yMod = direction.getStepY() == 0 ? 1.0f : this.options.reflectionStrength;
            float f = zMod = direction.getStepZ() == 0 ? 1.0f : this.options.reflectionStrength;
            if (Direction.Plane.HORIZONTAL.test(direction)) {
                this.ignoreCollisionTicks = 0;
                if (shift.y > 0.0) {
                    shift.y = -shift.y;
                }
            }
            this.xd = shift.x * (double)xMod;
            this.yd = shift.y * (double)yMod;
            this.zd = shift.z * (double)zMod;
            ++this.currentJumpAmount;
            return new Vec3(shift.x * (double)xMod, shift.y * (double)yMod, shift.z * (double)zMod);
        }
        return newShift;
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 pos = FDMathUtil.interpolateVectors((Vec3)new Vec3(this.xo, this.yo, this.zo), (Vec3)new Vec3(this.x, this.y, this.z), (float)pticks);
        Vec3 camPos = camera.getPosition();
        Vec3 translatePosition = pos.subtract(camPos);
        Matrix4f mat = new Matrix4f();
        mat.translate((float)translatePosition.x, (float)translatePosition.y, (float)translatePosition.z);
        mat.rotate((Quaternionfc)camera.rotation());
        float radius = this.options.size;
        FDColor color = this.options.colorStart;
        vertex.addVertex(mat, radius, radius, 0.0f).setColor(color.r, color.g, color.b, color.a);
        vertex.addVertex(mat, -radius, radius, 0.0f).setColor(color.r, color.g, color.b, color.a);
        vertex.addVertex(mat, -radius, -radius, 0.0f).setColor(color.r, color.g, color.b, color.a);
        vertex.addVertex(mat, radius, -radius, 0.0f).setColor(color.r, color.g, color.b, color.a);
        Trails.TO_RENDER_TRAILS_ON.add(this);
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="fdbosses")
    public static class Trails {
        public static List<ColoredJumpingParticle> TO_RENDER_TRAILS_ON = new ArrayList<ColoredJumpingParticle>();

        @SubscribeEvent
        public static void renderTrails(RenderLevelStageEvent event) {
            RenderLevelStageEvent.Stage stage = event.getStage();
            if (stage != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                return;
            }
            if (TO_RENDER_TRAILS_ON.isEmpty()) {
                return;
            }
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            PoseStack matrices = event.getPoseStack();
            for (ColoredJumpingParticle particle : TO_RENDER_TRAILS_ON) {
                matrices.pushPose();
                Vec3 pos = FDMathUtil.interpolateVectors((Vec3)new Vec3(particle.xo, particle.yo, particle.zo), (Vec3)new Vec3(particle.x, particle.y, particle.z), (float)event.getPartialTick().getGameTimeDeltaPartialTick(false)).subtract(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
                matrices.translate(pos.x, pos.y, pos.z);
                FDTrailRenderer.renderTrail((Object)((Object)particle), particle.trail, (VertexConsumer)builder, (PoseStack)matrices, (float)particle.options.size, (int)4, (int)30, (float)event.getPartialTick().getGameTimeDeltaPartialTick(false), (FDColor)particle.options.colorEnd, (FDColor)particle.options.colorStart);
                matrices.popPose();
            }
            MeshData meshData = builder.build();
            if (meshData != null) {
                BufferUploader.drawWithShader((MeshData)meshData);
            }
            TO_RENDER_TRAILS_ON.clear();
        }
    }

    public static class Factory
    implements ParticleProvider<ColoredJumpingParticleOptions> {
        public Particle createParticle(ColoredJumpingParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            ColoredJumpingParticle particle = new ColoredJumpingParticle(options, level, x, y, z, xd, yd, zd);
            return particle;
        }
    }
}

