/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.sonic_particle;

import com.finderfeed.fdbosses.client.particles.sonic_particle.SonicParticleOptions;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SonicParticle
extends TextureSheetParticle {
    private SonicParticleOptions options;
    private float currentResizeSpeed;
    private ComplexEasingFunction alphaEasingFunction;
    private float currentQuadSize;
    private float oldQuadSize;
    private Quaternionf facing;

    public SonicParticle(SonicParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        Quaternionf q;
        this.options = options;
        this.lifetime = options.lifetime;
        this.currentResizeSpeed = options.resizeSpeed;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize = options.startSize;
        this.rCol = options.color.r;
        this.gCol = options.color.g;
        this.bCol = options.color.b;
        double finalResize = options.endSize - options.startSize;
        if (options.resizeAcceleration != 0.0f) {
            double d = (double)(options.resizeSpeed * options.resizeSpeed) + (double)(2.0f * options.resizeAcceleration) * finalResize;
            double t1 = ((double)(-options.resizeSpeed) + Math.sqrt(d)) / (double)options.resizeAcceleration;
            double t2 = ((double)(-options.resizeSpeed) - Math.sqrt(d)) / (double)options.resizeAcceleration;
            this.lifetime = (int)Math.ceil(Math.max(Math.abs(t2), Math.abs(t1)));
        } else {
            double t = finalResize / (double)options.resizeSpeed;
            this.lifetime = (int)Math.ceil(Math.abs(t));
        }
        double l = options.facingDirection.x * options.facingDirection.x + options.facingDirection.z * options.facingDirection.z;
        l = Math.sqrt(l);
        float angle1 = (float)Math.atan2(options.facingDirection.z, options.facingDirection.x);
        float angle2 = (float)Math.atan2(options.facingDirection.y, l);
        this.facing = q = new Quaternionf(new AxisAngle4f(angle1, 0.0f, 1.0f, 0.0f)).rotateX(-angle2);
        if (!options.alphaOptions.isEmpty()) {
            this.alphaEasingFunction = ComplexEasingFunction.builder().addArea((float)options.alphaOptions.inTime, FDEasings::linear).addArea((float)options.alphaOptions.stayTime, f -> Float.valueOf(1.0f)).addArea((float)options.alphaOptions.outTime, FDEasings::reversedLinear).build();
            this.alpha = 0.0f;
        } else {
            this.alpha = options.alphaOptions.maxAlpha;
        }
        this.hasPhysics = false;
        this.friction = 0.0f;
        this.currentQuadSize = this.quadSize;
        this.oldQuadSize = this.quadSize;
    }

    public void render(VertexConsumer p_107678_, Camera p_107679_, float p_107680_) {
        float q;
        float pticks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().isPaused());
        this.quadSize = q = FDMathUtil.lerp((float)this.oldQuadSize, (float)this.currentQuadSize, (float)pticks);
        super.render(p_107678_, p_107679_, p_107680_);
    }

    public void tick() {
        super.tick();
        if (this.alphaEasingFunction != null) {
            this.alpha = this.alphaEasingFunction.apply((float)this.age) * this.options.alphaOptions.maxAlpha;
        }
        float max = Math.max(this.options.startSize, this.options.endSize);
        float min = Math.min(this.options.startSize, this.options.endSize);
        this.oldQuadSize = this.currentQuadSize;
        this.currentQuadSize = Mth.clamp((float)(this.currentQuadSize + this.currentResizeSpeed), (float)min, (float)max);
        this.currentResizeSpeed += this.options.resizeAcceleration;
    }

    protected int getLightColor(float p_107249_) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public SingleQuadParticle.FacingCameraMode getFacingCameraMode() {
        return (quaternion, camera, pticks) -> quaternion.set((Quaternionfc)this.facing);
    }

    public static class Factory
    implements ParticleProvider<SonicParticleOptions> {
        private SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SonicParticleOptions particle, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            SonicParticle p = new SonicParticle(particle, level, x, y, z, xd, yd, zd);
            p.pickSprite(this.spriteSet);
            return p;
        }
    }
}

