/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerContextAssignable;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedEntity;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.client.particles.lightning_particle.LightningParticleOptions;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ChesedBossSpawner
extends BossSpawnerEntity {
    public ChesedBossSpawner(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos pos = this.getOnPos().above();
            if (this.isActive()) {
                BlockState state = this.level().getBlockState(pos);
                if (state.isAir() && !state.is(Blocks.LIGHT)) {
                    this.level().setBlock(pos, (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15)), 3);
                }
            } else if (this.level().getBlockState(pos).getBlock() == Blocks.LIGHT) {
                this.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        } else if (this.level().isClientSide && this.isActive()) {
            Vec3 add = new Vec3(0.5 + 0.5 * (double)this.random.nextFloat(), 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat()).add(0.0, 0.75, 0.0);
            float lightningAdditiveLength = 1.0f - this.random.nextFloat();
            Vec3 add2 = new Vec3(0.75 + (double)(lightningAdditiveLength * lightningAdditiveLength * 0.25f), 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat()).add(0.0, 0.75 + (double)this.random.nextFloat() * 0.25 - 0.125 + (double)(lightningAdditiveLength * 0.5f), 0.0);
            Vec3 rnd = this.position().add(add);
            Vec3 rnd2 = this.position().add(add2);
            double l = add.multiply(1.0, 0.0, 1.0).length() * 1.5;
            l *= l;
            this.level().addParticle((ParticleOptions)BallParticleOptions.builder().size(0.15f).color(100 + this.random.nextInt(50), 255, 255).scalingOptions(10, 0, 30).build(), true, rnd.x, rnd.y, rnd.z, 0.0, (double)(0.025f + this.random.nextFloat() * 0.025f) / Math.max(1.0, l), 0.0);
            if (this.level().getGameTime() % 10L == 0L) {
                this.level().addParticle((ParticleOptions)LightningParticleOptions.builder().color(60, 200 + this.random.nextInt(50), 255).lifetime(10).maxLightningSegments(3).randomRoll(true).build(), true, rnd2.x, rnd2.y, rnd2.z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public EntityType<? extends BossSpawnerContextAssignable> getBossEntityType() {
        return BossEntities.CHESED.get();
    }

    @Override
    public Vec3 getPlayerItemsDropPosition(ServerPlayer serverPlayer, Vec3 deathPosition) {
        if (BossTargetFinder.isPointInCylinder(deathPosition, this.position().add(0.0, -2.0, 0.0), ChesedEntity.ARENA_HEIGHT, ChesedEntity.ARENA_RADIUS)) {
            Vec3 offset = this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply((double)(ChesedEntity.ARENA_RADIUS + 4), 0.0, (double)(ChesedEntity.ARENA_RADIUS + 4)).add(0.0, 1.0, 0.0);
            return this.position().add(offset);
        }
        return null;
    }

    @Override
    public void setActive(boolean state) {
        super.setActive(state);
    }

    @Override
    public boolean canInteractWithBlockPos(BlockPos blockPos) {
        Vec3 v = blockPos.getCenter();
        Vec3 pos = this.position();
        double yDiff = v.y - pos.y;
        double hdist = v.multiply(1.0, 0.0, 1.0).distanceTo(pos.multiply(1.0, 0.0, 1.0));
        return !(hdist < (double)ChesedEntity.ARENA_RADIUS) || !(yDiff > -2.0) || !(yDiff < (double)ChesedEntity.ARENA_HEIGHT);
    }

    @Override
    public Component onArenaDestructionMessage() {
        return Component.translatable((String)"fdbosses.word.tried_to_break_arena").withStyle(ChatFormatting.RED);
    }
}

