/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_one_shot_vertical_ray;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.particles.chesed_attack_ray.ChesedRayOptions;
import com.finderfeed.fdbosses.content.entities.chesed_boss.ChesedBossBuddy;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.particle.CircleParticleProcessor;
import com.finderfeed.fdlib.systems.particle.ParticleProcessor;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChesedOneShotVerticalRayEntity
extends Entity
implements AutoSerializable {
    public static final EntityDataAccessor<Integer> ATTACK_PREPARATION_TIME = SynchedEntityData.defineId(ChesedOneShotVerticalRayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(ChesedOneShotVerticalRayEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @SerializableField
    private float damage;
    @SerializableField
    private float damageRadius = 2.5f;
    public boolean softerSound = false;

    public ChesedOneShotVerticalRayEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public static ChesedOneShotVerticalRayEntity summon(Level level, Vec3 pos, float damage, float height, int attackPrepTime) {
        ChesedOneShotVerticalRayEntity entity = new ChesedOneShotVerticalRayEntity(BossEntities.CHESED_ONE_SHOT_VERTICAL_RAY_ATTACK.get(), level);
        entity.setDamage(damage);
        entity.setHeight(height);
        entity.setPos(pos);
        entity.setAttackPreparationTime(attackPrepTime);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount == this.getAttackPreparationTime()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), BossSounds.FAST_LIGHTNING_STRIKE.get(), SoundSource.HOSTILE, this.softerSound ? 0.25f : 1.0f, 1.0f);
                this.rayParticleAndShake();
                this.doDamage();
                this.remove(Entity.RemovalReason.DISCARDED);
            } else if (this.tickCount > this.getAttackPreparationTime()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            int attackPreparationTime = this.getAttackPreparationTime();
            if ((float)this.tickCount < (float)attackPreparationTime / 2.0f) {
                this.prepareParticles(attackPreparationTime / 2);
            } else if (this.tickCount == attackPreparationTime - 1) {
                this.boomParticles(this.position());
            }
        }
    }

    private void boomParticles(Vec3 pos) {
        for (int i = 0; i < 50; ++i) {
            BallParticleOptions options = BallParticleOptions.builder().color(0.3f, 1.0f, 1.0f, 1.0f).scalingOptions(0, 10, 20 + this.random.nextInt(3)).physics(false).size(0.5f).friction(0.9f).build();
            Vec3 speed = new Vec3((double)(0.6f * this.random.nextFloat()), 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f).add(0.0, (double)(this.random.nextFloat() * 0.3f), 0.0);
            this.level().addParticle((ParticleOptions)options, true, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
        float sp = 2.0f;
        for (int c = 0; c < 4; ++c) {
            int i = 0;
            while ((float)i < this.getHeight()) {
                Vec3 spawn = this.position().add(0.0, (double)((float)i + this.random.nextFloat()) - 0.5, 0.0);
                Vec3 speed = new Vec3((double)sp * ((double)this.random.nextFloat() * 0.5 + 0.5), 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
                BallParticleOptions options = BallParticleOptions.builder().size(0.5f).color(0.3f, 1.0f, 1.0f, 1.0f).physics(false).friction(0.4f).scalingOptions(0, 0, 10 + this.random.nextInt(4)).build();
                this.level().addParticle((ParticleOptions)options, true, spawn.x, spawn.y, spawn.z, speed.x, speed.y, speed.z);
                ++i;
            }
        }
    }

    private void prepareParticles(int lifetime) {
        float p = (float)this.tickCount / (float)lifetime;
        for (int c = 0; c < 2; ++c) {
            int i = 0;
            while ((float)i < this.getHeight()) {
                Vec3 center = this.position().add(0.0, (double)((float)i + this.random.nextFloat()) - 0.5, 0.0);
                Vec3 spawnOffset = new Vec3(2.0, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
                Vec3 spawn = center.add(spawnOffset);
                BallParticleOptions options = BallParticleOptions.builder().particleProcessor((ParticleProcessor)new CircleParticleProcessor(center, true, true, 1.0f)).size(0.5f * Math.max(0.05f, p)).color(0.3f, 1.0f, 1.0f, 1.0f).physics(false).scalingOptions(lifetime, 0, 0).build();
                this.level().addParticle((ParticleOptions)options, true, spawn.x, spawn.y, spawn.z, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    private void rayParticleAndShake() {
        Vec3 p = this.position();
        Vec3 end = p.add(0.0, (double)this.getHeight(), 0.0);
        ChesedRayOptions options = ChesedRayOptions.builder().time(0, 7, 5).lightningColor(90, 180, 255).color(100, 255, 255).end(end).width(0.5f).build();
        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)options, (Vec3)p, (double)60.0);
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(5.0f).amplitude(5.0f).inTime(0).stayTime(0).outTime(5).build(), (Vec3)p, (double)10.0);
        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)BallParticleOptions.builder().size(20.0f).scalingOptions(1, 0, 3).color(150, 230, 255).build(), (Vec3)p, (double)60.0);
    }

    private void doDamage() {
        AABB box = new AABB((double)(-this.damageRadius), 0.0, (double)(-this.damageRadius), (double)this.damageRadius, (double)this.getHeight(), (double)this.damageRadius).move(this.position());
        List list = this.level().getEntitiesOfClass(LivingEntity.class, box, BossUtil.entityInVerticalRadiusPredicate(this.position(), this.damageRadius));
        for (LivingEntity entity : list) {
            if (entity instanceof ChesedBossBuddy) continue;
            entity.hurt(BossDamageSources.CHESED_VERTICAL_RAY_SOURCE, this.getDamage());
        }
    }

    public float getDamageRadius() {
        return this.damageRadius;
    }

    public void setDamageRadius(float damageRadius) {
        this.damageRadius = damageRadius;
    }

    public float getHeight() {
        return ((Float)this.entityData.get(HEIGHT)).floatValue();
    }

    public float getDamage() {
        return this.damage;
    }

    public void setHeight(float height) {
        this.entityData.set(HEIGHT, (Object)Float.valueOf(height));
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setAttackPreparationTime(int attackPreparationTime) {
        this.entityData.set(ATTACK_PREPARATION_TIME, (Object)attackPreparationTime);
    }

    public int getAttackPreparationTime() {
        return (Integer)this.entityData.get(ATTACK_PREPARATION_TIME);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ATTACK_PREPARATION_TIME, (Object)20);
        builder.define(HEIGHT, (Object)Float.valueOf(40.0f));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.autoLoad(tag);
        this.setAttackPreparationTime(tag.getInt("prepareTime"));
        this.setHeight(tag.getFloat("height"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.autoSave(tag);
        tag.putInt("prepareTime", this.getAttackPreparationTime());
        tag.putFloat("height", this.getHeight());
    }
}

