/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity;

import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterEntitySpawnPacket;
import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterSettings;
import com.finderfeed.fdbosses.init.BossEntities;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EarthShatterEntity
extends Entity {
    public static final EntityDataAccessor<BlockState> STATE = SynchedEntityData.defineId(EarthShatterEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    public EarthShatterSettings settings;

    public EarthShatterEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public static EarthShatterEntity summon(Level level, BlockPos pos, EarthShatterSettings settings) {
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return null;
        }
        if (!level.getEntitiesOfClass(EarthShatterEntity.class, new AABB((double)pos.getX() + 0.1, (double)pos.getY(), (double)pos.getZ() + 0.1, (double)pos.getX() + 0.9, (double)pos.getY() + 0.9, (double)pos.getZ() + 0.9)).isEmpty()) {
            return null;
        }
        EarthShatterEntity entity = new EarthShatterEntity(BossEntities.EARTH_SHATTER.get(), level);
        entity.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        entity.settings = settings;
        entity.setBlockState(state);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public void tick() {
        super.tick();
        if (this.tickCount > this.settings.getLifetime()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(STATE);
    }

    public void setBlockState(BlockState state) {
        this.entityData.set(STATE, (Object)state);
    }

    public Vec3 getShatterDirection() {
        return this.settings.direction;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STATE, (Object)Blocks.STONE.defaultBlockState());
    }

    public void sendPairingData(ServerPlayer player, Consumer<CustomPacketPayload> bundleBuilder) {
        super.sendPairingData(player, bundleBuilder);
        bundleBuilder.accept((CustomPacketPayload)new EarthShatterEntitySpawnPacket(this, this.settings));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.settings = new EarthShatterSettings();
        this.settings.autoLoad("settings", tag);
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.settings.autoSave("settings", tag);
        tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return super.shouldRender(p_20296_, p_20297_, p_20298_);
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

