/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.kinetic_field;

import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChesedKineticFieldEntity
extends FDEntity {
    public static final int KINETIC_FIELD_SQUARE_RADIUS = 5;

    public ChesedKineticFieldEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.getAnimationSystem().startAnimation("SPAWN", AnimationTicker.builder(BossAnims.CHESED_KINETIC_FIELD_SPAWN).build());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.tickCount == 4) {
            double radius = this.getSquareRadius();
            this.spawnSpearParticles(-radius, -radius);
            this.spawnSpearParticles(-radius, radius);
            this.spawnSpearParticles(radius, radius);
            this.spawnSpearParticles(radius, -radius);
        }
        this.getAnimationSystem().setVariable("variable.radius", (float)this.getSquareRadius() * 16.0f);
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        if (this.level().isClientSide) {
            double radius = this.getSquareRadius();
            this.spawnSpearParticles(-radius, -radius);
            this.spawnSpearParticles(-radius, radius);
            this.spawnSpearParticles(radius, radius);
            this.spawnSpearParticles(radius, -radius);
        }
    }

    public boolean isPickable() {
        return true;
    }

    private void spawnSpearParticles(double offsetX, double offsetZ) {
        Vec3 pos = this.position();
        Vec3 spear = pos.add(offsetX, 0.0, offsetZ);
        Vec3 between = spear.subtract(pos).normalize();
        int height = 5;
        for (float i = 0.0f; i < (float)height; i += 0.25f) {
            float p = i / ((float)height - 1.0f);
            Vec3 add = between.multiply((double)p, (double)p, (double)p);
            BallParticleOptions options = BallParticleOptions.builder().friction(0.8f).size(0.5f + this.random.nextFloat() * 0.2f).scalingOptions(2, 10, 10).color(100 + this.random.nextInt(50), 255, 255).build();
            Vec3 v = spear.add(add.x, (double)i, add.z);
            Vec3 speed = new Vec3(0.25 * (double)this.random.nextFloat() + 0.25, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
            this.level().addParticle((ParticleOptions)options, v.x, v.y, v.z, speed.x, 0.0, speed.z);
        }
    }

    public VoxelShape getCollisionShape(Entity player) {
        double rad = this.getSquareRadius();
        Vec3 pos = this.position();
        AABB box = new AABB(pos.x - rad, pos.y - 0.1, pos.z - rad, pos.x + rad, pos.y + 3.0, pos.z + rad).inflate(0.025);
        if (box.contains(player.position()) || box.contains(player.position().add(0.0, (double)player.getBbHeight(), 0.0))) {
            return Shapes.join((VoxelShape)Shapes.INFINITY, (VoxelShape)Shapes.create((AABB)box), (BooleanOp)BooleanOp.ONLY_FIRST);
        }
        return Shapes.empty();
    }

    public double getSquareRadius() {
        return 5.0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
    }
}

