/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah;

import com.finderfeed.fdbosses.content.entities.geburah.sins.PlayerSinsHandler;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ExplosiveCrystalItem
extends Item {
    public ExplosiveCrystalItem(Item.Properties props) {
        super(props.stacksTo(1).durability(450));
    }

    public void inventoryTick(ItemStack item, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        super.inventoryTick(item, level, entity, p_41407_, p_41408_);
        if (!level.isClientSide) {
            item.setDamageValue(item.getDamageValue() + 1);
            if (item.getDamageValue() >= item.getMaxDamage()) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    PlayerSinsHandler.sin(player, 20);
                }
                item.setCount(0);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.level().isClientSide) {
            ItemStack item = entity.getItem();
            item.setDamageValue(item.getDamageValue() + 1);
            entity.setItem(item.copy());
            if (item.getDamageValue() >= item.getMaxDamage()) {
                BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(0.25f).scalingOptions(0, 0, 10).color(0.3f, 0.7f, 1.0f).friction(0.7f).build();
                ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ballParticleOptions, entity.getX(), entity.getY() + (double)entity.getBbHeight(), entity.getZ(), 70, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.4f);
                entity.discard();
            }
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> text, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, text, p_41424_);
    }
}

