/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.casts;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.geburah.GeburahBossBuddy;
import com.finderfeed.fdbosses.content.entities.geburah.casts.GeburahCastingCircle;
import com.finderfeed.fdbosses.content.entities.geburah.particles.geburah_ray.GeburahRayOptions;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class GeburahRayCastingCircle
extends GeburahCastingCircle {
    public static GeburahRayCastingCircle summon(Level level, Vec3 pos, Vec3 dir) {
        GeburahRayCastingCircle castCircle = new GeburahRayCastingCircle(BossEntities.GEBURAH_CASTING_CIRCLE_RAY.get(), level);
        castCircle.setPos(pos);
        castCircle.setDirection(dir);
        castCircle.setCastDuration(0);
        castCircle.getEntityData().set(COLOR, (Object)-14483457);
        level.addFreshEntity((Entity)castCircle);
        return castCircle;
    }

    public GeburahRayCastingCircle(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void cast() {
        Vec3 end = this.position().add(this.getCastDirection().scale(20.0));
        ClipContext clipContext = new ClipContext(this.position(), end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult res = this.level().clip(clipContext);
        end = res.getLocation();
        this.level().playSound(null, end.x, end.y, end.z, BossSounds.GEBURAH_RAY_SHOT.get(), SoundSource.HOSTILE, 2.0f, 1.0f);
        List entities = FDHelpers.traceEntities((Level)this.level(), (Vec3)this.position(), (Vec3)end, (double)0.0, e -> {
            if (!(e instanceof LivingEntity)) return false;
            LivingEntity livingEntity = (LivingEntity)e;
            if (e instanceof GeburahBossBuddy) return false;
            return true;
        });
        float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().geburahConfig.judgementBirdDamage);
        for (Entity entity : entities) {
            entity.hurt(BossDamageSources.GEBURAH_LASER_STRIKE_SOURCE, damage);
        }
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().amplitude(1.0f).outTime(5).frequency(20.0f).build(), (Vec3)end, (double)40.0);
        GeburahRayOptions options = GeburahRayOptions.builder().width(0.25f).color(0.3f, 0.8f, 1.0f, 1.0f).end(end).stay(2).out(3).build();
        FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)options, (Vec3)this.position(), (double)120.0);
        if (res.getType() != HitResult.Type.MISS) {
            BossUtil.judgementBirdRayParticles((ServerLevel)this.level(), end, 100.0, this.position().subtract(end).normalize());
        }
    }
}

