/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.chain_trap;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.geburah.judgement_bird.JudgementBirdEntity;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.FDTargetFinder;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GeburahChainTrapEntity
extends Entity
implements AutoSerializable {
    public static int CATCH_TIME = 10;
    public static int PULL_TIME = 4;
    public static final EntityDataAccessor<Integer> ENTITY_ABOUT_TO_TRAP = SynchedEntityData.defineId(GeburahChainTrapEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @SerializableField
    private UUID entityAboutToTrap;
    @SerializableField
    private int catchTicks = 0;
    protected int catchingTime = -1;
    protected int pullingTime = -1;
    private Vec3 lastKnownTargetPos;

    public GeburahChainTrapEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getPassengers().isEmpty()) {
                LivingEntity entityAboutToTrap = this.getEntityAboutToTrap();
                if (entityAboutToTrap != null) {
                    GeburahChainTrapEntity e;
                    Entity entity;
                    if (entityAboutToTrap.isDeadOrDying() || (entity = entityAboutToTrap.getVehicle()) instanceof GeburahChainTrapEntity && (e = (GeburahChainTrapEntity)entity) != this) {
                        this.setRemoved(Entity.RemovalReason.DISCARDED);
                        return;
                    }
                    if (this.catchingTime == -1) {
                        this.catchingTime = CATCH_TIME;
                    } else if (this.catchingTime == 0) {
                        entityAboutToTrap.startRiding((Entity)this, true);
                    }
                    this.getEntityData().set(ENTITY_ABOUT_TO_TRAP, (Object)entityAboutToTrap.getId());
                } else {
                    for (LivingEntity entity : FDTargetFinder.getEntitiesInCylinder(LivingEntity.class, (Level)this.level(), (Vec3)this.position().add(0.0, -0.1, 0.0), (float)5.0f, (float)1.5f)) {
                        Player player;
                        if (entity instanceof Player && !BossUtil.isPlayerInSurvival(player = (Player)entity) || entity.getVehicle() instanceof GeburahChainTrapEntity) continue;
                        this.trapEntity(entity);
                        break;
                    }
                }
            } else {
                LivingEntity livingEntity;
                Object e = this.getPassengers().getFirst();
                if (e instanceof LivingEntity && (livingEntity = (LivingEntity)e).isDeadOrDying()) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
                this.tickCaughtEntity();
            }
        } else if (this.level().getGameTime() % 2L == 0L) {
            BallParticleOptions ballParticle = BallParticleOptions.builder().color(0.3f, 0.8f + this.random.nextFloat() * 0.2f, 1.0f).size(0.15f).brightness(3).scalingOptions(0, 0, 20).build();
            Vec3 rndOffset = new Vec3((double)(this.random.nextFloat() * 0.2f) + 0.3, 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
            this.level().addParticle((ParticleOptions)ballParticle, this.getX() + rndOffset.x, this.getY(), this.getZ() + rndOffset.z, 0.0, (double)0.05f, 0.0);
        }
        if (this.catchingTime != -1) {
            this.catchingTime = Mth.clamp((int)(this.catchingTime - 1), (int)0, (int)CATCH_TIME);
        }
        if (this.pullingTime != -1) {
            this.pullingTime = Mth.clamp((int)(this.pullingTime - 1), (int)0, (int)PULL_TIME);
        }
    }

    private void tickCaughtEntity() {
        if (!this.getPassengers().isEmpty()) {
            Entity entity = (Entity)this.getPassengers().getFirst();
            int duration = 600;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                duration = 60;
            }
            if (this.catchTicks > duration) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            ++this.catchTicks;
        }
    }

    public boolean isPickable() {
        return true;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (accessor == ENTITY_ABOUT_TO_TRAP && this.getPassengers().isEmpty()) {
            this.catchingTime = CATCH_TIME;
        }
    }

    public void trapEntity(LivingEntity entity) {
        if (entity.distanceTo((Entity)this) > 20.0f) {
            return;
        }
        this.entityAboutToTrap = entity.getUUID();
        this.getEntityData().set(ENTITY_ABOUT_TO_TRAP, (Object)entity.getId());
    }

    public LivingEntity getEntityAboutToTrap() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(this.entityAboutToTrap);
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        } else {
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(ENTITY_ABOUT_TO_TRAP)).intValue());
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        Vec3 height = entity.getVehicleAttachmentPoint((Entity)this);
        if (this.lastKnownTargetPos == null) {
            this.lastKnownTargetPos = entity.position().add(height);
        }
        if (this.pullingTime == -1) {
            this.pullingTime = PULL_TIME;
        }
        float p = 1.0f - (float)this.pullingTime / (float)PULL_TIME;
        Vec3 target = this.position().add(height);
        Vec3 pos = FDMathUtil.interpolateVectors((Vec3)this.lastKnownTargetPos, (Vec3)target, (float)p);
        if (entity instanceof JudgementBirdEntity) {
            pos = pos.add(0.0, 1.0, 0.0);
        }
        return pos;
    }

    public Vec3 getVehicleAttachmentPoint(Entity p_316322_) {
        return Vec3.ZERO;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public int getCatchingTime() {
        return this.catchingTime;
    }

    protected void defineSynchedData(SynchedEntityData.Builder b) {
        b.define(ENTITY_ABOUT_TO_TRAP, (Object)-1);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.autoSave(tag);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.autoLoad(tag);
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

