/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.geburah_explosive_crystal;

import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossItems;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.systems.trails.FDTrailDataGenerator;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class GeburahSinCrystal
extends FDEntity
implements AutoSerializable {
    @SerializableField
    private UUID playerToFlyTo;
    public FDTrailDataGenerator<GeburahSinCrystal> trail;

    public static GeburahSinCrystal summon(Vec3 pos, Player player, Vec3 initialDirection) {
        GeburahSinCrystal crystal = new GeburahSinCrystal(BossEntities.GEBURAH_SIN_CRYSTAL.get(), player.level());
        crystal.playerToFlyTo = player.getUUID();
        crystal.setDeltaMovement(initialDirection.normalize());
        crystal.setPos(pos);
        player.level().addFreshEntity((Entity)crystal);
        return crystal;
    }

    public GeburahSinCrystal(EntityType<?> type, Level level) {
        super(type, level);
        if (level.isClientSide) {
            this.trail = new FDTrailDataGenerator(Entity::getPosition, 5, 0.01f);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.flyToTargetPlayer();
            this.setPos(this.position().add(this.getDeltaMovement()));
        } else {
            this.setPos(this.position().add(this.getDeltaMovement()));
            this.trail.tick((Object)this);
        }
    }

    public void flyToTargetPlayer() {
        Player player = this.getTargetPlayer();
        if (player == null || player.isDeadOrDying()) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
        Vec3 targetPos = this.getTargetPos(player);
        if (this.position().distanceTo(targetPos) < 1.0) {
            this.putCrystalInPlayersInventory(player);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        float p = FDEasings.easeOut((float)Mth.clamp((float)((float)this.tickCount / 100.0f), (float)0.0f, (float)1.0f));
        Vec3 currentSpeed = this.getDeltaMovement();
        Vec3 targetSpeed = targetPos.subtract(this.position());
        Vector3d currentSpeedv = new Vector3d(currentSpeed.x, currentSpeed.y, currentSpeed.z).normalize();
        Vector3d targetSpeedv = new Vector3d(targetSpeed.x, targetSpeed.y, targetSpeed.z).normalize();
        Vector3d axis = currentSpeedv.cross((Vector3dc)targetSpeedv, new Vector3d());
        double angleBetween = currentSpeedv.angle((Vector3dc)targetSpeedv);
        currentSpeedv.rotateAxis(angleBetween * (double)p, axis.x, axis.y, axis.z);
        float spMod = 1.0f;
        this.setDeltaMovement(currentSpeedv.x * (double)spMod, currentSpeedv.y * (double)spMod, currentSpeedv.z * (double)spMod);
    }

    public Player getTargetPlayer() {
        if (this.playerToFlyTo == null) {
            return null;
        }
        return ((ServerLevel)this.level()).getPlayerByUUID(this.playerToFlyTo);
    }

    public void putCrystalInPlayersInventory(Player player) {
        Inventory inventory = player.getInventory();
        NonNullList items = inventory.items;
        int randomSlot = this.random.nextInt(items.size());
        ItemStack cr = (ItemStack)items.get(randomSlot);
        for (int tries = 100; (cr.is(BossItems.GEBURAH_EXPLOSIVE_CRYSTAL.get()) || Inventory.isHotbarSlot((int)randomSlot)) && tries > 0; --tries) {
            randomSlot = this.random.nextInt(items.size());
            cr = (ItemStack)items.get(randomSlot);
        }
        ItemStack itemInSlot = (ItemStack)items.get(randomSlot);
        items.set(randomSlot, BossItems.GEBURAH_EXPLOSIVE_CRYSTAL.get().getDefaultInstance());
        if (!itemInSlot.isEmpty()) {
            int freeSlot = inventory.getFreeSlot();
            if (freeSlot != -1) {
                items.set(freeSlot, itemInSlot.copy());
            } else {
                ItemEntity item = new ItemEntity(this.level(), player.getX(), player.getY() + (double)(player.getBbHeight() / 2.0f), player.getZ(), itemInSlot.copy());
                Vec3 speed = player.getLookAngle().scale(0.5);
                item.setDefaultPickUpDelay();
                item.setDeltaMovement(speed);
                this.level().addFreshEntity((Entity)item);
            }
        }
        inventory.setChanged();
        this.level().playSound(null, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 2.0f);
    }

    public Vec3 getTargetPos(Player player) {
        return player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.autoSave(tag);
    }
}

