/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_giant_sword;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticleOptions;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.chesed_boss.falling_block.ChesedFallingBlock;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessor;
import com.finderfeed.fdlib.systems.particle.particle_emitter.ParticleEmitterData;
import com.finderfeed.fdlib.systems.particle.particle_emitter.processors.BoundToEntityProcessor;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthGiantSwordSlash
extends Entity
implements AutoSerializable {
    public static int TIME_TO_RISE = 60;
    public static int TIME_TO_HIT = 30;
    public static int DISSOLVE_TIME = 30;
    public static final EntityDataAccessor<MalkuthAttackType> MALKUTH_ATTACK_TYPE = SynchedEntityData.defineId(MalkuthGiantSwordSlash.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    @SerializableField
    private boolean doDamage = true;
    @SerializableField
    private float damage;
    @SerializableField
    private int serverTicks;

    public static MalkuthGiantSwordSlash summon(Level level, Vec3 pos, Vec3 direction, MalkuthAttackType attackType, float damage) {
        MalkuthGiantSwordSlash slash = new MalkuthGiantSwordSlash(BossEntities.MALKUTH_GIANT_SWORD.get(), level);
        direction = direction.multiply(1.0, 0.0, 1.0).normalize();
        slash.setAttackType(attackType);
        slash.setPos(pos);
        slash.lookAt(EntityAnchorArgument.Anchor.FEET, pos.add(direction));
        slash.damage = damage;
        level.addFreshEntity((Entity)slash);
        return slash;
    }

    public MalkuthGiantSwordSlash(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        ++this.serverTicks;
        if (this.level().isClientSide) {
            if (this.tickCount == TIME_TO_HIT + TIME_TO_RISE) {
                this.impactParticles();
            }
            if (this.tickCount > 3 && this.tickCount < TIME_TO_RISE - 20) {
                this.riseParticles();
            }
        } else if (this.serverTicks == TIME_TO_HIT + TIME_TO_RISE) {
            this.impactBlocks();
            this.doDamage();
        } else if (this.serverTicks >= TIME_TO_HIT + TIME_TO_RISE + DISSOLVE_TIME) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void doDamage() {
        if (this.doDamage) {
            Vec3 direction = new Vec3(0.0, 0.0, 1.0).yRot(-((float)Math.toRadians(this.getYRot())));
            float offset = 7.5f;
            Vec3 start = this.position().add(direction.multiply((double)offset, (double)offset, (double)offset)).add(0.0, -1.0, 0.0);
            List<LivingEntity> targets = BossTargetFinder.getEntitiesInHorizontalBox(LivingEntity.class, this.level(), start, new Vec2((float)direction.x, (float)direction.z), 32.0f, 20.0f, 10.0f, entity -> !(entity instanceof MalkuthBossBuddy));
            for (LivingEntity target : targets) {
                target.hurt((DamageSource)new MalkuthDamageSource(this.level().damageSources().generic(), this.getAttackType(), 100), this.damage);
            }
        }
    }

    public void setDoDamage(boolean doDamage) {
        this.doDamage = doDamage;
    }

    public boolean isDoDamage() {
        return this.doDamage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    private void riseParticles() {
        for (int i = 0; i < 10; ++i) {
            Vector3f color = MalkuthEntity.getMalkuthAttackPreparationParticleColor(this.getAttackType());
            color.x = Math.clamp(color.x + 0.2f, 0.0f, 1.0f);
            color.y = Math.clamp(color.y + 0.2f, 0.0f, 1.0f);
            color.z = Math.clamp(color.z + 0.2f, 0.0f, 1.0f);
            float rndRadius = FDEasings.easeOut((float)this.random.nextFloat()) * 4.0f;
            Vec3 rnd = new Vec3((double)rndRadius, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
            float speedf = 0.05f + this.random.nextFloat() * 0.8f;
            Vec3 speed = rnd.normalize().multiply((double)speedf, 0.0, (double)speedf).add(0.0, (double)(speedf * 1.5f), 0.0);
            Vec3 ppos = this.position().add(rnd);
            BallParticleOptions options = BallParticleOptions.builder().scalingOptions(5, 0, 10).color(color.x, color.y, color.z).size(0.15f + (1.0f - speedf / 0.85f) * 0.5f).friction(0.8f).brightness(2).build();
            this.level().addParticle((ParticleOptions)options, true, ppos.x, ppos.y, ppos.z, speed.x, speed.y, speed.z);
        }
        float rndRadius = 7.0f + FDEasings.easeOut((float)this.random.nextFloat()) * 3.0f;
        Vec3 rnd = new Vec3((double)rndRadius, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
        Vec3 dir = rnd.normalize();
        float startOffsetRand = 3.0f + this.random.nextFloat() * 2.0f;
        Vec3 startOffset = dir.multiply((double)startOffsetRand, (double)startOffsetRand, (double)startOffsetRand);
        Vec3 stripePos = this.position().add(startOffset);
        Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(this.getAttackType());
        FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
        FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
        float firstPointOffset = 2.0f + this.random.nextFloat() * 2.0f;
        float secondPointOffset = 6.0f + this.random.nextFloat() * 2.0f;
        StripeParticleOptions stripeParticleOptions = StripeParticleOptions.builder().startColor(fireColorStart).endColor(fireColor).lifetime(20).lod(50).scale(0.24f).stripePercentLength(0.5f).endOutPercent(0.2f).startInPercent(0.2f).offsets(new Vec3((double)0.01f, 0.0, 0.0), dir.multiply((double)firstPointOffset, 0.0, (double)firstPointOffset).add(0.0, 3.0, 0.0), dir.multiply((double)secondPointOffset, 0.0, (double)secondPointOffset).add(0.0, 7.0, 0.0), rnd.add(0.0, 12.0, 0.0)).build();
        this.level().addParticle((ParticleOptions)stripeParticleOptions, true, stripePos.x, stripePos.y, stripePos.z, 0.0, 0.0, 0.0);
    }

    private void impactBlocks() {
        float start = 10.0f;
        float end = 40.0f;
        Vec3 direction = new Vec3(0.0, 0.0, 1.0).yRot(-((float)Math.toRadians(this.getYRot())));
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().frequency(50.0f).amplitude(1.0f).inTime(0).stayTime(0).outTime(50).build(), (Vec3)this.position().add(direction.x * (double)((end - start) / 2.0f), direction.y * (double)((end - start) / 2.0f), direction.z * (double)((end - start) / 2.0f)), (double)60.0);
        float step = 0.4f;
        for (float i = start; i <= end; i += step) {
            Vec3 offset = direction.multiply((double)i, (double)i, (double)i);
            Vec3 pos = this.position().add(offset);
            BlockState state = this.randomParticleBlock();
            float verticalSpeed = this.random.nextFloat() * 0.5f + 0.25f;
            float horizontalSpeed = 0.05f + this.random.nextFloat() * 0.8f;
            int m = this.random.nextInt(2) == 1 ? -1 : 1;
            Vec3 rndVec = direction.yRot((1.5707964f - 0.7853982f * this.random.nextFloat()) * (float)m).multiply((double)horizontalSpeed, (double)horizontalSpeed, (double)horizontalSpeed);
            Vec3 speed = rndVec.add(0.0, (double)verticalSpeed, 0.0);
            ChesedFallingBlock block = ChesedFallingBlock.summon(this.level(), state, pos, speed, 0.0f);
            block.softerSound = true;
            float rnd = this.random.nextFloat() * 0.05f;
            FDLibCalls.addParticleEmitter((Level)this.level(), (double)120.0, (ParticleEmitterData)ParticleEmitterData.builder((ParticleOptions)BigSmokeParticleOptions.builder().color(0.35f - rnd, 0.35f - rnd, 0.35f - rnd).lifetime(0, 0, 25).size(1.5f).build()).lifetime(200).processor((EmitterProcessor)new BoundToEntityProcessor(block.getId(), Vec3.ZERO)).position(this.position()).build());
        }
    }

    private void impactParticles() {
        float start = 10.0f;
        float end = 40.0f;
        Vec3 direction = new Vec3(0.0, 0.0, 1.0).yRot(-((float)Math.toRadians(this.getYRot())));
        int bigsmokerows = 4;
        float step = 0.5f;
        for (float i = start; i <= end; i += step) {
            Vec3 p;
            float v;
            Vec3 speed;
            Vec3 rndVec;
            int m;
            float horizontalSpeed;
            float verticalSpeed;
            int g;
            Vec3 offset = direction.multiply((double)i, (double)i, (double)i);
            Vec3 pos = this.position().add(offset);
            for (g = 0; g <= 4; ++g) {
                verticalSpeed = this.random.nextFloat() * 0.5f + 0.05f;
                horizontalSpeed = 0.05f + this.random.nextFloat() * 0.8f;
                m = this.random.nextInt(2) == 1 ? -1 : 1;
                rndVec = direction.yRot(1.5707964f * (float)m).multiply((double)horizontalSpeed, (double)horizontalSpeed, (double)horizontalSpeed);
                speed = rndVec.add(0.0, (double)verticalSpeed, 0.0);
                v = this.random.nextFloat() * step - step / 2.0f;
                p = pos.add(direction.multiply((double)v, (double)v, (double)v));
                Vector3f col = MalkuthEntity.getMalkuthAttackPreparationParticleColor(this.getAttackType());
                float size = 0.5f + this.random.nextFloat() * 2.0f;
                BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(size).color(col.x, col.y + 0.2f, col.z).friction(0.8f).brightness(2).scalingOptions(0, 0, 40 + this.random.nextInt(20)).build();
                float speedm = 2.0f;
                this.level().addParticle((ParticleOptions)ballParticleOptions, true, p.x, p.y, p.z, speed.x * (double)speedm, speed.y * (double)speedm, speed.z * (double)speedm);
            }
            for (g = 0; g <= 3; ++g) {
                verticalSpeed = this.random.nextFloat() * 0.6f + 0.05f;
                horizontalSpeed = 0.05f + this.random.nextFloat() * 0.4f;
                m = this.random.nextInt(2) == 1 ? -1 : 1;
                rndVec = direction.yRot(1.5707964f * (float)m).multiply((double)horizontalSpeed, (double)horizontalSpeed, (double)horizontalSpeed);
                speed = rndVec.add(0.0, (double)verticalSpeed, 0.0);
                v = this.random.nextFloat() * step - step / 2.0f;
                p = pos.add(direction.multiply((double)v, (double)v, (double)v));
                ParticleOptions particleOptions = this.randomParticle();
                float speedm = 2.0f;
                this.level().addParticle(particleOptions, true, p.x, p.y, p.z, speed.x * (double)speedm, speed.y * (double)speedm, speed.z * (double)speedm);
            }
            for (g = 0; g <= bigsmokerows; ++g) {
                Object options;
                float p2 = (float)g / ((float)bigsmokerows - 1.0f);
                Vec3 dir1 = direction.yRot(1.5707964f);
                Vec3 dir2 = direction.yRot(-1.5707964f);
                float v2 = this.random.nextFloat() * step - step / 2.0f;
                float v22 = this.random.nextFloat() * step - step / 2.0f;
                Vec3 ppos = pos.add(direction.multiply((double)v2, (double)v2, (double)v2));
                Vec3 ppos2 = pos.add(direction.multiply((double)v22, (double)v22, (double)v22));
                if (this.random.nextFloat() > 0.1f) {
                    float col = this.random.nextFloat() * 0.4f + 0.2f;
                    options = BigSmokeParticleOptions.builder().lifetime(0, 0, 60 + this.random.nextInt(20)).friction(0.9f - p2 * 0.1f).size(3.0f - p2 * 1.5f).color(col, col, col).minSpeed(0.05f).build();
                } else {
                    Vector3f col = MalkuthEntity.getMalkuthAttackPreparationParticleColor(this.getAttackType());
                    options = BallParticleOptions.builder().size(3.0f - p2 * 1.5f).color(col.x, col.y + 0.2f, col.z).friction(0.9f - p2 * 0.1f).scalingOptions(0, 0, 40 + this.random.nextInt(20)).build();
                }
                float speed2 = p2 * 2.0f + 0.15f + this.random.nextFloat() * 1.5f * (p2 + 0.5f);
                float rndy = this.random.nextFloat() * (1.0f - p2) * 0.25f;
                float rndy2 = this.random.nextFloat() * (1.0f - p2) * 0.25f;
                this.level().addParticle((ParticleOptions)options, true, ppos.x, ppos.y + (double)rndy, ppos.z, dir1.x * (double)speed2, dir1.y * (double)speed2, dir1.z * (double)speed2);
                this.level().addParticle((ParticleOptions)options, true, ppos2.x, ppos2.y + (double)rndy2, ppos2.z, dir2.x * (double)speed2, dir2.y * (double)speed2, dir2.z * (double)speed2);
            }
        }
    }

    private ParticleOptions randomParticle() {
        if (this.getAttackType().isFire()) {
            if (this.random.nextFloat() > 0.5f) {
                GravityParticleOptions particleOptions = new GravityParticleOptions(BossParticles.FLAME_WITH_STONE.get(), 40 + this.random.nextInt(4), 0.75f + this.random.nextFloat() * 0.25f, 1.5999999f, 2.0f, true);
                return particleOptions;
            }
            return ParticleTypes.LAVA;
        }
        GravityParticleOptions particleOptions = new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 40 + this.random.nextInt(4), 0.75f + this.random.nextFloat() * 0.25f, 1.5999999f, 2.0f, true);
        return particleOptions;
    }

    private BlockState randomParticleBlock() {
        if (this.random.nextFloat() > 0.5f) {
            if (this.getAttackType() == MalkuthAttackType.ICE) {
                return Blocks.BLUE_ICE.defaultBlockState();
            }
            return Blocks.MAGMA_BLOCK.defaultBlockState();
        }
        return Blocks.BLACKSTONE.defaultBlockState();
    }

    public float getCurrentMoveUpTime(float pticks) {
        return Math.clamp((float)this.tickCount + pticks, 0.0f, (float)TIME_TO_RISE);
    }

    public float getCurrentHitTime(float pticks) {
        return Math.clamp((float)(this.tickCount - TIME_TO_RISE) + pticks, 0.0f, (float)TIME_TO_HIT);
    }

    public float getDissolveTime(float pticks) {
        return Math.clamp((float)(this.tickCount - TIME_TO_RISE - TIME_TO_HIT) + pticks, 0.0f, (float)DISSOLVE_TIME);
    }

    public MalkuthAttackType getAttackType() {
        return (MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE));
    }

    public void setAttackType(MalkuthAttackType type) {
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)type);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("mtype")) {
            this.setAttackType(MalkuthAttackType.valueOf(tag.getString("mtype")));
        }
        this.autoLoad(tag);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("mtype", this.getAttackType().name());
        this.autoSave(tag);
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

