/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_platform;

import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthPlatform
extends FDEntity {
    public static final EntityDataAccessor<Boolean> CAN_BE_COLLIDED_WITH = SynchedEntityData.defineId(MalkuthPlatform.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public MalkuthPlatform(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.setNoGravity(true);
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.tickCount > 20) {
                this.entityData.set(CAN_BE_COLLIDED_WITH, (Object)true);
            }
        } else if (this.tickCount > 40 && this.tickCount % 10 == 0) {
            Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(MalkuthAttackType.FIRE);
            FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
            FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
            StripeParticleOptions stripeParticleOptions = StripeParticleOptions.createHorizontalCircling(fireColorStart, fireColor, new Vec3((double)0.01f, 1.0, 0.0), this.random.nextFloat() * (float)Math.PI * 2.0f, 0.2f, 20, 50, 6.0f, 4.0f, 2.0f, 0.5f, false, false);
            this.level().addParticle((ParticleOptions)stripeParticleOptions, true, this.getX(), this.getY() - 6.0, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
    }

    public void onClientRemoval() {
        super.onClientRemoval();
        for (int i = 0; i < 150; ++i) {
            Vector3f color = MalkuthEntity.getAndRandomizeColor(MalkuthAttackType.FIRE, this.random);
            BallParticleOptions ballParticleOptions = BallParticleOptions.builder().color(color.x, color.y, color.z).scalingOptions(0, 0, 20).size(0.25f + this.random.nextFloat() * 0.1f).friction(0.8f).brightness(2).build();
            float p = FDEasings.easeOut((float)this.random.nextFloat());
            float h = p * 6.0f;
            float v = p * 4.0f;
            Vec3 offs = new Vec3((double)v, 0.0, 0.0).yRot(this.random.nextFloat() * (float)Math.PI * 2.0f);
            Vec3 ppos = this.position().add(offs.x, (double)(-6.0f + h), offs.z);
            this.level().addParticle((ParticleOptions)ballParticleOptions, ppos.x, ppos.y, ppos.z, (double)this.random.nextFloat() - 0.5, (double)this.random.nextFloat() - 0.5, (double)this.random.nextFloat() - 0.5);
        }
    }

    public void kill() {
        super.kill();
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
    }

    public void push(Vec3 p_347665_) {
    }

    public void push(Entity p_20293_) {
    }

    public boolean canBeCollidedWith() {
        return (Boolean)this.entityData.get(CAN_BE_COLLIDED_WITH);
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CAN_BE_COLLIDED_WITH, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(CAN_BE_COLLIDED_WITH, (Object)tag.getBoolean("can_collide"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("can_collide", ((Boolean)this.entityData.get(CAN_BE_COLLIDED_WITH)).booleanValue());
    }
}

