/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_slash;

import com.finderfeed.fdbosses.client.particles.malkuth_slash.MalkuthHorizontalSlashOptions;
import com.finderfeed.fdbosses.client.particles.rush_particle.RushParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal.MalkuthRepairCrystal;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;

public class MalkuthSlashProjectile
extends FDProjectile
implements AutoSerializable {
    public static final float HEIGHT_SIZE_MODIFIER = 0.3461538f;
    public static final EntityDataAccessor<Integer> INCREMENT_SIZE_TIME = SynchedEntityData.defineId(MalkuthSlashProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> MAX_SLASH_SIZE = SynchedEntityData.defineId(MalkuthSlashProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.defineId(MalkuthSlashProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<MalkuthAttackType> ATTACK_TYPE = SynchedEntityData.defineId(MalkuthSlashProjectile.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    private int currentIncrementSizeTime = 0;
    private float slashSizeOld = 0.0f;
    private float slashSizeCurrent = 0.0f;
    @SerializableField
    private float damage = 2.0f;
    private double distanceTravelled;
    private double distanceTravelledO;

    public MalkuthSlashProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public static MalkuthSlashProjectile summon(Level level, Vec3 pos, Vec3 speed, MalkuthAttackType malkuthAttackType, float damage, float slashSize, float rotation, int incrementSizeTime) {
        MalkuthSlashProjectile malkuthSlashProjectile = new MalkuthSlashProjectile(BossEntities.MALKUTH_SLASH.get(), level);
        malkuthSlashProjectile.setPos(pos);
        malkuthSlashProjectile.setDeltaMovement(speed);
        malkuthSlashProjectile.setAttackType(malkuthAttackType);
        malkuthSlashProjectile.entityData.set(INCREMENT_SIZE_TIME, (Object)incrementSizeTime);
        malkuthSlashProjectile.setMaxSlashSize(slashSize);
        malkuthSlashProjectile.damage = damage;
        malkuthSlashProjectile.setRotation(rotation);
        level.addFreshEntity((Entity)malkuthSlashProjectile);
        return malkuthSlashProjectile;
    }

    public void tick() {
        Vec3 oldPos = this.position();
        super.tick();
        this.tickSizeIncrement();
        Vec3 newPos = this.position();
        if (!this.level().isClientSide) {
            this.tickDamage();
            if (this.tickCount > 2000) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.distanceTravelledO = this.distanceTravelled;
            this.distanceTravelled += newPos.subtract(oldPos).length();
            this.slashParticles();
            this.tickParticles();
        }
    }

    private void tickSizeIncrement() {
        float size;
        this.slashSizeOld = this.slashSizeCurrent;
        int incrementSizeTime = (Integer)this.entityData.get(INCREMENT_SIZE_TIME);
        if (incrementSizeTime == 0) {
            this.slashSizeCurrent = this.getMaxSlashSize();
            this.slashSizeOld = this.getMaxSlashSize();
            return;
        }
        float p = Math.clamp((float)this.currentIncrementSizeTime / (float)incrementSizeTime, 0.0f, 1.0f);
        this.slashSizeCurrent = size = this.getMaxSlashSize() * p;
        this.currentIncrementSizeTime = Mth.clamp((int)(this.currentIncrementSizeTime + 1), (int)0, (int)incrementSizeTime);
    }

    private void slashParticles() {
        if (this.getSlashSize() == 0.0f || this.tickCount < 5) {
            return;
        }
        Vec3 movement = this.getDeltaMovement();
        double distance = this.distanceTravelled - this.distanceTravelledO;
        float height = this.getSlashSize() * 0.3461538f;
        Vec3 pos = FDMathUtil.interpolateVectors((Vec3)this.position(), (Vec3)new Vec3(this.xo, this.yo, this.zo), (float)0.5f).add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
        Vec3 n = movement.normalize().reverse().multiply((double)0.025f, (double)0.025f, (double)0.025f);
        for (double i = 0.0; i <= distance - (double)height * movement.length(); i += (double)height) {
            Vec3 nmovement = movement.normalize();
            double offset = (double)height + i;
            pos = pos.add(nmovement.reverse().multiply(offset, offset, offset));
            MalkuthHorizontalSlashOptions options = new MalkuthHorizontalSlashOptions(this.getAttackType(), this.getDeltaMovement(), this.getSlashSize() * 0.9f, this.getRotation(), 5);
            this.level().addParticle((ParticleOptions)options, true, pos.x, pos.y, pos.z, -n.x, -n.y, -n.z);
        }
    }

    private void tickParticles() {
        if (this.getSlashSize() == 0.0f) {
            return;
        }
        Vec3 pos = FDMathUtil.interpolateVectors((Vec3)this.position(), (Vec3)new Vec3(this.xo, this.yo, this.zo), (float)0.5f).add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
        Vec3 movement = this.getDeltaMovement();
        if (movement.equals((Object)Vec3.ZERO)) {
            return;
        }
        Vec3 left = movement.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 nmovement = movement.normalize();
        Quaternionf quaternionf = new Quaternionf(new AxisAngle4f((float)Math.toRadians(-this.getRotation()), (float)nmovement.x, (float)nmovement.y, (float)nmovement.z));
        Vector3d leftd = new Vector3d(left.x, left.y, left.z);
        quaternionf.transform(leftd);
        left = new Vec3(leftd.x, leftd.y, leftd.z);
        float slashLeftOffset = 0.3f;
        float height = this.getSlashSize() * 0.3461538f;
        for (float i = 0.0f; i <= this.getSlashSize(); i += slashLeftOffset) {
            Vec3 offsetPos = pos.add(left.multiply((double)i, (double)i, (double)i));
            Vec3 offsetPos2 = pos.add(left.multiply((double)(-i), (double)(-i), (double)(-i)));
            float p = FDEasings.easeOut((float)(1.0f - i / this.getSlashSize()));
            float l = 0.0f;
            while ((double)l < movement.length()) {
                float b;
                float g;
                float r;
                Vec3 noffset = nmovement.multiply((double)(height * p), (double)(height * p), (double)(height * p));
                Vec3 n = nmovement.multiply((double)(-l), (double)(-l), (double)(-l)).add(noffset).add(nmovement.reverse().multiply((double)height, (double)height, (double)height));
                float lmult = this.random.nextFloat() * slashLeftOffset - slashLeftOffset / 2.0f;
                Vec3 offsetPos12 = offsetPos.add(n).add(left.multiply((double)lmult, (double)lmult, (double)lmult));
                Vec3 offsetPos22 = offsetPos2.add(n).add(left.multiply((double)lmult, (double)lmult, (double)lmult));
                if (this.getAttackType() == MalkuthAttackType.FIRE) {
                    r = 0.8f + 0.2f * this.random.nextFloat();
                    g = 0.3f + 0.2f * this.random.nextFloat();
                    b = 0.05f + 0.05f * this.random.nextFloat();
                } else {
                    r = 0.2f + 0.2f * this.random.nextFloat();
                    g = 0.8f + 0.2f * this.random.nextFloat();
                    b = 0.8f + 0.2f * this.random.nextFloat();
                }
                Object particleOptions = this.random.nextFloat() > 0.1f ? BallParticleOptions.builder().size(0.05f + this.random.nextFloat() * 0.05f).scalingOptions(0, 0, 3).color(r, g, b).build() : new RushParticleOptions(movement.reverse(), new FDColor(r, g, b, 1.0f), this.random.nextFloat() * 0.5f + 0.25f, 0.05f + this.random.nextFloat() * 0.025f, 2 + this.random.nextInt(2));
                this.level().addParticle((ParticleOptions)particleOptions, true, offsetPos12.x, offsetPos12.y, offsetPos12.z, (double)(this.random.nextFloat() * 0.05f - 0.025f), (double)(this.random.nextFloat() * 0.05f - 0.025f), (double)(this.random.nextFloat() * 0.05f - 0.025f));
                this.level().addParticle((ParticleOptions)particleOptions, true, offsetPos22.x, offsetPos22.y, offsetPos22.z, (double)(this.random.nextFloat() * 0.05f - 0.025f), (double)(this.random.nextFloat() * 0.05f - 0.025f), (double)(this.random.nextFloat() * 0.05f - 0.025f));
                l += 0.3f;
            }
        }
    }

    private void tickDamage() {
        Vec3 pos = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
        Vec3 movement = this.getDeltaMovement();
        if (movement.equals((Object)Vec3.ZERO)) {
            return;
        }
        Vec3 left = movement.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 nmovement = movement.normalize();
        Quaternionf quaternionf = new Quaternionf(new AxisAngle4f((float)Math.toRadians(-this.getRotation()), (float)nmovement.x, (float)nmovement.y, (float)nmovement.z));
        Vector3d leftd = new Vector3d(left.x, left.y, left.z);
        quaternionf.transform(leftd);
        left = new Vec3(leftd.x, leftd.y, leftd.z);
        ArrayList<Entity> damagedEntities = new ArrayList<Entity>();
        for (float i = 0.0f; i < this.getSlashSize(); i += 0.2f) {
            this.hurtTargetsOnOffset(damagedEntities, pos, movement, left, i);
        }
        this.hurtTargetsOnOffset(damagedEntities, pos, movement, left, this.getSlashSize());
    }

    private void hurtTargetsOnOffset(List<Entity> damagedEntities, Vec3 pos, Vec3 movement, Vec3 left, float offset) {
        Vec3 offsetPos = pos.add(left.multiply((double)offset, (double)offset, (double)offset));
        Vec3 offsetPos2 = pos.add(left.multiply((double)(-offset), (double)(-offset), (double)(-offset)));
        List targets = FDHelpers.traceEntities((Level)this.level(), (Vec3)offsetPos, (Vec3)offsetPos.add(movement), (double)0.0, e -> !(e instanceof MalkuthBossBuddy));
        List targets2 = FDHelpers.traceEntities((Level)this.level(), (Vec3)offsetPos2, (Vec3)offsetPos2.add(movement), (double)0.0, e -> !(e instanceof MalkuthBossBuddy));
        targets.addAll(targets2);
        for (Entity e2 : targets) {
            if (damagedEntities.contains(e2)) continue;
            if (e2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)e2;
                livingEntity.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_SLASHES_SOURCE, this.getAttackType(), 33), this.getDamage());
            } else if (e2 instanceof MalkuthRepairCrystal) {
                MalkuthRepairCrystal repairCrystal = (MalkuthRepairCrystal)e2;
                repairCrystal.destroyAndSummonRepairMaterial();
            }
            damagedEntities.add(e2);
        }
    }

    protected void onHitBlock(BlockHitResult p_37258_) {
        super.onHitBlock(p_37258_);
        if (this.tickCount > 3) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public float getMaxSlashSize() {
        return ((Float)this.entityData.get(MAX_SLASH_SIZE)).floatValue();
    }

    public float getSlashSize() {
        return this.slashSizeCurrent;
    }

    public float getSlashSize(float partialTicks) {
        if (!this.level().isClientSide) {
            return this.getSlashSize();
        }
        return FDMathUtil.lerp((float)this.slashSizeOld, (float)this.getSlashSize(), (float)partialTicks);
    }

    public void setMaxSlashSize(float size) {
        this.entityData.set(MAX_SLASH_SIZE, (Object)Float.valueOf(size));
    }

    public float getRotation() {
        return ((Float)this.entityData.get(ROTATION)).floatValue();
    }

    public void setRotation(float rotation) {
        this.entityData.set(ROTATION, (Object)Float.valueOf(rotation));
    }

    public MalkuthAttackType getAttackType() {
        return (MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE));
    }

    public void setAttackType(MalkuthAttackType malkuthAttackType) {
        this.entityData.set(ATTACK_TYPE, (Object)malkuthAttackType);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAX_SLASH_SIZE, (Object)Float.valueOf(1.0f));
        builder.define(INCREMENT_SIZE_TIME, (Object)0);
        builder.define(ROTATION, (Object)Float.valueOf(0.0f));
        builder.define(ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("slashSize", this.getSlashSize());
        tag.putFloat("rotation", this.getRotation());
        tag.putString("attackType", this.getAttackType().name());
        tag.putInt("incrementSizeTime", ((Integer)this.entityData.get(INCREMENT_SIZE_TIME)).intValue());
        this.autoSave(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setRotation(tag.getFloat("rotation"));
        this.setMaxSlashSize(tag.getFloat("slashSize"));
        if (tag.contains("attackType")) {
            this.setAttackType(MalkuthAttackType.valueOf(tag.getString("attackType")));
        }
        this.entityData.set(INCREMENT_SIZE_TIME, (Object)tag.getInt("incrementSizeTime"));
        this.autoLoad(tag);
    }
}

