/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_warrior;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.base.BossMonsterMob;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_earthquake.MalkuthEarthquake;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.TransitionAnimation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.HeadControllerContainer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.IHasHead;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackChain;
import com.finderfeed.fdlib.systems.entity.action_chain.AttackInstance;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class MalkuthWarriorEntity
extends BossMonsterMob
implements IHasHead<MalkuthWarriorEntity>,
MalkuthBossBuddy {
    public static float DISTANCE_TO_ATTACK = 1.75f;
    public static final EntityDataAccessor<MalkuthAttackType> WARRIOR_TYPE = SynchedEntityData.defineId(MalkuthWarriorEntity.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    public static final String SIMPLE_HIT = "simple_axe_hit";
    public static final String EARTH_SLAM_ATTACK = "earth_slam_attack";
    public static final String MAIN_LAYER = "main";
    private static FDModel CLIENT_MODEL;
    private boolean wasNormalAttackCancelled = false;
    private int slamCooldown = 0;
    public AttackChain attackChain;

    public MalkuthWarriorEntity(EntityType<? extends BossMonsterMob> type, Level level, MalkuthAttackType initialType) {
        super(type, level);
        this.xpReward = 20;
        this.entityData.set(WARRIOR_TYPE, (Object)initialType);
        if (level.isClientSide && CLIENT_MODEL == null) {
            CLIENT_MODEL = new FDModel(BossModels.MALKUTH_WARRIOR.get());
        }
        this.lookControl = new HeadControllerContainer((Mob)this).addHeadController(CLIENT_MODEL, "head");
        this.attackChain = new AttackChain(this.level().random).registerAttack(SIMPLE_HIT, this::simpleAxeAttack).registerAttack(EARTH_SLAM_ATTACK, this::earthSlamAttack).addAlwaysTryCastAttack(this::canCastSlamAttack, EARTH_SLAM_ATTACK).addAttack(0, SIMPLE_HIT);
        this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_IDLE).build());
    }

    public boolean earthSlamAttack(AttackInstance instance) {
        LivingEntity target = this.getTarget();
        int stage = instance.stage;
        int tick = instance.tick;
        if (stage == 0) {
            if (target == null) {
                return true;
            }
            this.getNavigation().stop();
            this.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_SLAM_EARTH).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_IDLE).build()).build());
            instance.nextStage();
            this.getHeadControllerContainer().setControllersMode(HeadControllerContainer.Mode.ANIMATION);
        } else if (stage == 1) {
            if (tick == 14) {
                if (target != null) {
                    this.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
                }
            } else if (tick == 17) {
                double dist = 13.0;
                Vec3 forward = this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(dist, dist, dist);
                SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(this.getOnPos(), this.position().add(0.0, 0.5, 0.0), forward.normalize()).maxAngle((float)Math.PI).maxSpeed(0.5f).collectRadius(2).maxParticleLifetime(30).count(40).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.4f));
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.level().playSound(null, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), BossSounds.MALKUTH_SWORD_EARTH_IMPACT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.malkuthWarriorEarthSlamDamage);
                MalkuthEarthquake malkuthEarthquake = MalkuthEarthquake.summon(this.level(), (MalkuthAttackType)((Object)this.entityData.get(WARRIOR_TYPE)), this.position(), forward, 20, 0.5235988f, damage);
            } else if (tick >= 25) {
                this.wasNormalAttackCancelled = false;
                this.slamCooldown = 20;
                this.getHeadControllerContainer().setControllersMode(HeadControllerContainer.Mode.LOOK);
                return true;
            }
        }
        return false;
    }

    public boolean canCastSlamAttack() {
        LivingEntity target = this.getTarget();
        if (target != null) {
            float distance = target.distanceTo((Entity)this);
            if (distance <= DISTANCE_TO_ATTACK || distance >= 10.0f) {
                return false;
            }
            double yDiff = this.getY() - target.getY();
            if (yDiff > (double)-0.1f && yDiff < 1.5) {
                return this.wasNormalAttackCancelled && this.slamCooldown <= 0;
            }
        }
        return false;
    }

    public boolean simpleAxeAttack(AttackInstance attackInstance) {
        LivingEntity target = this.getTarget();
        int stage = attackInstance.stage;
        int tick = attackInstance.tick;
        if (stage == 0) {
            this.wasNormalAttackCancelled = false;
            if (target != null) {
                Vec3 targetPos = target.position();
                double dist = this.position().distanceTo(targetPos);
                if (dist > (double)DISTANCE_TO_ATTACK) {
                    if ((double)this.level().random.nextFloat() < 0.015) {
                        this.wasNormalAttackCancelled = true;
                        return true;
                    }
                    if (this.level().getGameTime() % 5L == 0L) {
                        this.getNavigation().moveTo((Entity)target, 1.0);
                    }
                } else {
                    this.getNavigation().stop();
                    this.getHeadControllerContainer().setControllersMode(HeadControllerContainer.Mode.ANIMATION);
                    this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_ATTACK).important().nextAnimation(AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_IDLE).build()).build());
                    attackInstance.nextStage();
                }
                this.getLookControl().setLookAt((Entity)target);
            }
        } else if (stage == 1) {
            if (tick == 0 && target != null) {
                this.lookAt(EntityAnchorArgument.Anchor.EYES, target.position());
            }
            if (tick == 5) {
                this.level().playSound(null, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), BossSounds.MALKUTH_SLASH.get(), SoundSource.HOSTILE, 1.0f, 1.0f + this.random.nextFloat() * 0.5f);
            } else if (tick == 10) {
                float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().malkuthConfig.malkuthWarriorDamage);
                MalkuthAttackType type = (MalkuthAttackType)((Object)this.entityData.get(WARRIOR_TYPE));
                for (LivingEntity t : this.getTargetsForAxeAttack()) {
                    t.hurt((DamageSource)new MalkuthDamageSource(this.level().damageSources().generic(), type, 50), damage);
                }
            } else if (tick >= 15) {
                this.getHeadControllerContainer().setControllersMode(HeadControllerContainer.Mode.LOOK);
                return true;
            }
        }
        return false;
    }

    private List<LivingEntity> getTargetsForAxeAttack() {
        Vec3 forward = this.getForward().multiply(1.0, 0.0, 1.0).normalize();
        float cylinderOffset = 1.25f;
        Vec3 cylinderStart = this.position().add(forward.multiply((double)cylinderOffset, 0.0, (double)cylinderOffset)).add(0.0, -1.01, 0.0);
        List<LivingEntity> list = BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), cylinderStart, 2.5f, 0.75f, entity -> !(entity instanceof MalkuthBossBuddy));
        Vec2 direction = new Vec2((float)forward.x, (float)forward.z);
        List<LivingEntity> list2 = BossTargetFinder.getEntitiesInArc(LivingEntity.class, this.level(), this.position().add(0.0, -1.01, 0.0), direction, 1.5707964f, 2.5f, 1.0f, entity -> !(entity instanceof MalkuthBossBuddy));
        list.addAll(list2);
        return list;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WARRIOR_TYPE, (Object)MalkuthAttackType.FIRE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public void tick() {
                super.tick();
                Vec3 lookAt = this.mob.position().add(this.mob.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(100.0, 100.0, 100.0));
                this.mob.getLookControl().setLookAt(lookAt);
            }

            public boolean canUse() {
                return super.canUse() && MalkuthWarriorEntity.super.getTarget() == null;
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean canUse() {
                return super.canUse() && MalkuthWarriorEntity.super.getTarget() == null;
            }
        });
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                return super.canUse() && MalkuthWarriorEntity.super.getTarget() == null;
            }
        });
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (!this.isDeadOrDying()) {
                this.getHeadControllerContainer().clientTick();
                AnimationTicker ticker = this.getAnimationSystem().getTicker(MAIN_LAYER);
                if (ticker == null) {
                    this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_IDLE).build());
                } else {
                    Animation anim = ticker.getAnimation();
                    if (anim instanceof TransitionAnimation) {
                        TransitionAnimation tr = (TransitionAnimation)anim;
                        anim = tr.getTransitionTo();
                    }
                    if (anim == BossAnims.MALKUTH_WARRIOR_IDLE.get()) {
                        if (this.walkAnimation.speed() > 0.05f) {
                            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_WALK).setToNullTransitionTime(5).setSpeed(2.0f).build());
                        }
                    } else if (anim == BossAnims.MALKUTH_WARRIOR_WALK.get() && this.walkAnimation.speed() < 0.05f) {
                        this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_IDLE).build());
                    }
                }
            }
        } else {
            if (this.tickCount == 1) {
                Vec3 forward = this.getForward().multiply(1.0, 0.0, 1.0).normalize().multiply(100.0, 100.0, 100.0);
                this.getLookControl().setLookAt(this.position().add(forward).add(0.0, (double)this.getEyeHeight(), 0.0));
            }
            if (!this.isDeadOrDying()) {
                this.slamCooldown = Math.clamp((long)(this.slamCooldown - 1), 0, Integer.MAX_VALUE);
                this.attackChain.tick();
                this.setYRot(this.yBodyRot);
            }
        }
    }

    public void die(DamageSource p_21014_) {
        super.die(p_21014_);
        if (!this.level().isClientSide) {
            this.getAnimationSystem().startAnimation(MAIN_LAYER, AnimationTicker.builder(BossAnims.MALKUTH_WARRIOR_DIE).build());
        }
    }

    protected SoundEvent getHurtSound(DamageSource p_33034_) {
        return BossSounds.MALKUTH_WARRIOR_HIT.get();
    }

    protected SoundEvent getDeathSound() {
        return BossSounds.MALKUTH_WARRIOR_HIT.get();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("mtype", ((MalkuthAttackType)((Object)this.entityData.get(WARRIOR_TYPE))).name());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("mtype")) {
            this.entityData.set(WARRIOR_TYPE, (Object)MalkuthAttackType.valueOf(tag.getString("mtype")));
        }
    }

    public HeadControllerContainer<MalkuthWarriorEntity> getHeadControllerContainer() {
        return (HeadControllerContainer)this.lookControl;
    }

    public boolean canBeLeashed() {
        return false;
    }
}

