/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.items.chesed;

import com.finderfeed.fdbosses.init.BossCoreShaders;
import com.finderfeed.fdbosses.init.BossItems;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDShaderRenderer;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="fdbosses", value={Dist.CLIENT})
public class PhaseSphereOverlay
implements LayeredDraw.Layer {
    private static Boolean smartCull;
    public static final int MAX_PROGRESS = 20;
    private static int progress;
    private static int progressO;

    public void render(GuiGraphics graphics, DeltaTracker tracker) {
        if (Minecraft.getInstance().level == null || progress == 0) {
            return;
        }
        ShaderInstance shader = BossCoreShaders.CHESED_ITEM_OVERLAY;
        Window window = Minecraft.getInstance().getWindow();
        float width = window.getGuiScaledWidth();
        float height = window.getGuiScaledHeight();
        float pticks = tracker.getGameTimeDeltaPartialTick(false);
        float gametime = Minecraft.getInstance().level.getGameTime() % 2000000L;
        float time = gametime + pticks;
        float progress = FDMathUtil.lerp((float)progressO, (float)PhaseSphereOverlay.progress, (float)pticks) / 20.0f;
        FDShaderRenderer.start((GuiGraphics)graphics, (ShaderInstance)shader).setShaderUniform("progress", new float[]{FDEasings.easeOut((float)progress)}).setShaderUniform("size", new float[]{width, height}).setShaderUniform("time", new float[]{time / 200.0f}).setResolution(width, height).end();
        RenderSystem.defaultBlendFunc();
    }

    @SubscribeEvent
    public static void tickClient(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (progress == 0) {
            if (smartCull != null) {
                Minecraft.getInstance().smartCull = smartCull;
                smartCull = null;
            }
        } else {
            if (smartCull == null) {
                smartCull = Minecraft.getInstance().smartCull;
            }
            Minecraft.getInstance().smartCull = false;
        }
        if (player == null) {
            progress = 0;
            return;
        }
        progressO = progress;
        progress = player.getUseItem().is(BossItems.PHASE_SPHERE.get()) ? Mth.clamp((int)(progress + 1), (int)0, (int)20) : Mth.clamp((int)(progress - 1), (int)0, (int)20);
    }
}

