/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.debug;

import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.systems.music.data.FDMusicData;
import com.finderfeed.fdlib.systems.music.data.FDMusicPartData;
import com.finderfeed.fdlib.systems.music.music_areas.FDMusicArea;
import com.finderfeed.fdlib.systems.music.music_areas.FDMusicAreasHandler;
import com.finderfeed.fdlib.systems.music.music_areas.shapes.FDMusicAreaCylinder;
import com.finderfeed.fdlib.systems.music.music_areas.shapes.FDMusicAreaShape;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class DebugStick
extends Item {
    public DebugStick(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            if (!player.isCrouching()) {
                FDMusicData data = new FDMusicData(MalkuthEntity.BOSS_MUSIC_UUID, new FDMusicPartData(BossSounds.GEBURAH_THEME.get(), 109.7f).setLooping(true)).fadeInTime(80).inactiveDeleteTime(600);
                FDMusicAreasHandler.addArea((UUID)MalkuthEntity.BOSS_MUSIC_UUID, (FDMusicArea)new FDMusicArea(player.level().dimension(), player.position(), (FDMusicAreaShape)new FDMusicAreaCylinder(10.0f, 10.0f), data));
            } else {
                FDMusicAreasHandler.removeArea((MinecraftServer)((ServerLevel)level).getServer(), (UUID)MalkuthEntity.BOSS_MUSIC_UUID, (int)40);
            }
        }
        return super.use(level, player, hand);
    }

    private static void createGeburahArenaCircleAtPos(Level level, BlockPos pos, int endRadius, float percent, int wholeRadius) {
        float startRadius = percent * (float)endRadius;
        for (int x = -wholeRadius; x <= wholeRadius; ++x) {
            for (int z = -wholeRadius; z <= wholeRadius; ++z) {
                Vec3 v = new Vec3((double)((float)x + 0.001f), 0.0, (double)((float)z + 0.001f));
                double len = v.length();
                float angle = (float)FDMathUtil.angleBetweenVectors((Vec3)v.normalize(), (Vec3)new Vec3(1.0, 0.0, 0.0)) % 1.5707964f;
                float p = angle < 0.7853982f ? angle / 0.7853982f : 1.0f - (angle - 0.7853982f) / 0.7853982f;
                float currentRadius = FDMathUtil.lerp((float)startRadius, (float)endRadius, (float)FDEasings.easeInOut((float)(1.0f - p)));
                BlockPos offsetPos = pos.offset(x, 0, z);
                if (!(len < (double)currentRadius) || !level.getBlockState(offsetPos).isAir()) continue;
                level.setBlock(offsetPos, Blocks.END_STONE.defaultBlockState(), 2);
            }
        }
    }
}

