/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.packets;

import com.finderfeed.fdbosses.BossClientPackets;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.util.FDByteBufCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdbosses:slam_particles")
public class SlamParticlesPacket
extends FDPacket {
    private SlamData slamData;

    public SlamParticlesPacket(SlamData data) {
        this.slamData = data;
    }

    public SlamParticlesPacket(FriendlyByteBuf buf) {
        this.slamData = (SlamData)SlamData.STREAM_CODEC.decode((Object)buf);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        SlamData.STREAM_CODEC.encode((Object)buf, (Object)this.slamData);
    }

    public void clientAction(IPayloadContext context) {
        BossClientPackets.blockProjectileSlamParticles(this.slamData);
    }

    public void serverAction(IPayloadContext context) {
    }

    public static class SlamData {
        public static final StreamCodec<FriendlyByteBuf, SlamData> STREAM_CODEC = FDByteBufCodecs.composite((StreamCodec)FDByteBufCodecs.VEC3, v -> v.pos, (StreamCodec)FDByteBufCodecs.VEC3, v -> v.direction, (StreamCodec)FDByteBufCodecs.BLOCK_POS, v -> v.bPos, (StreamCodec)ByteBufCodecs.INT, v -> v.collectRadius, (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.maxSpeed), (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.maxVerticalSpeedEdges), (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.maxVerticalSpeedCenter), (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.perRowDivide), (StreamCodec)ByteBufCodecs.INT, v -> v.count, (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.maxAngle), (StreamCodec)ByteBufCodecs.INT, v -> v.maxParticleLifetime, (StreamCodec)ByteBufCodecs.FLOAT, v -> Float.valueOf(v.particleSizeMult), (pos, direction, bPos, collectRadius, maxSpeed, maxVerticalSpeedEdges, maxVerticalSpeedCenter, perRowDivide, count, maxAngle, maxParticleLifetime, particleSize) -> {
            SlamData data = new SlamData((BlockPos)bPos, (Vec3)pos, (Vec3)direction);
            data.maxSpeed = maxSpeed.floatValue();
            data.collectRadius = collectRadius;
            data.maxVerticalSpeedEdges = maxVerticalSpeedEdges.floatValue();
            data.maxVerticalSpeedCenter = maxVerticalSpeedCenter.floatValue();
            data.count = count;
            data.maxAngle = maxAngle.floatValue();
            data.perRowDivide = perRowDivide.floatValue();
            data.maxParticleLifetime = maxParticleLifetime;
            data.particleSizeMult = particleSize.floatValue();
            return data;
        });
        public Vec3 pos;
        public Vec3 direction;
        public BlockPos bPos;
        public int collectRadius = 3;
        public float maxSpeed = 0.75f;
        public float maxVerticalSpeedEdges = 0.4f;
        public float maxVerticalSpeedCenter = 0.6f;
        public float particleSizeMult = 2.0f;
        public float perRowDivide = 0.25f;
        public int count = 30;
        public int maxParticleLifetime = 60;
        public float maxAngle = 1.0471976f;

        public SlamData(BlockPos bPos, Vec3 pos, Vec3 direction) {
            this.pos = pos;
            this.bPos = bPos;
            this.direction = direction;
        }

        public SlamData particleSizeMultiplier(float mult) {
            this.particleSizeMult = mult;
            return this;
        }

        public SlamData maxAngle(float maxAngle) {
            this.maxAngle = maxAngle;
            return this;
        }

        public SlamData perRowDivide(float perRowDivide) {
            this.perRowDivide = perRowDivide;
            return this;
        }

        public SlamData count(int count) {
            this.count = count;
            return this;
        }

        public SlamData maxParticleLifetime(int lifetime) {
            this.maxParticleLifetime = lifetime;
            return this;
        }

        public SlamData collectRadius(int collectRadius) {
            this.collectRadius = collectRadius;
            return this;
        }

        public SlamData maxSpeed(float maxSpeed) {
            this.maxSpeed = maxSpeed;
            return this;
        }

        public SlamData maxVerticalSpeedEdges(float speed) {
            this.maxVerticalSpeedEdges = speed;
            return this;
        }

        public SlamData maxVerticalSpeedCenter(float speed) {
            this.maxVerticalSpeedCenter = speed;
            return this;
        }
    }
}

