/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations;

import com.finderfeed.fdlib.shunting_yard.RPNVector3f;
import com.finderfeed.fdlib.systems.bedrock.animations.AnimationContext;
import com.finderfeed.fdlib.systems.bedrock.animations.BoneAnimationData;
import com.finderfeed.fdlib.systems.bedrock.animations.InterpolationMode;
import com.finderfeed.fdlib.systems.bedrock.animations.KeyFrame;
import com.finderfeed.fdlib.systems.bedrock.animations.TransitionAnimation;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class Animation {
    public static final String TRANSITION = "transition";
    public static final String TO_NULL_TRANSITION = "transition_to_null";
    private ResourceLocation name;
    private ResourceLocation fileLocation;
    private int animTime;
    private LoopMode defaultLoopMode;
    private HashMap<String, BoneAnimationData> datas;

    public Animation() {
    }

    public Animation(ResourceLocation fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void applyAnimation(AnimationContext context, FDModel model, float elapsedTime) {
        try {
            for (Map.Entry<String, BoneAnimationData> entry : this.datas.entrySet()) {
                BoneAnimationData data = entry.getValue();
                data.apply(model, context, elapsedTime);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while applying animation: " + String.valueOf(this.getName()), e);
        }
    }

    public Animation createTransitionTo(AnimationContext context, Animation next, float elapsedTime, int toNullTime, boolean nextReversed) {
        HashMap<String, BoneAnimationData> dataHashMap;
        Animation animation;
        if (next != null) {
            animation = new TransitionAnimation(next);
            animation.name = ResourceLocation.tryBuild((String)"fdlib", (String)TRANSITION);
            animation.defaultLoopMode = next.getDefaultLoopMode();
            animation.animTime = next.getAnimTime();
            dataHashMap = this.createToAnimationDatas(next, context, toNullTime, elapsedTime, nextReversed);
        } else {
            animation = new Animation();
            animation.name = ResourceLocation.tryBuild((String)"fdlib", (String)TO_NULL_TRANSITION);
            animation.defaultLoopMode = LoopMode.ONCE;
            animation.animTime = toNullTime;
            dataHashMap = this.createToNullDatas(context, toNullTime, elapsedTime);
        }
        animation.datas = dataHashMap;
        return animation;
    }

    private HashMap<String, BoneAnimationData> createToNullDatas(AnimationContext context, int toNullTime, float elapsedTime) {
        HashMap<String, BoneAnimationData> map = new HashMap<String, BoneAnimationData>();
        for (Map.Entry<String, BoneAnimationData> entry : this.datas.entrySet()) {
            BoneAnimationData data = entry.getValue().createTransitionData(null, null, context, toNullTime, elapsedTime, false);
            map.put(entry.getKey(), data);
        }
        return map;
    }

    private HashMap<String, BoneAnimationData> createToAnimationDatas(Animation next, AnimationContext context, int toNullTime, float elapsedTime, boolean reversed) {
        HashMap<String, BoneAnimationData> map = new HashMap<String, BoneAnimationData>(next.datas);
        for (Map.Entry<String, BoneAnimationData> entry : this.datas.entrySet()) {
            BoneAnimationData d = next.datas.get(entry.getKey());
            if (d == null && toNullTime == 0) continue;
            BoneAnimationData data = entry.getValue().createTransitionData(next, d, context, toNullTime, elapsedTime, reversed);
            map.put(entry.getKey(), data);
        }
        return map;
    }

    public boolean isTransition() {
        return this.name.getPath().equals(TRANSITION);
    }

    public boolean isToNullTransition() {
        return this.name.getPath().equals(TO_NULL_TRANSITION);
    }

    public LoopMode getDefaultLoopMode() {
        return this.defaultLoopMode;
    }

    public ResourceLocation getFileLocation() {
        return this.fileLocation;
    }

    public int getAnimTime() {
        return this.animTime;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Animation)) {
            return false;
        }
        Animation that = (Animation)obj;
        Animation animation = this;
        if (animation instanceof TransitionAnimation) {
            TransitionAnimation tthis = (TransitionAnimation)animation;
            if (that instanceof TransitionAnimation) {
                TransitionAnimation tthat = (TransitionAnimation)that;
                return tthis.getTransitionTo() == tthat.getTransitionTo();
            }
        }
        if ((animation = this) instanceof TransitionAnimation) {
            TransitionAnimation tthis = (TransitionAnimation)animation;
            return tthis.getTransitionTo() == that;
        }
        if (that instanceof TransitionAnimation) {
            TransitionAnimation tthat = (TransitionAnimation)that;
            return this == tthat.getTransitionTo();
        }
        return that == this;
    }

    public void load(ResourceLocation name, JsonObject object) {
        int length;
        this.name = name;
        LoopMode mode = this.parseLoopMode(name, object);
        this.animTime = length = Math.round(object.get("animation_length").getAsFloat() * 20.0f);
        JsonObject bones = object.getAsJsonObject("bones");
        HashMap<String, BoneAnimationData> animationDatas = new HashMap<String, BoneAnimationData>();
        for (Map.Entry entry : bones.entrySet()) {
            String boneName = (String)entry.getKey();
            JsonElement bone = (JsonElement)entry.getValue();
            BoneAnimationData data = this.parseData(boneName, bone.getAsJsonObject());
            animationDatas.put(boneName, data);
        }
        this.datas = animationDatas;
        this.defaultLoopMode = mode;
    }

    private BoneAnimationData parseData(String name, JsonObject object) {
        List<KeyFrame> positions = null;
        List<KeyFrame> rotations = null;
        List<KeyFrame> scales = null;
        if (object.has("position")) {
            positions = this.parseKeyFrames(KeyFrameLoadType.POSITION, object.get("position"));
        }
        if (object.has("rotation")) {
            rotations = this.parseKeyFrames(KeyFrameLoadType.ROTATION, object.get("rotation"));
        }
        if (object.has("scale")) {
            scales = this.parseKeyFrames(KeyFrameLoadType.SCALE, object.get("scale"));
        }
        BoneAnimationData data = new BoneAnimationData(name, positions, rotations, scales, true);
        return data;
    }

    private List<KeyFrame> parseKeyFrames(KeyFrameLoadType loadType, JsonElement keyFrames) {
        ArrayList<KeyFrame> frames = new ArrayList<KeyFrame>();
        if (keyFrames.isJsonObject()) {
            Map map = keyFrames.getAsJsonObject().asMap();
            for (Map.Entry entry : map.entrySet()) {
                int timestamp = Math.round(Float.parseFloat((String)entry.getKey()) * 20.0f);
                JsonElement keyframe = (JsonElement)entry.getValue();
                KeyFrame keyFrame = this.parseKeyFrame(loadType, timestamp, keyframe);
                frames.add(keyFrame);
            }
        } else if (keyFrames.isJsonArray()) {
            JsonArray array = keyFrames.getAsJsonArray();
            Object v1 = array.get(0).getAsString();
            Object v2 = array.get(1).getAsString();
            String v3 = array.get(2).getAsString();
            if (loadType == KeyFrameLoadType.POSITION) {
                v1 = "-(" + (String)v1 + ")";
            } else if (loadType == KeyFrameLoadType.ROTATION) {
                v1 = "-(" + (String)v1 + ")";
                v2 = "-(" + (String)v2 + ")";
            }
            frames.add(new KeyFrame(new RPNVector3f((String)v1, (String)v2, v3), 0, InterpolationMode.LINEAR));
        } else if (keyFrames.isJsonPrimitive()) {
            String value = keyFrames.getAsString();
            frames.add(new KeyFrame(new RPNVector3f(value, value, value), 0, InterpolationMode.LINEAR));
        }
        return frames;
    }

    private KeyFrame parseKeyFrame(KeyFrameLoadType type, int timestamp, JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                String value = element.getAsString();
                return new KeyFrame(new RPNVector3f(value, value, value), timestamp, InterpolationMode.LINEAR);
            }
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                Object v1 = array.get(0).getAsString();
                Object v2 = array.get(1).getAsString();
                String v3 = array.get(2).getAsString();
                if (type == KeyFrameLoadType.POSITION) {
                    v1 = "-(" + (String)v1 + ")";
                } else if (type == KeyFrameLoadType.ROTATION) {
                    v1 = "-(" + (String)v1 + ")";
                    v2 = "-(" + (String)v2 + ")";
                }
                return new KeyFrame(new RPNVector3f((String)v1, (String)v2, v3), timestamp, InterpolationMode.LINEAR);
            }
            if (element.isJsonObject()) {
                String v3;
                Object v2;
                Object v1;
                JsonArray array;
                JsonObject object = element.getAsJsonObject();
                RPNVector3f pre = null;
                if (object.has("pre")) {
                    array = object.getAsJsonArray("pre");
                    v1 = array.get(0).getAsString();
                    v2 = array.get(1).getAsString();
                    v3 = array.get(2).getAsString();
                    if (type == KeyFrameLoadType.POSITION) {
                        v1 = "-(" + (String)v1 + ")";
                    } else if (type == KeyFrameLoadType.ROTATION) {
                        v1 = "-(" + (String)v1 + ")";
                        v2 = "-(" + (String)v2 + ")";
                    }
                    pre = new RPNVector3f((String)v1, (String)v2, v3);
                }
                array = object.getAsJsonArray("post");
                v1 = array.get(0).getAsString();
                v2 = array.get(1).getAsString();
                v3 = array.get(2).getAsString();
                if (type == KeyFrameLoadType.POSITION) {
                    v1 = "-(" + (String)v1 + ")";
                } else if (type == KeyFrameLoadType.ROTATION) {
                    v1 = "-(" + (String)v1 + ")";
                    v2 = "-(" + (String)v2 + ")";
                }
                InterpolationMode mode = this.parseMode(object);
                return new KeyFrame(pre, new RPNVector3f((String)v1, (String)v2, v3), timestamp, mode);
            }
            throw new RuntimeException("Unknown keyframe format.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while loading animation: " + String.valueOf(this.name));
        }
    }

    private InterpolationMode parseMode(JsonObject keyFrame) {
        if (keyFrame.has("lerp_mode")) {
            String mode = keyFrame.get("lerp_mode").getAsString();
            if (mode.equals("catmullrom")) {
                return InterpolationMode.CATMULLROM;
            }
            throw new RuntimeException("Unknown lerp mode: " + mode);
        }
        return InterpolationMode.LINEAR;
    }

    private LoopMode parseLoopMode(ResourceLocation name, JsonObject animation) {
        if (animation.has("loop")) {
            JsonElement element = animation.get("loop");
            String s = element.getAsString();
            if (s.equals("true")) {
                return LoopMode.LOOP;
            }
            if (s.equals("hold_on_last_frame")) {
                return LoopMode.HOLD_ON_LAST_FRAME;
            }
            throw new RuntimeException("Unknown loop mode in animation: " + String.valueOf(name));
        }
        return LoopMode.ONCE;
    }

    public static enum LoopMode {
        LOOP,
        ONCE,
        HOLD_ON_LAST_FRAME;

    }

    private static enum KeyFrameLoadType {
        POSITION(-1.0f, 1.0f, 1.0f),
        ROTATION(-1.0f, -1.0f, 1.0f),
        SCALE(1.0f, 1.0f, 1.0f);

        float xMod;
        float yMod;
        float zMod;

        private KeyFrameLoadType(float x, float y, float z) {
            this.xMod = x;
            this.yMod = y;
            this.zMod = z;
        }
    }
}

