/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item;

import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationHandler;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemAnimationSystem;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDItemModelOptions;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.item.FDModelItemRendererOptions;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class FDModelItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public List<FDModel> models;
    public FDModelItemRendererOptions options;

    public FDModelItemRenderer(FDModelItemRendererOptions options) {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.options = options;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        FDItemAnimationHandler.tellItemThatItIsAlive(stack);
        FDItemAnimationSystem animationSystem = FDItemAnimationHandler.getItemAnimationSystem(stack);
        this.initModelsIfNecessary();
        float scale = this.options.scale.apply(displayContext).floatValue();
        if (displayContext == ItemDisplayContext.GUI) {
            translation = this.options.translation.apply(displayContext);
            matrices.translate(0.5 + (double)translation.x, (double)(0.25f + translation.y), 0.5 + (double)translation.z);
            matrices.mulPose(Axis.XP.rotationDegrees(35.0f));
            matrices.mulPose(Axis.YP.rotationDegrees(45.0f + this.options.rotation.apply(displayContext).floatValue()));
        } else {
            translation = this.options.translation.apply(displayContext);
            if (displayContext == ItemDisplayContext.GROUND) {
                matrices.translate(0.5 + (double)translation.x, 0.3 + (double)translation.y, 0.5 + (double)translation.z);
            } else {
                matrices.translate(0.5 + (double)translation.z, 0.5 + (double)translation.y, 0.5 + (double)translation.x);
            }
            matrices.mulPose(Axis.YP.rotationDegrees(this.options.rotation.apply(displayContext).floatValue()));
        }
        matrices.scale(scale, scale, scale);
        List<FDItemModelOptions> fdoptions = this.options.fdItemModelOptions;
        for (int i = 0; i < this.models.size(); ++i) {
            FDModel model = this.models.get(i);
            model.resetTransformations();
            animationSystem.applyAnimations(model, FDRenderUtil.getPartialTickWithPause());
            FDItemModelOptions option = fdoptions.get(i);
            RenderType renderType = option.getRenderType().renderType(displayContext, stack);
            VertexConsumer vertex = buffer.getBuffer(renderType);
            FDColor color = option.getFdItemColor().color(displayContext, stack);
            model.render(matrices, vertex, packedLight, OverlayTexture.NO_OVERLAY, color.r, color.g, color.b, color.a);
        }
    }

    private void initModelsIfNecessary() {
        if (this.models == null) {
            this.models = new ArrayList<FDModel>();
            for (FDItemModelOptions sup : this.options.fdItemModelOptions) {
                this.models.add(new FDModel(sup.getModelInfo().get()));
            }
        }
    }

    public static IClientItemExtensions createExtensions(final FDModelItemRendererOptions options) {
        return new IClientItemExtensions(){
            private FDModelItemRenderer renderer;
            {
                this.renderer = new FDModelItemRenderer(options);
            }

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        };
    }
}

