/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.shake;

import com.finderfeed.fdlib.systems.shake.FDScreenShake;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;

public class DefaultShake
extends FDScreenShake {
    private int oldTime;
    private double xo;
    private double yo;
    private ComplexEasingFunction easingFunction;

    public DefaultShake(FDShakeData data) {
        super(data);
        this.easingFunction = ComplexEasingFunction.builder().addArea(data.getInTime(), FDEasings::linear).addArea(data.getStayTime(), FDEasings::one).addArea(data.getOutTime(), FDEasings::reversedLinear).build();
    }

    @Override
    public void process(PoseStack projection, int time, float partialTicks) {
        float power = this.easingFunction.apply((float)time + partialTicks);
        long t = time + 1;
        Random random = new Random(t * 34324L);
        double x = this.randomN(random, power);
        double y = this.randomN(random, power);
        double xd = FDMathUtil.lerp(this.xo, x, (double)partialTicks);
        double yd = FDMathUtil.lerp(this.yo, y, (double)partialTicks);
        projection.translate(Double.isNaN(xd) ? 0.0 : xd, Double.isNaN(yd) ? 0.0 : yd, 0.0);
        if (this.oldTime != time) {
            this.oldTime = time;
            Random r = new Random(--t * 34324L);
            this.xo = this.randomN(r, power);
            this.yo = this.randomN(r, power);
        }
    }

    private double randomN(Random random, float power) {
        return (random.nextFloat() * this.getData().getAmplitude() * 2.0f - this.getData().getAmplitude()) * power;
    }
}

