/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_parser;

import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.TextBlockEntry;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_entries.SimpleTextEntry;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_parser.FDString;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_parser.TextBlockProcessor;
import com.finderfeed.fdlib.systems.simple_screen.fdwidgets.text_block.text_block_parser.TextBlockProcessors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class TextBlockParser {
    public static List<TextBlockEntry> parseComponent(Component component, float textScale, boolean renderShadow, int textColor) {
        ArrayList<TextBlockEntry> textBlockEntries = new ArrayList<TextBlockEntry>();
        ArrayList strings = new ArrayList();
        ArrayList correspondingStyles = new ArrayList();
        component.visit((style, string) -> {
            strings.add(string);
            correspondingStyles.add(style);
            return Optional.empty();
        }, Style.EMPTY);
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            Style style2 = (Style)correspondingStyles.get(i);
            TextBlockParser.parseString(str, style2, textScale, renderShadow, textColor, textBlockEntries);
        }
        return textBlockEntries;
    }

    private static void parseString(String s, Style stringStyle, float textScale, boolean renderShadow, int textColor, List<TextBlockEntry> entries) {
        StringBuilder reading = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char character = s.charAt(i);
            if (character == '{' && i + 1 < s.length() && s.charAt(i + 1) == '{') {
                Pair<FDString, Integer> pair = TextBlockParser.parseFDString(s, i);
                int lastIndex = (Integer)pair.second;
                s = lastIndex < s.length() ? s.substring(lastIndex) : "";
                i = -1;
                entries.add(new SimpleTextEntry(FormattedText.of((String)reading.toString(), (Style)stringStyle), textScale, renderShadow, textColor));
                reading = new StringBuilder();
                FDString string = (FDString)pair.first;
                TextBlockProcessor textBlockProcessor = string.getProcessor();
                HashMap<String, String> args = string.getArguments();
                List<TextBlockEntry> entriesToAdd = textBlockProcessor.parse(textScale, renderShadow, textColor, args);
                entries.addAll(entriesToAdd);
                continue;
            }
            reading.append(character);
        }
        if (!reading.isEmpty()) {
            entries.add(new SimpleTextEntry(FormattedText.of((String)reading.toString(), (Style)stringStyle), textScale, renderShadow, textColor));
        }
    }

    private static Pair<FDString, Integer> parseFDString(String s, int startIndex) {
        ResourceLocation id;
        if (s.charAt(startIndex) != '{' && s.charAt(startIndex + 1) != '{') {
            throw new RuntimeException("You didn't provide an FDString here!");
        }
        int lastIndex = 0;
        StringBuilder builder = new StringBuilder();
        try {
            for (int i = startIndex + 2; i < s.length(); ++i) {
                char character = s.charAt(i);
                if (character == '}' && s.charAt(i + 1) == '}') {
                    lastIndex = i + 2;
                    break;
                }
                builder.append(character);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException("FDString incorrect format! It should start with {{ and end with }}! String: " + s);
        }
        String typeAndArguments = builder.toString().replace(" ", "");
        builder = new StringBuilder();
        int argumentsStart = 0;
        char c = typeAndArguments.charAt(0);
        if (c != '(') {
            throw new RuntimeException("FDString incorrect format! After the {{ should come the processor type in parenthesis! Example: {{(fdlib:zhopa) arg1 = argval, arg2 = argval2}}. String: " + s);
        }
        int i = 1;
        try {
            while (true) {
                char character;
                if ((character = typeAndArguments.charAt(i)) == ')') {
                    argumentsStart = i + 1;
                    break;
                }
                ++i;
                builder.append(character);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException("FDString incorrect format! Couldn't find closing parenthesis while reading text processor type. String: " + s);
        }
        String processorId = builder.toString();
        try {
            id = ResourceLocation.parse((String)processorId);
        }
        catch (ResourceLocationException e) {
            throw new RuntimeException("Couldn't parse processor id! String: " + s, e);
        }
        TextBlockProcessor processor = TextBlockProcessors.getProcessor(id);
        if (processor == null) {
            throw new RuntimeException("Unknown text procossor type: " + processorId);
        }
        if (argumentsStart >= typeAndArguments.length()) {
            return new Pair<FDString, Integer>(new FDString(processor, new HashMap<String, String>()), lastIndex);
        }
        String args = typeAndArguments.substring(argumentsStart);
        HashMap<String, String> argmap = TextBlockParser.readArguments(args);
        return new Pair<FDString, Integer>(new FDString(processor, argmap), lastIndex);
    }

    private static HashMap<String, String> readArguments(String arguments) {
        HashMap<String, String> argumentMap = new HashMap<String, String>();
        StringBuilder argname = new StringBuilder();
        StringBuilder argument = new StringBuilder();
        boolean readingArgname = true;
        for (int i = 0; i < arguments.length(); ++i) {
            char c = arguments.charAt(i);
            if (readingArgname) {
                if (c != '=') {
                    argname.append(c);
                    continue;
                }
                readingArgname = false;
                continue;
            }
            if (c != ',') {
                argument.append(c);
                continue;
            }
            argumentMap.put(argname.toString(), argument.toString());
            argname = new StringBuilder();
            argument = new StringBuilder();
            readingArgname = true;
        }
        if (!argname.isEmpty() && !argument.isEmpty()) {
            argumentMap.put(argname.toString(), argument.toString());
        }
        return argumentMap;
    }
}

