/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.trails;

import com.finderfeed.fdlib.systems.trails.FDTrailPoint;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FDTrailDataGenerator<T> {
    private Vec3 previouslyDeletedPoint = null;
    private BiFunction<T, Float, Vec3> positionExtractor;
    private int maxPointsAmount;
    private List<FDTrailPoint> points = new ArrayList<FDTrailPoint>();
    private float minimumDistanceDeltaForNewPoint;

    public FDTrailDataGenerator(BiFunction<T, Float, Vec3> positionExtractor, int maxPointsInTrail, float minimumDistanceDeltaForNewPoint) {
        this.maxPointsAmount = Mth.clamp((int)maxPointsInTrail, (int)3, (int)20);
        this.positionExtractor = positionExtractor;
        this.minimumDistanceDeltaForNewPoint = minimumDistanceDeltaForNewPoint;
    }

    public void tick(T object) {
        this.previouslyDeletedPoint = null;
        this.tickNewPointsCreation(object);
        this.tickPoints();
    }

    private void tickNewPointsCreation(T object) {
        FDTrailPoint lastPoint;
        Vec3 last;
        Vec3 delta;
        double length;
        Vec3 currentPos = this.extractPosition(object, 0.0f);
        if (this.points.isEmpty()) {
            this.points.add(new FDTrailPoint(currentPos, this.calculatePointAge()));
        }
        if ((length = (delta = currentPos.subtract(last = (lastPoint = this.points.getLast()).getPos())).length()) >= (double)this.minimumDistanceDeltaForNewPoint) {
            this.points.add(new FDTrailPoint(currentPos, this.calculatePointAge()));
        }
    }

    private int calculatePointAge() {
        return this.maxPointsAmount - 1;
    }

    private void tickPoints() {
        Iterator<FDTrailPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            FDTrailPoint point = iterator.next();
            if (point.shouldBeRemoved()) {
                this.previouslyDeletedPoint = point.getPos();
                iterator.remove();
            }
            point.tick();
        }
    }

    public Vec3 extractPosition(T object, float partialTicks) {
        return this.positionExtractor.apply(object, Float.valueOf(partialTicks));
    }

    public List<FDTrailPoint> getPoints() {
        return this.points;
    }

    public List<Vector3f> getConvertedPointsForRendering(Vec3 currentObjectWorldPos, float pticks) {
        ArrayList<Vector3f> list = new ArrayList<Vector3f>();
        if (this.previouslyDeletedPoint != null) {
            FDTrailPoint first = this.getPoints().getFirst();
            Vec3 firstPos = first.getPos();
            Vec3 interpolated = FDMathUtil.interpolateVectors(this.previouslyDeletedPoint, firstPos, pticks);
            list.add(interpolated.subtract(currentObjectWorldPos).toVector3f());
        }
        for (FDTrailPoint point : this.getPoints()) {
            Vector3f newPoint = point.getPos().subtract(currentObjectWorldPos).toVector3f();
            list.add(newPoint);
        }
        list.add(new Vector3f(1.0E-4f, 0.0f, 1.0E-4f));
        return list;
    }

    public int getMaxPointsAmount() {
        return this.maxPointsAmount;
    }
}

