/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium.auxilium;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.StatManager;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.Supplier;

public class ModpackData {
    public int id = -1;
    public String name = "unknown";
    public String type = "unknown";
    public String version = "unknown";
    public int versionId = -1;
    public String versionType = "unknown";
    public String modLoader = "vanilla(bugged)";
    public float loadTime = -1.0f;
    public StatManager.Launchers launcher = StatManager.Launchers.UNKNOWN;

    public ModpackData() {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("metadata.json");
        if (!Files.exists(configDir, new LinkOption[0])) {
            this.getFallbackData();
            return;
        }
        JsonParser parser = new JsonParser();
        try {
            FileReader file = new FileReader(configDir.toFile());
            JsonElement metaDataJson = parser.parse((Reader)file);
            JsonObject metaDataObj = metaDataJson.getAsJsonObject();
            Triple<String, Integer, String> packData = this.getNameIdVersion(metaDataObj);
            this.name = (String)packData.getLeft();
            this.id = (Integer)packData.getMiddle();
            this.type = (String)packData.getRight();
            if (metaDataObj.has("version")) {
                Triple<String, Integer, String> versionData = this.getNameIdVersion(metaDataObj.get("version").getAsJsonObject());
                this.version = (String)versionData.getLeft();
                this.versionId = (Integer)versionData.getMiddle();
                this.versionType = (String)versionData.getRight();
            }
            FTBAuxilium.LOGGER.debug("Found packdata from metadata.json [data] -> {}", new Supplier[]{this::toString});
        }
        catch (FileNotFoundException e) {
            FTBAuxilium.LOGGER.debug("Failed to find metadata.json for pack data");
        }
    }

    public void getFallbackData() {
        Triple<String, Integer, String> nameIdVersion;
        FileReader file;
        String gameDir = Minecraft.getInstance().gameDirectory.getAbsolutePath();
        JsonParser parser = new JsonParser();
        if (Files.exists(Paths.get(gameDir + "/modpack.json", new String[0]), new LinkOption[0])) {
            try {
                file = new FileReader(gameDir + "/modpack.json");
                JsonElement modpackJson = parser.parse((Reader)file);
                nameIdVersion = this.getNameIdVersion(modpackJson.getAsJsonObject());
                this.name = (String)nameIdVersion.getLeft();
                this.id = (Integer)nameIdVersion.getMiddle();
                this.type = (String)nameIdVersion.getRight();
            }
            catch (JsonParseException | FileNotFoundException | NullPointerException e) {
                FTBAuxilium.LOGGER.debug("No modpack.json found or an issue was found with the json file.");
            }
        }
        if (Files.exists(Paths.get(gameDir + "/modpack.json", new String[0]), new LinkOption[0])) {
            try {
                file = new FileReader(gameDir + "/version.json");
                JsonElement versionJson = parser.parse((Reader)file);
                nameIdVersion = this.getNameIdVersion(versionJson.getAsJsonObject());
                this.version = (String)nameIdVersion.getLeft();
                this.versionId = (Integer)nameIdVersion.getMiddle();
                this.versionType = (String)nameIdVersion.getRight();
            }
            catch (JsonParseException | FileNotFoundException | NullPointerException e) {
                FTBAuxilium.LOGGER.debug("No version.json found or an issue was found with the json file.");
            }
        }
        FTBAuxilium.LOGGER.debug("Fallback to launcher jsons [data] -> {}", new Supplier[]{this::toString});
    }

    public Triple<String, Integer, String> getNameIdVersion(JsonObject object) {
        return Triple.of((Object)(object.has("name") ? object.get("name").getAsString() : "unknown"), (Object)(object.has("id") ? object.get("id").getAsInt() : -1), (Object)(object.has("type") ? object.get("type").getAsString().toLowerCase() : "unknown"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("version", (Object)this.version).add("versionId", this.versionId).add("versionType", (Object)this.versionType).toString();
    }
}

